/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.TypedQuery;
import jakarta.transaction.Transactional;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.wiki.jpa.dao.DraftPageDAO;
import org.exoplatform.wiki.jpa.dao.PageMoveDAO;
import org.exoplatform.wiki.jpa.dao.PageVersionDAO;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.model.WikiType;

public class PageDAO
extends WikiBaseDAO<PageEntity, Long> {
    private static final String TYPE_PARAM = "type";
    private static final String OWNER_PARAM = "owner";
    private DraftPageDAO draftPageDAO;
    private PageMoveDAO pageMoveDAO;
    private PageVersionDAO pageVersionDAO;

    public PageDAO(DraftPageDAO draftPageDAO, PageMoveDAO pageMoveDAO, PageVersionDAO pageVersionDAO) {
        this.draftPageDAO = draftPageDAO;
        this.pageMoveDAO = pageMoveDAO;
        this.pageVersionDAO = pageVersionDAO;
    }

    public List<PageEntity> getAllPagesOfWiki(String wikiType, String wikiOwner) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getAllPagesOfWiki", PageEntity.class).setParameter(TYPE_PARAM, (Object)wikiType).setParameter(OWNER_PARAM, (Object)wikiOwner);
        return query.getResultList();
    }

    public List<PageEntity> getPagesOfWiki(String wikiType, String wikiOwner, boolean deleted) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getPagesOfWiki", PageEntity.class).setParameter(TYPE_PARAM, (Object)wikiType).setParameter(OWNER_PARAM, (Object)wikiOwner).setParameter("deleted", (Object)deleted);
        return query.getResultList();
    }

    public PageEntity getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) {
        if (WikiType.GROUP.isSame(wikiType)) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        PageEntity pageEntity = null;
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getPageOfWikiByName", PageEntity.class).setParameter("name", (Object)pageName).setParameter(TYPE_PARAM, (Object)wikiType).setParameter(OWNER_PARAM, (Object)wikiOwner);
        List results = query.getResultList();
        if (results != null) {
            for (PageEntity pageEntityResult : results) {
                if (!pageEntityResult.getName().equals(pageName)) continue;
                if (pageEntity == null) {
                    pageEntity = pageEntityResult;
                    continue;
                }
                throw new NonUniqueResultException("More than 1 page with the name " + pageName + " in the wiki " + wikiType + ":" + wikiOwner + " has been returned");
            }
        }
        return pageEntity;
    }

    public List<PageEntity> getChildrenPages(PageEntity page) {
        return this.getEntityManager().createNamedQuery("wikiPage.getChildrenPages", PageEntity.class).setParameter("id", (Object)page.getId()).getResultList();
    }

    public List<PageEntity> getAllChildrenPages(PageEntity page) {
        return this.getEntityManager().createNamedQuery("wikiPage.getAllChildrenPages", PageEntity.class).setParameter("id", (Object)page.getId()).getResultList();
    }

    public List<Long> findAllIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getAllIds", Long.class);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public Long countAllIds() {
        return (Long)this.getEntityManager().createNamedQuery("wikiPage.countAllIds").getSingleResult();
    }

    public List<PageEntity> findAllBySyntax(String syntax, int offset, int limit) {
        return this.getEntityManager().createNamedQuery("wikiPage.getAllPagesBySyntax", PageEntity.class).setParameter("syntax", (Object)syntax).setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public List<PageEntity> getRelatedPages(long pageId) {
        return this.getEntityManager().createNamedQuery("wikiPage.getRelatedPages", PageEntity.class).setParameter("pageId", (Object)pageId).getResultList();
    }

    public Long countPageChildrenById(Long pageId) {
        return (Long)this.getEntityManager().createNamedQuery("wikiPage.countPageChildrenById").setParameter("id", (Object)pageId).getSingleResult();
    }

    public void deleteAll(List<PageEntity> entities) {
        entities = entities.stream().sorted((p1, p2) -> {
            if (p2.getId() > p1.getId()) {
                return 1;
            }
            if (p2.getId() < p1.getId()) {
                return -1;
            }
            return 0;
        }).toList();
        super.deleteAll(entities);
    }

    public void delete(PageEntity entity) {
        List<PageEntity> children = this.getAllChildrenPages(entity);
        if (CollectionUtils.isNotEmpty(children)) {
            Arrays.stream((PageEntity[])children.toArray(PageEntity[]::new)).forEach(this::delete);
        }
        entity.setChildren(null);
        this.updatePageDependencies(entity);
        entity = this.refreshEntity(entity);
        if (entity != null) {
            super.delete((Object)entity);
        }
    }

    @Transactional
    protected PageEntity refreshEntity(PageEntity entity) {
        if ((entity = (PageEntity)this.find(Long.valueOf(entity.getId()))) != null) {
            this.getEntityManager().refresh((Object)entity);
        }
        return entity;
    }

    @Transactional
    protected void updatePageDependencies(PageEntity entity) {
        List<PageEntity> relatedPages = this.getRelatedPages(entity.getId());
        if (CollectionUtils.isNotEmpty(relatedPages)) {
            relatedPages.forEach(p -> {
                if (CollectionUtils.isNotEmpty(p.getRelatedPages()) && p.getRelatedPages().removeIf(page -> page.getId() == entity.getId())) {
                    this.update(p);
                }
            });
        }
        entity.setRelatedPages(null);
        this.draftPageDAO.deleteDraftPagesByTargetPage(entity.getId());
        this.draftPageDAO.deleteDraftPagesByParentPage(entity.getId());
        entity.setDrafts(null);
        this.pageVersionDAO.deletePageVersions(entity.getId());
        entity.setVersions(null);
        this.pageMoveDAO.deletePageMoves(entity.getId());
        entity.setMoves(null);
        WikiEntity wiki = entity.getWiki();
        if (wiki.getWikiHome() != null && wiki.getWikiHome().getId() == entity.getId()) {
            wiki.setWikiHome(null);
        }
        entity.setParentPage(null);
    }
}

