/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.util.ArrayList;
import java.util.Calendar;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.wiki.mock.MockResourceBundleService;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.rest.NotesRestService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class TestWikiRestService
extends AbstractKernelTest {
    private MockedStatic<EntityBuilder> entityBuilder;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.entityBuilder = Mockito.mockStatic(EntityBuilder.class);
    }

    @After
    public void tearDown() throws Exception {
        this.entityBuilder.close();
        super.tearDown();
    }

    @Test
    public void testSearchData() throws Exception {
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        WikiService wikiService = (WikiService)Mockito.mock(WikiService.class);
        NoteService noteService = (NoteService)Mockito.mock(NoteService.class);
        Calendar cDate1 = Calendar.getInstance();
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        org.exoplatform.social.core.identity.model.Identity identityResult = new org.exoplatform.social.core.identity.model.Identity();
        identityResult.setProviderId("organization");
        identityResult.setRemoteId("root");
        identityResult.setId("1");
        Page page = new Page();
        page.setWikiId("1");
        page.setWikiType("Page");
        page.setWikiOwner("alioua");
        page.setName("Wiki_one");
        page.setTitle("Wiki one");
        page.setUrl("/exo/wiki");
        SearchResult result1 = new SearchResult();
        SearchResult result2 = new SearchResult();
        result1.setPageName("wiki");
        result1.setExcerpt("admin");
        result1.setPoster(null);
        result2.setExcerpt("admin");
        result2.setPageName("wik");
        result2.setPoster(identityResult);
        result2.setTitle("wiki test");
        result2.setCreatedDate(cDate1);
        IdentityEntity entity = new IdentityEntity();
        entity.setProviderId("organization");
        entity.setRemoteId("root");
        entity.setId("1");
        entity.setDeleted(Boolean.valueOf(false));
        Mockito.when((Object)noteService.getNoteOfNoteBookByName((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any(Identity.class))).thenReturn((Object)page);
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        results.add(result1);
        results.add(result2);
        ObjectPageList pageList = new ObjectPageList(results, 2);
        Mockito.when((Object)noteService.search((WikiSearchData)ArgumentMatchers.nullable(WikiSearchData.class))).thenReturn((Object)pageList);
        Mockito.when((Object)uriInfo.getPath()).thenReturn((Object)"/notes/contextsearch");
        this.entityBuilder.when(() -> EntityBuilder.buildEntityIdentity((org.exoplatform.social.core.identity.model.Identity)((org.exoplatform.social.core.identity.model.Identity)ArgumentMatchers.nullable(org.exoplatform.social.core.identity.model.Identity.class)), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)entity);
        NotesRestService wikiRestService = new NotesRestService(noteService, wikiService, null, null, (ResourceBundleService)new MockResourceBundleService(), null);
        ArrayList<String> tagNames = new ArrayList<String>();
        tagNames.add("testTag");
        Response response = wikiRestService.searchData(uriInfo, "wiki", 10, "page", "alioua", false, tagNames, null, false, null, null);
        TestWikiRestService.assertEquals((int)200, (int)response.getStatus());
    }
}

