/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.Date;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.wiki.jpa.search.NoteVersionLanguageIndexingServiceConnector;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.service.NoteService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NoteVersionLanguageIndexingServiceConnectorTest {
    @Mock
    private MetadataService metadataService;
    @Mock
    private NoteService noteService;
    @Mock
    private InitParams initParams;
    @Mock
    private PropertiesParam propertiesParam;
    @Mock
    private PageVersion pageVersion;
    @Mock
    private Page page;
    private static final String PAGE_VERSION_ID = "223-en";
    private NoteVersionLanguageIndexingServiceConnector noteVersionLanguageIndexingServiceConnector;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.initParams.getPropertiesParam("constructor.params")).thenReturn((Object)this.propertiesParam);
        Mockito.when((Object)this.propertiesParam.getProperty("index_current")).thenReturn((Object)"currentIndex");
        Mockito.when((Object)this.propertiesParam.getProperty("index_alias")).thenReturn((Object)"currentAlias");
        Mockito.when((Object)this.pageVersion.getParent()).thenReturn((Object)this.page);
        Mockito.when((Object)this.page.getWikiType()).thenReturn((Object)"group");
        Mockito.when((Object)this.page.getWikiOwner()).thenReturn((Object)"owner");
        Mockito.when((Object)this.pageVersion.getCreatedDate()).thenReturn((Object)new Date());
        Mockito.when((Object)this.pageVersion.getUpdatedDate()).thenReturn((Object)new Date());
        this.noteVersionLanguageIndexingServiceConnector = new NoteVersionLanguageIndexingServiceConnector(this.initParams, this.noteService, this.metadataService);
    }

    @Test
    public void create() {
        Assert.assertNull((Object)this.noteVersionLanguageIndexingServiceConnector.create(PAGE_VERSION_ID));
        Mockito.when((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(223L), "en")).thenReturn((Object)this.pageVersion);
        Assert.assertNotNull((Object)this.noteVersionLanguageIndexingServiceConnector.create(PAGE_VERSION_ID));
    }

    @Test
    public void update() {
        Assert.assertNull((Object)this.noteVersionLanguageIndexingServiceConnector.update(PAGE_VERSION_ID));
        Mockito.when((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(223L), "en")).thenReturn((Object)this.pageVersion);
        Assert.assertNotNull((Object)this.noteVersionLanguageIndexingServiceConnector.update(PAGE_VERSION_ID));
    }
}

