/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public class WikiHomeTreeNode
extends TreeNode {
    private static final Log log = ExoLogger.getLogger(WikiHomeTreeNode.class);
    private Page wikiHome;
    private NoteService noteService = (NoteService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NoteService.class);
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
    private SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);

    public WikiHomeTreeNode(Page wikiHome) throws Exception {
        super(wikiHome.getTitle(), TreeNodeType.WIKIHOME);
        this.wikiHome = wikiHome;
        this.path = this.buildPath();
        this.hasChild = !wikiHome.isDraftPage() && this.noteService.hasChildren(Long.parseLong(wikiHome.getId()));
    }

    @Override
    protected void addChildren(Map<String, Object> context, String userId) throws Exception {
        boolean withDrafts = context.containsKey("withDrafts") && (Boolean)context.get("withDrafts") != false;
        List<Page> pages = this.noteService.getChildrenNoteOf(this.wikiHome, withDrafts, false);
        Iterator childPageIterator = pages.iterator();
        int size = this.getNumberOfChildren(context, pages.size());
        Page currentPage = (Page)context.get("selectedPage");
        for (int count = 0; childPageIterator.hasNext() && count < size; ++count) {
            Page childPage = (Page)childPageIterator.next();
            if (!this.noteService.hasPermissionOnPage(childPage, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity()) && (currentPage == null || !Utils.isDescendantPage(currentPage, childPage)) || childPage.isDraftPage() && !this.noteService.canEditNote(childPage, userId)) continue;
            PageTreeNode child = new PageTreeNode(childPage);
            this.children.add(child);
        }
        super.addChildren(context, userId);
    }

    public Page getWikiHome() {
        return this.wikiHome;
    }

    public PageTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (PageTreeNode)child;
        }
        return null;
    }

    public PageTreeNode findDescendantNodeByName(List<TreeNode> listPageTreeNode, String name) throws Exception {
        for (TreeNode pageTreeNode : listPageTreeNode) {
            if (pageTreeNode.getName().equals(name)) {
                return (PageTreeNode)pageTreeNode;
            }
            List<TreeNode> listChildPageTreeNode = pageTreeNode.getChildren();
            if (listChildPageTreeNode.size() <= 0) continue;
            return this.findDescendantNodeByName(listChildPageTreeNode, name);
        }
        return null;
    }

    @Override
    public String buildPath() {
        try {
            Wiki wiki = this.wikiService.getWikiByTypeAndOwner(this.wikiHome.getWikiType(), this.wikiHome.getWikiOwner());
            WikiPageParams params = new WikiPageParams(wiki.getType(), wiki.getOwner(), "Home");
            return TreeUtils.getPathFromPageParams(params);
        }
        catch (Exception e) {
            log.error((Object)("Cannot build path of wiki page " + this.wikiHome.getWikiType() + ":" + this.wikiHome.getWikiOwner() + ":" + this.wikiHome.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void setWikiHome(Page wikiHome) {
        this.wikiHome = wikiHome;
    }
}

