/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.listener;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
@Profile(value={"gamification"})
public class TermsAndConditionsGamificationListener
extends Listener<String, Object> {
    private static final Log LOG = ExoLogger.getLogger(TermsAndConditionsGamificationListener.class);
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("terms.and.conditions.accepted", (ListenerBase)this);
    }

    public void onEvent(Event<String, Object> event) throws Exception {
        String username = (String)event.getSource();
        try {
            HashMap<String, String> gam = new HashMap<String, String>();
            gam.put("senderId", username);
            gam.put("receiverId", username);
            gam.put("objectId", username);
            gam.put("ruleTitle", "acceptConditions");
            this.listenerService.broadcast("exo.gamification.generic.action", gam, (Object)"");
            LOG.info("Accept conditions action broadcasted for user {}", new Object[]{username});
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while broadcasting accept conditions event", (Throwable)e);
        }
    }
}

