/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;

public abstract class BaseTest
extends AbstractKernelTest {
    public void setUp() throws Exception {
        super.setUp();
        this.begin();
        Identity systemIdentity = new Identity(IdentityConstants.SYSTEM);
        ConversationState.setCurrent((ConversationState)new ConversationState(systemIdentity));
        System.setProperty("gatein.email.domain.url", "localhost");
    }

    public void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    protected void startSessionAs(String user) {
        try {
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            Identity userIdentity = authenticator.createIdentity(user);
            ConversationState.setCurrent((ConversationState)new ConversationState(userIdentity));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    protected Wiki getOrCreateWiki(WikiService wikiService, String type, String owner) throws WikiException {
        Wiki wiki = wikiService.getWikiByTypeAndOwner(type, owner);
        if (wiki == null) {
            return wikiService.createWiki(type, owner);
        }
        return wiki;
    }

    protected void removeWikiPages(NoteService noteService, String type, String owner) throws WikiException {
        List notes = noteService.getNotesOfWiki(type, owner);
        notes.forEach(n -> {
            if (StringUtils.isNotBlank((CharSequence)n.getParentPageId())) {
                noteService.deleteNote(n.getId());
            }
        });
    }
}

