/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.ext.impl.WikiSpaceActivityPublisher;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WikiSpaceActivityPublisherTest {
    @Mock
    private NoteService noteService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private SpaceService spaceService;

    @Test
    public void shouldNotCreateActivityWhenUpdateTypeIsNull() throws Exception {
        WikiSpaceActivityPublisher wikiSpaceActivityPublisher = new WikiSpaceActivityPublisher(this.noteService, this.identityManager, this.activityManager, this.spaceService);
        WikiSpaceActivityPublisher wikiSpaceActivityPublisherSpy = (WikiSpaceActivityPublisher)Mockito.spy((Object)wikiSpaceActivityPublisher);
        Page page = new Page();
        wikiSpaceActivityPublisher.postUpdatePage("portal", "portal1", "page1", page, null);
        ((WikiSpaceActivityPublisher)Mockito.verify((Object)wikiSpaceActivityPublisherSpy, (VerificationMode)Mockito.never())).saveActivity("portal", "portal1", "page1", page, null);
    }

    @Test
    public void shouldNotCreateActivityWhenPageIsNull() throws Exception {
        WikiSpaceActivityPublisher wikiSpaceActivityPublisher = new WikiSpaceActivityPublisher(this.noteService, this.identityManager, this.activityManager, this.spaceService);
        WikiSpaceActivityPublisher wikiSpaceActivityPublisherSpy = (WikiSpaceActivityPublisher)Mockito.spy((Object)wikiSpaceActivityPublisher);
        wikiSpaceActivityPublisher.postUpdatePage("portal", "portal1", "page1", null, PageUpdateType.EDIT_PAGE_PERMISSIONS);
        ((WikiSpaceActivityPublisher)Mockito.verify((Object)wikiSpaceActivityPublisherSpy, (VerificationMode)Mockito.never())).saveActivity("portal", "portal1", "page1", null, PageUpdateType.EDIT_PAGE_PERMISSIONS);
    }

    @Test
    public void shouldNotGenerateActivityWhenIsNotToBePublished() throws Exception {
        WikiSpaceActivityPublisher wikiSpaceActivityPublisher = new WikiSpaceActivityPublisher(this.noteService, this.identityManager, this.activityManager, this.spaceService);
        WikiSpaceActivityPublisher wikiSpaceActivityPublisherSpy = (WikiSpaceActivityPublisher)Mockito.spy((Object)wikiSpaceActivityPublisher);
        Page page = new Page();
        page.setCanView(true);
        page.setToBePublished(false);
        org.exoplatform.services.security.Identity identity = new org.exoplatform.services.security.Identity("user");
        ConversationState conversationState = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)conversationState);
        Space space = new Space();
        space.setPrettyName("user");
        Identity identity1 = new Identity("user");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("portal1")).thenReturn((Object)space);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("user")).thenReturn((Object)identity1);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName())).thenReturn((Object)identity1);
        wikiSpaceActivityPublisherSpy.postUpdatePage("group", "portal1", "page1", page, PageUpdateType.EDIT_PAGE_PERMISSIONS);
        ((WikiSpaceActivityPublisher)Mockito.verify((Object)wikiSpaceActivityPublisherSpy, (VerificationMode)Mockito.times((int)1))).saveActivity("group", "portal1", "page1", page, PageUpdateType.EDIT_PAGE_PERMISSIONS);
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.never())).saveActivityNoReturn(identity1, (ExoSocialActivity)new ExoSocialActivityImpl());
    }

    @Test
    public void shouldGenerateNewActivityWhenIsToBePublished() throws Exception {
        WikiSpaceActivityPublisher wikiSpaceActivityPublisher = new WikiSpaceActivityPublisher(this.noteService, this.identityManager, this.activityManager, this.spaceService);
        WikiSpaceActivityPublisher wikiSpaceActivityPublisherSpy = (WikiSpaceActivityPublisher)Mockito.spy((Object)wikiSpaceActivityPublisher);
        Page page = new Page();
        page.setCanView(true);
        page.setToBePublished(true);
        org.exoplatform.services.security.Identity identity = new org.exoplatform.services.security.Identity("user");
        ConversationState conversationState = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)conversationState);
        Space space = new Space();
        space.setPrettyName("user");
        Identity identity1 = new Identity("user");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("portal1")).thenReturn((Object)space);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("user")).thenReturn((Object)identity1);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName())).thenReturn((Object)identity1);
        wikiSpaceActivityPublisherSpy.postUpdatePage("group", "portal1", "page1", page, PageUpdateType.EDIT_PAGE_PERMISSIONS);
        ((WikiSpaceActivityPublisher)Mockito.verify((Object)wikiSpaceActivityPublisherSpy, (VerificationMode)Mockito.times((int)1))).saveActivity("group", "portal1", "page1", page, PageUpdateType.EDIT_PAGE_PERMISSIONS);
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).saveActivityNoReturn(identity1, (ExoSocialActivity)new ExoSocialActivityImpl());
    }

    @Test
    public void shouldUpdateActivityWhenIsNotNewAndNotToBePublished() throws Exception {
        WikiSpaceActivityPublisher wikiSpaceActivityPublisher = new WikiSpaceActivityPublisher(this.noteService, this.identityManager, this.activityManager, this.spaceService);
        WikiSpaceActivityPublisher wikiSpaceActivityPublisherSpy = (WikiSpaceActivityPublisher)Mockito.spy((Object)wikiSpaceActivityPublisher);
        Page page = new Page();
        page.setCanView(true);
        page.setToBePublished(false);
        page.setActivityId("notNull");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId(page.getId());
        org.exoplatform.services.security.Identity identity = new org.exoplatform.services.security.Identity("user");
        ConversationState conversationState = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)conversationState);
        Space space = new Space();
        space.setPrettyName("user");
        Identity identity1 = new Identity("user");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("portal1")).thenReturn((Object)space);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("user")).thenReturn((Object)identity1);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName())).thenReturn((Object)identity1);
        Mockito.when((Object)this.activityManager.getActivity(page.getActivityId())).thenReturn((Object)activity);
        wikiSpaceActivityPublisherSpy.postUpdatePage("group", "portal1", "page1", page, PageUpdateType.EDIT_PAGE_PERMISSIONS);
        ((WikiSpaceActivityPublisher)Mockito.verify((Object)wikiSpaceActivityPublisherSpy, (VerificationMode)Mockito.times((int)1))).saveActivity("group", "portal1", "page1", page, PageUpdateType.EDIT_PAGE_PERMISSIONS);
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).updateActivity((ExoSocialActivity)activity, page.isToBePublished());
    }
}

