/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.plugin;

import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;

public class WikiPageAttachmentPlugin
extends AttachmentPlugin {
    public static final String OBJECT_TYPE = "wikiPage";
    private final NoteService noteService;
    private final SpaceService spaceService;

    public WikiPageAttachmentPlugin(NoteService noteService, SpaceService spaceService) {
        this.noteService = noteService;
        this.spaceService = spaceService;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasAccessPermission(Identity identity, String noteId) {
        try {
            Page note = this.noteService.getNoteById(noteId, identity);
            return note != null && note.isCanView();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasEditPermission(Identity identity, String noteId) throws ObjectNotFoundException {
        try {
            Page note = this.noteService.getNoteById(noteId, identity);
            return note != null && note.isCanManage();
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getAudienceId(String s) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String noteId) throws ObjectNotFoundException {
        try {
            Page note = this.noteService.getNoteById(noteId);
            return Long.parseLong(this.spaceService.getSpaceByGroupId(note.getWikiOwner()).getId());
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

