/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import io.meeds.social.search.SpaceSearchConnector;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListAccessType;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.jpa.search.WikiElasticSearchServiceConnector;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class WikiElasticSearchServiceConnectorTest
extends AbstractKernelTest {
    private WikiElasticSearchServiceConnector searchServiceConnector;
    @Mock
    private ElasticSearchingClient elasticSearchingClient;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private SpaceStorage spaceStorage;
    @Mock
    private SpaceSearchConnector spaceSearchConnector;
    @Mock
    private ConfigurationManager configurationManager;
    private MockedStatic<Utils> utils;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.utils = Mockito.mockStatic(Utils.class);
        InitParams initParams = new InitParams();
        PropertiesParam properties = new PropertiesParam();
        properties.setProperty("searchType", "wiki-es");
        properties.setProperty("displayName", "wiki-es");
        properties.setProperty("index", "wiki");
        properties.setProperty("type", "wiki,wiki-page");
        properties.setProperty("titleField", "title");
        properties.setProperty("searchFields", "name,title,content,comment,file");
        initParams.put((Object)"constructor.params", (Object)properties);
        this.searchServiceConnector = new WikiElasticSearchServiceConnector(this, this.configurationManager, initParams, this.elasticSearchingClient, this.identityManager, this.spaceService){

            protected String getPermissionFilter() {
                return "";
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        this.utils.close();
        super.tearDown();
    }

    @Test
    public void shouldReturnResultsWithoutExcerptWhenNoHighlight() {
        Identity systemIdentity = new Identity(IdentityConstants.SYSTEM);
        ConversationState.setCurrent((ConversationState)new ConversationState(systemIdentity));
        this.utils.when(() -> Utils.html2text((String)ArgumentMatchers.anyString())).thenReturn((Object)"");
        Mockito.when((Object)this.elasticSearchingClient.sendRequest(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)"{\n  \"took\": 939,\n  \"timed_out\": false,\n  \"_shards\": {\n    \"total\": 5,\n    \"successful\": 5,\n    \"failed\": 0\n  },\n  \"hits\": {\n    \"total\": 4,\n    \"max_score\": 1.0,\n    \"hits\": [{\n      \"_index\": \"wiki\",\n      \"_type\": \"wiki-page\",\n      \"_id\": \"2\",\n      \"_score\": 1.0,\n      \"_source\": {\n        \"wikiOwner\": \"intranet\",\n        \"createdDate\": \"1494833363955\",\n        \"name\": \"Page_1\",\n        \"wikiType\": \"portal\",\n        \"updatedDate\": \"1494833363955\",\n        \"title\": \"Page 1\",\n        \"url\": \"/portal/intranet/wiki/Page_1\"\n      }\n    }, {\n      \"_index\": \"wiki\",\n      \"_type\": \"wiki-page\",\n      \"_id\": \"3\",\n      \"_score\": 1.0,\n      \"_source\": {\n        \"wikiOwner\": \"intranet\",\n        \"createdDate\": \"1494833380251\",\n        \"name\": \"Page_2\",\n        \"wikiType\": \"portal\",\n        \"updatedDate\": \"1494833380251\",\n        \"title\": \"Page 2\",\n        \"url\": \"/portal/intranet/wiki/Page_2\"\n      }\n    }]\n  }\n}");
        this.searchServiceConnector.setSearchQuery("{\n  \"from\": \"@offset@\",\n  \"size\": \"@limit@\",\n  \"query\":{\n    \"bool\":{\n      \"filter\":{\n        \"terms\":{\n          \"permissions\": [@permissions@]\n        }\n      },\n      \"should\": {\n        \"match_phrase\": {\n          \"summary\": {\n            \"query\": \"@term@\",\n            \"boost\": 3\n          }\n        }\n      }\n @term_query@,\n      \"must_not\": {\n        \"exists\" : { \"field\" : \"sites\" }\n      }\n    }\n @tags_query@  },\n   \"highlight\" : {\n    \"number_of_fragments\" : 2,\n    \"fragment_size\" : 150,\n    \"no_match_size\" : 0,\n    \"order\": \"score\",\n    \"fields\" : {\n      \"description\" : {\n        \"pre_tags\" : [\"<span class='searchMatchExcerpt'>\"],\n        \"post_tags\" : [\"</span>\"]\n      },\n      \"summary\" : {\n        \"pre_tags\" : [\"<span class='searchMatchExcerpt'>\"],\n        \"post_tags\" : [\"</span>\"]\n      },\n      \"location\" : {\n        \"pre_tags\" : [\"<span class='searchMatchExcerpt'>\"],\n        \"post_tags\" : [\"</span>\"]\n      }\n    }\n  }\n}");
        Mockito.when((Object)this.spaceService.getMemberSpaces("__system")).thenReturn((Object)new SpaceListAccess(this.spaceStorage, this.spaceSearchConnector, "__system", SpaceListAccessType.MEMBER));
        Mockito.when((Object)this.spaceStorage.getMemberSpacesCount("__system")).thenReturn((Object)0);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "__system")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        ArrayList<String> tagNames = new ArrayList<String>();
        tagNames.add("testNoteTag");
        WikiSearchData wikiSearchData = new WikiSearchData(null, "__system");
        wikiSearchData.setTagNames(tagNames);
        wikiSearchData.setWikiOwner(null);
        wikiSearchData.setFavorites(false);
        wikiSearchData.setNotesTreeFilter(false);
        wikiSearchData.setOffset(0L);
        wikiSearchData.setLimit(20);
        List searchResults = this.searchServiceConnector.searchWiki("*", wikiSearchData);
        WikiElasticSearchServiceConnectorTest.assertNotNull((Object)searchResults);
        WikiElasticSearchServiceConnectorTest.assertEquals((int)2, (int)searchResults.size());
        WikiElasticSearchServiceConnectorTest.assertEquals((String)"", (String)((SearchResult)searchResults.get(0)).getExcerpt());
        WikiElasticSearchServiceConnectorTest.assertEquals((String)"", (String)((SearchResult)searchResults.get(1)).getExcerpt());
    }
}

