/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.notifications.provider;

import io.meeds.notes.notifications.plugin.MentionInNoteNotificationPlugin;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.TimeConvertUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="MentionInNoteNotificationPlugin", template="war:/notification/templates/mail/MentionInNoteNotificationPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);
    private final IdentityManager identityManager;

    public MailTemplateProvider(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"MentionInNoteNotificationPlugin"), new TemplateBuilder());
        this.identityManager = identityManager;
    }

    public class TemplateBuilder
    extends AbstractTemplateBuilder {
        public MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            Object activityLink = notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.ACTIVITY_LINK.getKey());
            Object authorProfileUrl = notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.AUTHOR_PROFILE_URL.getKey());
            String currentDomain = CommonsUtils.getCurrentDomain();
            activityLink = currentDomain + (String)activityLink;
            authorProfileUrl = currentDomain + (String)authorProfileUrl;
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)MailTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            templateContext.put((Object)MentionInNoteNotificationPlugin.NOTE_TITLE.getKey(), (Object)encoder.encode(notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.NOTE_TITLE.getKey())));
            templateContext.put((Object)MentionInNoteNotificationPlugin.NOTE_AUTHOR.getKey(), (Object)encoder.encode(notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.NOTE_AUTHOR.getKey())));
            templateContext.put((Object)MentionInNoteNotificationPlugin.CURRENT_USER.getKey(), (Object)notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.CURRENT_USER.getKey()));
            templateContext.put((Object)MentionInNoteNotificationPlugin.AUTHOR_AVATAR_URL.getKey(), (Object)encoder.encode(notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.AUTHOR_AVATAR_URL.getKey())));
            templateContext.put((Object)MentionInNoteNotificationPlugin.AUTHOR_PROFILE_URL.getKey(), (Object)encoder.encode((String)authorProfileUrl));
            templateContext.put((Object)MentionInNoteNotificationPlugin.ACTIVITY_LINK.getKey(), (Object)encoder.encode((String)activityLink));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.isRead()) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            Identity receiver = MailTemplateProvider.this.identityManager.getOrCreateIdentity("organization", notification.getTo());
            if (receiver == null || receiver.getRemoteId().equals(notification.getFrom())) {
                return null;
            }
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            templateContext.put((Object)"COMPANY_LINK", (Object)LinkProviderUtils.getBaseUrl());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo notificationInfo = (NotificationInfo)notifications.get(0);
            try {
                String mentionedIds;
                String ids;
                List mentionedList;
                String pluginId = notificationInfo.getKey().getId();
                if (pluginId.equals("MentionInNoteNotificationPlugin") && !(mentionedList = Stream.of((ids = (mentionedIds = notificationInfo.getValueOwnerParameter(MentionInNoteNotificationPlugin.MENTIONED_IDS.getKey())).substring(1, mentionedIds.length() - 1)).split(",")).map(String::trim).collect(Collectors.toList())).contains(notificationInfo.getTo())) {
                    return false;
                }
                String language = this.getLanguage(notificationInfo);
                TemplateContext templateContext = new TemplateContext(pluginId, language);
                Identity receiver = MailTemplateProvider.this.identityManager.getOrCreateIdentity("organization", notificationInfo.getTo());
                templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
                templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            StringBuilder sb = new StringBuilder();
            for (NotificationInfo notification : notifications) {
                templateContext.put((Object)MentionInNoteNotificationPlugin.NOTE_TITLE.getKey(), (Object)notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.NOTE_TITLE.getKey()));
                templateContext.put((Object)"USER", (Object)notification.getValueOwnerParameter(MentionInNoteNotificationPlugin.NOTE_AUTHOR.getKey()));
                templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                sb.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
                String digester = TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }
    }
}

