/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.storage;

import io.meeds.notes.model.NoteFeaturedImage;
import io.meeds.notes.model.NoteMetadataObject;
import io.meeds.notes.model.NotePageProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiPreferences;
import org.exoplatform.wiki.model.WikiPreferencesSyntax;
import org.exoplatform.wiki.utils.Utils;

public class EntityConverter {
    private static SpaceService spaceService;
    private static MetadataService metadataService;
    public static final MetadataType NOTES_METADATA_TYPE;
    public static final MetadataKey NOTES_METADATA_KEY;
    private static final List<String> ORIGINAL_SHARED_PROPERTIES;

    private EntityConverter() {
    }

    public static Wiki convertWikiEntityToWiki(WikiEntity wikiEntity) {
        Wiki wiki = null;
        if (wikiEntity != null) {
            wiki = new Wiki();
            wiki.setId(String.valueOf(wikiEntity.getId()));
            wiki.setType(wikiEntity.getType());
            wiki.setOwner(wikiEntity.getOwner());
            PageEntity wikiHomePageEntity = wikiEntity.getWikiHome();
            if (wikiHomePageEntity != null) {
                wiki.setWikiHome(EntityConverter.convertPageEntityToPage(wikiHomePageEntity));
            }
            WikiPreferences wikiPreferences = new WikiPreferences();
            WikiPreferencesSyntax wikiPreferencesSyntax = new WikiPreferencesSyntax();
            wikiPreferencesSyntax.setDefaultSyntax(wikiEntity.getSyntax());
            wikiPreferencesSyntax.setAllowMultipleSyntaxes(wikiEntity.isAllowMultipleSyntax());
            wikiPreferences.setWikiPreferencesSyntax(wikiPreferencesSyntax);
            wiki.setPreferences(wikiPreferences);
        }
        return wiki;
    }

    public static WikiEntity convertWikiToWikiEntity(Wiki wiki, WikiDAO wikiDAO) {
        WikiEntity wikiEntity = null;
        if (wiki != null) {
            WikiPreferencesSyntax wikiPreferencesSyntax;
            wikiEntity = new WikiEntity();
            wikiEntity.setType(wiki.getType());
            wikiEntity.setOwner(wiki.getOwner());
            wikiEntity.setWikiHome(EntityConverter.convertPageToPageEntity(wiki.getWikiHome(), wikiDAO));
            WikiPreferences wikiPreferences = wiki.getPreferences();
            if (wikiPreferences != null && (wikiPreferencesSyntax = wikiPreferences.getWikiPreferencesSyntax()) != null) {
                wikiEntity.setSyntax(wikiPreferencesSyntax.getDefaultSyntax());
                wikiEntity.setAllowMultipleSyntax(wikiPreferencesSyntax.isAllowMultipleSyntaxes());
            }
        }
        return wikiEntity;
    }

    public static Page convertPageEntityToPage(PageEntity pageEntity) {
        Page page = null;
        if (pageEntity != null) {
            page = new Page();
            page.setId(String.valueOf(pageEntity.getId()));
            page.setName(pageEntity.getName());
            WikiEntity wiki = pageEntity.getWiki();
            if (wiki != null) {
                page.setWikiId(String.valueOf(wiki.getId()));
                page.setWikiType(wiki.getType());
                page.setWikiOwner(wiki.getOwner());
            }
            if (pageEntity.getParentPage() != null) {
                page.setParentPageId(String.valueOf(pageEntity.getParentPage().getId()));
                page.setParentPageName(pageEntity.getParentPage().getName());
            }
            page.setTitle(pageEntity.getTitle());
            page.setOwner(pageEntity.getOwner());
            page.setAuthor(pageEntity.getAuthor());
            page.setContent(pageEntity.getContent());
            page.setSyntax(pageEntity.getSyntax());
            page.setCreatedDate(pageEntity.getCreatedDate());
            page.setUpdatedDate(pageEntity.getUpdatedDate());
            page.setMinorEdit(pageEntity.isMinorEdit());
            page.setComment(pageEntity.getComment());
            page.setActivityId(pageEntity.getActivityId());
            page.setDeleted(pageEntity.isDeleted());
            page.setUrl(Utils.getPageUrl(page));
            EntityConverter.buildNotePageMetadata(page, page.isDraftPage());
        }
        return page;
    }

    public static void buildNotePageMetadata(Page note, boolean isDraft) {
        if (note == null) {
            return;
        }
        Space space = EntityConverter.getSpaceService().getSpaceByGroupId(note.getWikiOwner());
        String spaceId = space != null ? space.getId() : "0";
        Object noteId = note.getId();
        if (note.getLang() != null) {
            noteId = (String)noteId + "-" + note.getLang();
        }
        Map<String, String> originalNoteSharedProperties = EntityConverter.getOriginalNoteSharedProperties(note, spaceId);
        NoteMetadataObject noteMetadataObject = new NoteMetadataObject(isDraft ? "noteDraftPage" : "notePage", (String)noteId, note.getParentPageId(), Long.parseLong(spaceId));
        EntityConverter.getMetadataService().getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)noteMetadataObject).stream().findFirst().ifPresent(metadataItem -> {
            if (!MapUtils.isEmpty((Map)metadataItem.getProperties())) {
                EntityConverter.buildPageProperties(metadataItem.getProperties(), originalNoteSharedProperties, note);
            }
        });
    }

    public static PageEntity convertPageToPageEntity(Page page, WikiDAO wikiDAO) {
        PageEntity pageEntity = null;
        if (page != null) {
            WikiEntity wiki;
            pageEntity = new PageEntity();
            pageEntity.setName(page.getName());
            if (page.getWikiId() != null && (wiki = (WikiEntity)wikiDAO.find(Long.valueOf(Long.parseLong(page.getWikiId())))) != null) {
                pageEntity.setWiki(wiki);
            }
            pageEntity.setTitle(page.getTitle());
            pageEntity.setOwner(page.getOwner());
            pageEntity.setAuthor(page.getAuthor());
            pageEntity.setContent(page.getContent());
            pageEntity.setSyntax(page.getSyntax());
            pageEntity.setCreatedDate(page.getCreatedDate());
            pageEntity.setUpdatedDate(page.getUpdatedDate());
            pageEntity.setMinorEdit(page.isMinorEdit());
            pageEntity.setComment(page.getComment());
            pageEntity.setUrl(page.getUrl());
            pageEntity.setActivityId(page.getActivityId());
        }
        return pageEntity;
    }

    public static List<DraftPage> convertDraftPageEntitiesToDraftPages(List<DraftPageEntity> draftPageEntities) {
        if (CollectionUtils.isEmpty(draftPageEntities)) {
            return new ArrayList<DraftPage>();
        }
        return draftPageEntities.stream().map(EntityConverter::convertDraftPageEntityToDraftPage).toList();
    }

    public static DraftPage convertDraftPageEntityToDraftPage(DraftPageEntity draftPageEntity) {
        DraftPage draftPage = null;
        if (draftPageEntity != null) {
            PageEntity parentPage;
            draftPage = new DraftPage();
            draftPage.setId(String.valueOf(draftPageEntity.getId()));
            draftPage.setName(draftPageEntity.getName());
            String title = draftPageEntity.getTitle();
            draftPage.setTitle(title != null ? title : "");
            draftPage.setAuthor(draftPageEntity.getAuthor());
            draftPage.setOwner(draftPageEntity.getAuthor());
            draftPage.setContent(draftPageEntity.getContent());
            draftPage.setLang(draftPageEntity.getLang());
            draftPage.setSyntax(draftPageEntity.getSyntax());
            draftPage.setCreatedDate(draftPageEntity.getCreatedDate());
            draftPage.setUpdatedDate(draftPageEntity.getUpdatedDate());
            draftPage.setNewPage(draftPageEntity.isNewPage());
            PageEntity targetPage = draftPageEntity.getTargetPage();
            if (targetPage != null) {
                draftPage.setTargetPageId(String.valueOf(targetPage.getId()));
                draftPage.setTargetPageRevision(draftPageEntity.getTargetRevision());
                WikiEntity wiki = targetPage.getWiki();
                if (wiki != null) {
                    draftPage.setWikiType(wiki.getType());
                    draftPage.setWikiOwner(wiki.getOwner());
                }
            }
            if ((parentPage = draftPageEntity.getParentPage()) != null) {
                draftPage.setParentPageId(String.valueOf(parentPage.getId()));
                draftPage.setParentPageName(parentPage.getName());
                if (StringUtils.isEmpty((CharSequence)draftPage.getWikiType()) || StringUtils.isEmpty((CharSequence)draftPage.getWikiOwner())) {
                    WikiEntity wiki = parentPage.getWiki();
                    draftPage.setWikiId(String.valueOf(wiki.getId()));
                    draftPage.setWikiOwner(parentPage.getWiki().getOwner());
                    draftPage.setWikiType(wiki.getType());
                }
            }
            EntityConverter.buildNotePageMetadata(draftPage, true);
        }
        return draftPage;
    }

    public static DraftPageEntity convertDraftPageToDraftPageEntity(DraftPage draftPage, PageDAO pageDAO) {
        DraftPageEntity draftPageEntity = null;
        if (draftPage != null) {
            String parentPageId;
            draftPageEntity = new DraftPageEntity();
            if (StringUtils.isNotEmpty((CharSequence)draftPage.getId())) {
                draftPageEntity.setId(Long.parseLong(draftPage.getId()));
            }
            draftPageEntity.setName(draftPage.getName());
            draftPageEntity.setTitle(draftPage.getTitle());
            draftPageEntity.setAuthor(draftPage.getAuthor());
            draftPageEntity.setContent(draftPage.getContent());
            draftPageEntity.setLang(draftPage.getLang());
            draftPageEntity.setSyntax(draftPage.getSyntax());
            draftPageEntity.setCreatedDate(draftPage.getCreatedDate());
            draftPageEntity.setUpdatedDate(draftPage.getUpdatedDate());
            draftPageEntity.setNewPage(draftPage.isNewPage());
            String targetPageId = draftPage.getTargetPageId();
            if (StringUtils.isNotEmpty((CharSequence)targetPageId)) {
                draftPageEntity.setTargetPage((PageEntity)pageDAO.find(Long.valueOf(targetPageId)));
            }
            if (StringUtils.isNotEmpty((CharSequence)(parentPageId = draftPage.getParentPageId()))) {
                draftPageEntity.setParentPage((PageEntity)pageDAO.find(Long.valueOf(parentPageId)));
            }
            draftPageEntity.setTargetRevision(draftPage.getTargetPageRevision());
            EntityConverter.buildNotePageMetadata(draftPage, true);
        }
        return draftPageEntity;
    }

    public static PageVersion convertPageVersionEntityToPageVersion(PageVersionEntity pageVersionEntity) {
        PageVersion pageVersion = null;
        if (pageVersionEntity != null) {
            pageVersion = new PageVersion();
            pageVersion.setId(String.valueOf(pageVersionEntity.getId()));
            pageVersion.setName(String.valueOf(pageVersionEntity.getVersionNumber()));
            pageVersion.setTitle(pageVersionEntity.getTitle());
            pageVersion.setAuthor(pageVersionEntity.getAuthor());
            pageVersion.setComment(pageVersionEntity.getComment());
            pageVersion.setContent(pageVersionEntity.getContent());
            pageVersion.setCreatedDate(pageVersionEntity.getCreatedDate());
            pageVersion.setUpdatedDate(pageVersionEntity.getUpdatedDate());
            pageVersion.setOwner(pageVersionEntity.getAuthor());
            pageVersion.setParent(EntityConverter.convertPageEntityToPage(pageVersionEntity.getPage()));
            pageVersion.setLang(pageVersionEntity.getLang());
            pageVersion.setWikiOwner(pageVersionEntity.getPage().getWiki().getOwner());
            EntityConverter.buildNotePageMetadata(pageVersion, pageVersion.isDraftPage());
        }
        return pageVersion;
    }

    public static PageHistory convertPageVersionEntityToPageHistory(PageVersionEntity pageVersionEntity) {
        PageHistory pageHistory = null;
        if (pageVersionEntity != null) {
            Identity identity;
            pageHistory = new PageHistory();
            pageHistory.setId(pageVersionEntity.getId());
            pageHistory.setVersionNumber(pageVersionEntity.getVersionNumber());
            pageHistory.setAuthor(pageVersionEntity.getAuthor());
            pageHistory.setContent(pageVersionEntity.getContent());
            pageHistory.setCreatedDate(pageVersionEntity.getCreatedDate());
            pageHistory.setUpdatedDate(pageVersionEntity.getUpdatedDate());
            pageHistory.setLang(pageVersionEntity.getLang());
            pageHistory.setTitle(pageVersionEntity.getTitle());
            if (StringUtils.isNotBlank((CharSequence)pageHistory.getAuthor()) && (identity = ((IdentityManager)ExoContainerContext.getService(IdentityManager.class)).getOrCreateUserIdentity(pageHistory.getAuthor())) != null && identity.getProfile() != null && identity.getProfile().getFullName() != null) {
                pageHistory.setAuthorFullName(identity.getProfile().getFullName());
            }
        }
        return pageHistory;
    }

    public static List<PageHistory> toPageHistoryVersions(List<PageVersionEntity> pageVersionEntities) {
        return pageVersionEntities.stream().map(EntityConverter::convertPageVersionEntityToPageHistory).toList();
    }

    public static List<DraftPage> toDraftPages(List<DraftPageEntity> draftPageEntities) {
        return draftPageEntities.stream().map(EntityConverter::convertDraftPageEntityToDraftPage).toList();
    }

    private static Map<String, String> getOriginalNoteSharedProperties(Page note, String spaceId) {
        if (note.getLang() == null || note.isDraftPage()) {
            return new HashMap<String, String>();
        }
        NoteMetadataObject originalNoteMetadataObject = new NoteMetadataObject("notePage", note.getId(), note.getParentPageId(), Long.parseLong(spaceId));
        List metadataItems = EntityConverter.getMetadataService().getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)originalNoteMetadataObject);
        Map originalNoteSharedProperties = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)metadataItems)) {
            originalNoteSharedProperties = ((MetadataItem)metadataItems.getFirst()).getProperties();
        }
        return originalNoteSharedProperties != null ? originalNoteSharedProperties.entrySet().stream().filter(entry -> ORIGINAL_SHARED_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : new HashMap<String, String>();
    }

    private static void buildPageProperties(Map<String, String> properties, Map<String, String> originalNoteSharedProperties, Page note) {
        HashMap<String, String> finalProperties = new HashMap<String, String>(properties);
        finalProperties.putAll(originalNoteSharedProperties);
        NotePageProperties notePageProperties = new NotePageProperties();
        NoteFeaturedImage noteFeaturedImage = new NoteFeaturedImage();
        notePageProperties.setNoteId(Long.parseLong(note.getId()));
        notePageProperties.setSummary((String)finalProperties.get("summary"));
        notePageProperties.setHideAuthor(Boolean.parseBoolean(finalProperties.getOrDefault("hideAuthor", "false")));
        notePageProperties.setHideReaction(Boolean.parseBoolean(properties.getOrDefault("hideReaction", "false")));
        noteFeaturedImage.setId(Long.valueOf(finalProperties.getOrDefault("featuredImageId", "0")));
        noteFeaturedImage.setLastUpdated(Long.valueOf(finalProperties.getOrDefault("featuredImageUpdatedDate", "0")));
        noteFeaturedImage.setAltText((String)finalProperties.get("featuredImageAltText"));
        notePageProperties.setDraft(note.isDraftPage());
        notePageProperties.setFeaturedImage(noteFeaturedImage);
        note.setProperties(notePageProperties);
    }

    private static SpaceService getSpaceService() {
        if (spaceService == null) {
            spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return spaceService;
    }

    private static MetadataService getMetadataService() {
        if (metadataService == null) {
            metadataService = (MetadataService)CommonsUtils.getService(MetadataService.class);
        }
        return metadataService;
    }

    static {
        NOTES_METADATA_TYPE = new MetadataType(1001L, "notes");
        NOTES_METADATA_KEY = new MetadataKey(NOTES_METADATA_TYPE.getName(), "notes", 0L);
        ORIGINAL_SHARED_PROPERTIES = List.of("hideReaction", "hideAuthor");
    }
}

