/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.integration.gamification.GamificationWikiListener;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.PageUpdateType;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GamificationWikiListenerTest {
    private static final String USER_IDENTITY_ID = "1";
    private static final String USERNAME = "testuser";
    private static final String WIKI_TYPE = "space";
    private static final String WIKI_OWNER = "testSpace";
    private static final String PAGE_ID = "5";
    @Mock
    ListenerService listenerService;
    @Mock
    IdentityManager identityManager;
    @Mock
    SpaceService spaceService;
    @Mock
    Page page;
    @Mock
    Identity userIdentity;

    @Test
    public void testCreatePageEvent() throws Exception {
        GamificationWikiListener gamificationListener = new GamificationWikiListener(this.identityManager, this.listenerService, this.spaceService);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)this.userIdentity);
        Mockito.when((Object)this.userIdentity.getId()).thenReturn((Object)USER_IDENTITY_ID);
        Mockito.when((Object)this.page.getId()).thenReturn((Object)PAGE_ID);
        ConversationState.setCurrent((ConversationState)new ConversationState(new org.exoplatform.services.security.Identity(USERNAME)));
        gamificationListener.postAddPage(WIKI_TYPE, WIKI_OWNER, PAGE_ID, this.page);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), ArgumentMatchers.argThat(param -> {
            Map map;
            return param instanceof Map && StringUtils.equals((CharSequence)((String)(map = (Map)param).get("eventId")), (CharSequence)"addWikiPage") && StringUtils.equals((CharSequence)((String)map.get("objectId")), (CharSequence)PAGE_ID) && StringUtils.equals((CharSequence)((String)map.get("objectType")), (CharSequence)"notes") && StringUtils.equals((CharSequence)((String)map.get("senderId")), (CharSequence)USER_IDENTITY_ID) && StringUtils.equals((CharSequence)((String)map.get("receiverId")), (CharSequence)USER_IDENTITY_ID);
        }), ArgumentMatchers.eq(null));
    }

    @Test
    public void testUpdatePageEvent() throws Exception {
        GamificationWikiListener gamificationListener = new GamificationWikiListener(this.identityManager, this.listenerService, this.spaceService);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)this.userIdentity);
        Mockito.when((Object)this.userIdentity.getId()).thenReturn((Object)USER_IDENTITY_ID);
        Mockito.when((Object)this.page.getId()).thenReturn((Object)PAGE_ID);
        ConversationState.setCurrent((ConversationState)new ConversationState(new org.exoplatform.services.security.Identity(USERNAME)));
        gamificationListener.postUpdatePage(WIKI_TYPE, WIKI_OWNER, PAGE_ID, this.page, PageUpdateType.EDIT_PAGE_CONTENT);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), ArgumentMatchers.argThat(param -> {
            Map map;
            return param instanceof Map && StringUtils.equals((CharSequence)((String)(map = (Map)param).get("eventId")), (CharSequence)"updateWikiPage") && StringUtils.equals((CharSequence)((String)map.get("objectId")), (CharSequence)PAGE_ID) && StringUtils.equals((CharSequence)((String)map.get("objectType")), (CharSequence)"notes") && StringUtils.equals((CharSequence)((String)map.get("senderId")), (CharSequence)USER_IDENTITY_ID) && StringUtils.equals((CharSequence)((String)map.get("receiverId")), (CharSequence)USER_IDENTITY_ID);
        }), ArgumentMatchers.eq(null));
    }
}

