/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.Collection;
import java.util.LinkedList;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeState;

public class NodeChangeQueue<N>
extends LinkedList<NodeChange<N>>
implements NodeChangeListener<N> {
    private static final long serialVersionUID = -4635111145546093584L;

    public NodeChangeQueue() {
    }

    public NodeChangeQueue(Collection<? extends NodeChange<N>> c) {
        super(c);
    }

    public void broadcast(NodeChangeListener<N> listener) {
        for (NodeChange change : this) {
            change.dispatch(listener);
        }
    }

    @Override
    public void onAdd(N target, N parent, N previous) {
        this.add(new NodeChange.Added<N>(parent, previous, target));
    }

    @Override
    public void onCreate(N target, N parent, N previous, String name) {
        this.add(new NodeChange.Created<N>(parent, previous, target, name));
    }

    @Override
    public void onRemove(N target, N parent) {
        this.add(new NodeChange.Removed<N>(parent, target));
    }

    @Override
    public void onDestroy(N target, N parent) {
        this.add(new NodeChange.Destroyed<N>(parent, target));
    }

    @Override
    public void onRename(N target, N parent, String name) {
        this.add(new NodeChange.Renamed<N>(parent, target, name));
    }

    @Override
    public void onUpdate(N target, NodeState state) {
        this.add(new NodeChange.Updated<N>(target, state));
    }

    @Override
    public void onMove(N target, N from, N to, N previous) {
        this.add(new NodeChange.Moved<N>(from, to, previous, target));
    }
}

