/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.kernel.test;

import io.meeds.kernel.test.AbstractSpringTest;
import io.meeds.spring.kernel.KernelContainerLifecyclePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringBeanFactoryInterceptor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBeanFactoryInterceptor.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        LOG.info("Integrating Spring Context with Container. Application name = '{}' using Kernel configuration class '{}'", (Object)this.applicationContext.getApplicationName(), (Object)AbstractSpringTest.getTestClass());
        KernelContainerLifecyclePlugin.addSpringContext((String)"test", (ApplicationContext)this.applicationContext, (BeanDefinitionRegistry)((BeanDefinitionRegistry)beanFactory));
        AbstractSpringTest.bootContainer((Class)AbstractSpringTest.getTestClass());
    }
}

