/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.kernel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.core.env.Environment;

public class CacheManagerImpl
implements CacheManager {
    private CacheService cacheService;
    private Environment environment;
    private Map<String, Cache> cacheInstances = new ConcurrentHashMap<String, Cache>();

    public CacheManagerImpl(CacheService cacheService, Environment environment) {
        this.cacheService = cacheService;
        this.environment = environment;
    }

    public Collection<String> getCacheNames() {
        return this.cacheService.getAllCacheInstances().stream().map(ExoCache::getName).toList();
    }

    public Cache getCache(String name) {
        return this.cacheInstances.computeIfAbsent(name, k -> {
            boolean isNew = this.cacheService.getAllCacheInstances().stream().map(ExoCache::getName).noneMatch(n -> StringUtils.equals((CharSequence)n, (CharSequence)name));
            final ExoCache cacheInstance = this.cacheService.getCacheInstance(name);
            if (isNew) {
                String maxElements;
                String ttl = this.environment.getProperty("meeds.cache." + name + ".ttl", "");
                if (StringUtils.isNotBlank((CharSequence)ttl)) {
                    cacheInstance.setLiveTime((long)Integer.parseInt(ttl));
                }
                if (StringUtils.isNotBlank((CharSequence)(maxElements = this.environment.getProperty("meeds.cache." + name + ".max", "")))) {
                    cacheInstance.setMaxSize(Integer.parseInt(maxElements));
                }
            }
            return new AbstractValueAdaptingCache(this, false){

                public String getName() {
                    return cacheInstance.getName();
                }

                public Object getNativeCache() {
                    return cacheInstance;
                }

                public <T> T get(Object key, Callable<T> valueLoader) {
                    Object value = cacheInstance.get((Serializable)key);
                    if (value == null) {
                        try {
                            value = valueLoader.call();
                            cacheInstance.put((Serializable)key, value);
                        }
                        catch (Exception e) {
                            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
                        }
                    }
                    return (T)value;
                }

                public void put(Object key, Object value) {
                    cacheInstance.put((Serializable)key, value);
                }

                public void evict(Object key) {
                    cacheInstance.remove((Serializable)key);
                }

                public void clear() {
                    cacheInstance.clearCache();
                }

                protected Object lookup(Object key) {
                    return cacheInstance.get((Serializable)key);
                }
            };
        });
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

