/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa;

import io.meeds.kernel.test.KernelExtension;
import io.meeds.spring.kernel.KernelCacheConfiguration;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.jpa.BaseTest;
import org.exoplatform.settings.jpa.SettingContextDAO;
import org.exoplatform.settings.jpa.SettingScopeDAO;
import org.exoplatform.settings.jpa.SettingsDAO;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.spring.module", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase"})
@EnableJpaRepositories(basePackages={"io.meeds.spring.module"})
@ContextConfiguration(classes={KernelCacheConfiguration.class})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/test-rdbms.db.changelog.xml"})
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.settings-configuration-local.xml")})
public class CommonsDAOJPAImplTest
extends BaseTest {
    protected static final String MODULE_NAME = "io.meeds.spring.module";
    protected static final String CHANGELOG_PATH = "classpath:db/changelog/test-rdbms.db.changelog.xml";
    protected SettingContextDAO settingContextDAO;
    protected SettingScopeDAO settingScopeDAO;
    protected SettingsDAO settingsDAO;

    @Override
    public void setUp() {
        super.setUp();
        this.settingContextDAO = this.getService(SettingContextDAO.class);
        this.settingScopeDAO = this.getService(SettingScopeDAO.class);
        this.settingsDAO = this.getService(SettingsDAO.class);
        this.cleanDB();
    }

    @Override
    public void tearDown() {
        this.cleanDB();
        super.tearDown();
    }

    @Override
    @BeforeClass
    protected void beforeRunBare() {
        if (System.getProperty("gatein.test.output.path") == null) {
            System.setProperty("gatein.test.output.path", System.getProperty("java.io.tmpdir"));
        }
        super.beforeRunBare();
    }

    @Override
    @AfterClass
    protected void afterRunBare() {
        super.afterRunBare();
    }

    public void testInit() {
        CommonsDAOJPAImplTest.assertNotNull((Object)this.settingContextDAO);
        CommonsDAOJPAImplTest.assertNotNull((Object)this.settingScopeDAO);
        CommonsDAOJPAImplTest.assertNotNull((Object)this.settingsDAO);
    }

    private void cleanDB() {
        this.settingsDAO.deleteAll();
        this.settingScopeDAO.deleteAll();
        this.settingContextDAO.deleteAll();
    }
}

