/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.IOFailureFlow;
import org.exoplatform.commons.utils.OutputStreamPrinter;
import org.exoplatform.component.test.AbstractGateInTest;
import org.gatein.common.io.UndeclaredIOException;

public class TestOutputStreamPrinter
extends AbstractGateInTest {
    static final int NOOP = -1;
    static final int WRITE = 0;
    static final int FLUSH = 1;
    static final int CLOSE = 2;

    public void testIOExceptionBlocking() {
        this.internalTest(IOFailureFlow.RETHROW, true);
    }

    public void testUndeclaredIOExceptionBlocking() {
        this.internalTest(IOFailureFlow.THROW_UNDECLARED, true);
    }

    public void testIgnoreIOExceptionBlocking() {
        this.internalTest(IOFailureFlow.IGNORE, true);
    }

    public void testIOExceptionNoBlocking() {
        this.internalTest(IOFailureFlow.RETHROW, false);
    }

    public void testUndeclaredIOExceptionNoBlocking() {
        this.internalTest(IOFailureFlow.THROW_UNDECLARED, false);
    }

    public void testIgnoreIOExceptionNoBlocking() {
        this.internalTest(IOFailureFlow.IGNORE, false);
    }

    public void internalTest(IOFailureFlow mode, boolean blockOnFailure) {
        int writeAfterFailure = blockOnFailure ? -1 : 0;
        int flushAfterFailure = blockOnFailure ? -1 : 1;
        TestOutputStream out = new TestOutputStream(true, mode, blockOnFailure);
        out.write(mode);
        out.assertOperation((int)0).assertEmpty().wantFailure = false;
        out.flush(IOFailureFlow.IGNORE);
        out.assertOperation(flushAfterFailure).assertEmpty();
        out.write(IOFailureFlow.IGNORE);
        out.assertOperation(writeAfterFailure).assertEmpty();
        out.close(IOFailureFlow.IGNORE);
        out.assertOperation(2).assertEmpty();
        out = new TestOutputStream(false, mode, blockOnFailure);
        out.write(IOFailureFlow.IGNORE);
        out.assertOperation((int)0).assertEmpty().wantFailure = true;
        out.flush(mode);
        out.assertOperation((int)1).assertEmpty().wantFailure = false;
        out.write(IOFailureFlow.IGNORE);
        out.assertOperation(writeAfterFailure).assertEmpty();
        out.close(IOFailureFlow.IGNORE);
        out.assertOperation(2).assertEmpty();
        out = new TestOutputStream(false, mode, blockOnFailure);
        out.write(IOFailureFlow.IGNORE);
        out.assertOperation(0).assertEmpty();
        out.flush(IOFailureFlow.IGNORE);
        out.assertOperation((int)1).assertEmpty().wantFailure = true;
        out.write(mode);
        out.assertOperation((int)0).assertEmpty().wantFailure = false;
        out.close(IOFailureFlow.IGNORE);
        out.assertOperation(2).assertEmpty();
        out = new TestOutputStream(false, mode, blockOnFailure);
        out.write(IOFailureFlow.IGNORE);
        out.assertOperation(0).assertEmpty();
        out.flush(IOFailureFlow.IGNORE);
        out.assertOperation(1).assertEmpty();
        out.write(IOFailureFlow.IGNORE);
        out.assertOperation((int)0).assertEmpty().wantFailure = true;
        out.close(mode);
        out.assertOperation(2).assertEmpty();
    }

    private static class TestOutputStream
    extends OutputStream {
        boolean wantFailure = false;
        final LinkedList<Integer> operations = new LinkedList();
        OutputStreamPrinter osp;

        private TestOutputStream(boolean wantFailure, IOFailureFlow mode, boolean blockOnFailure) {
            this.wantFailure = wantFailure;
            this.osp = new OutputStreamPrinter(CharsetTextEncoder.getUTF8(), (OutputStream)this, mode, blockOnFailure, false, 0);
        }

        @Override
        public void write(int b) throws IOException {
            this.operations.add(0);
            if (this.wantFailure) {
                throw new IOException();
            }
        }

        @Override
        public void flush() throws IOException {
            this.operations.add(1);
            if (this.wantFailure) {
                throw new IOException();
            }
        }

        @Override
        public void close() throws IOException {
            this.operations.add(2);
            if (this.wantFailure) {
                throw new IOException();
            }
        }

        public void write(IOFailureFlow mode) {
            switch (mode) {
                case RETHROW: {
                    try {
                        this.osp.write("a");
                        TestCase.fail();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case THROW_UNDECLARED: {
                    try {
                        this.osp.write("a");
                        TestCase.fail();
                    }
                    catch (UndeclaredIOException undeclaredIOException) {
                    }
                    catch (IOException expected) {
                        TestCase.fail();
                    }
                    break;
                }
                case IGNORE: {
                    try {
                        this.osp.write("a");
                        break;
                    }
                    catch (UndeclaredIOException ignore) {
                        TestCase.fail();
                        break;
                    }
                    catch (IOException expected) {
                        TestCase.fail();
                    }
                }
            }
        }

        public void flush(IOFailureFlow mode) {
            switch (mode) {
                case RETHROW: {
                    try {
                        this.osp.flush();
                        TestCase.fail();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case THROW_UNDECLARED: {
                    try {
                        this.osp.flush();
                        TestCase.fail();
                    }
                    catch (UndeclaredIOException undeclaredIOException) {
                    }
                    catch (IOException e) {
                        TestCase.fail();
                    }
                    break;
                }
                case IGNORE: {
                    try {
                        this.osp.flush();
                        break;
                    }
                    catch (IOException e) {
                        TestCase.fail();
                    }
                }
            }
        }

        public void close(IOFailureFlow mode) {
            switch (mode) {
                case RETHROW: {
                    try {
                        this.osp.close();
                        TestCase.fail();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case THROW_UNDECLARED: {
                    try {
                        this.osp.close();
                        TestCase.fail();
                    }
                    catch (UndeclaredIOException undeclaredIOException) {
                    }
                    catch (IOException e) {
                        TestCase.fail();
                    }
                    break;
                }
                case IGNORE: {
                    try {
                        this.osp.close();
                        break;
                    }
                    catch (IOException e) {
                        TestCase.fail();
                    }
                }
            }
        }

        public TestOutputStream assertEmpty() {
            Assert.assertTrue((boolean)this.operations.isEmpty());
            return this;
        }

        public TestOutputStream assertOperation(int operation) {
            if (operation != -1) {
                Assert.assertFalse((boolean)this.operations.isEmpty());
                int actual = this.operations.removeFirst();
                Assert.assertEquals((int)operation, (int)actual);
            }
            return this;
        }
    }
}

