/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cache.future;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.exoplatform.commons.cache.future.FutureCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.cache.future.StringLoader;
import org.gatein.common.util.Tools;

public class ConcurrentGetWhenPutTestCase
extends TestCase {
    private AssertionFailedError failure;
    private List<String> events = Collections.synchronizedList(new LinkedList());
    FutureCache<String, String, Callable<String>> futureCache = new FutureCache<String, String, Callable<String>>((Loader)new StringLoader()){

        protected String get(String key) {
            if (key == ConcurrentGetWhenPutTestCase.this.key1) {
                if (Thread.currentThread() != ConcurrentGetWhenPutTestCase.this.thread1) {
                    ConcurrentGetWhenPutTestCase.this.failure = new AssertionFailedError();
                }
                ConcurrentGetWhenPutTestCase.this.events.add("get/key1");
            } else if (key == ConcurrentGetWhenPutTestCase.this.key2) {
                if (Thread.currentThread() != ConcurrentGetWhenPutTestCase.this.thread2) {
                    ConcurrentGetWhenPutTestCase.this.failure = new AssertionFailedError();
                }
                ConcurrentGetWhenPutTestCase.this.events.add("get/key2");
            } else {
                ConcurrentGetWhenPutTestCase.this.failure = new AssertionFailedError();
            }
            return null;
        }

        protected void put(String key, String value) {
            if (key == ConcurrentGetWhenPutTestCase.this.key1) {
                if (Thread.currentThread() == ConcurrentGetWhenPutTestCase.this.thread1) {
                    ConcurrentGetWhenPutTestCase.this.events.add("begin_put/key1/" + value);
                    ConcurrentGetWhenPutTestCase.this.thread2.start();
                    while (ConcurrentGetWhenPutTestCase.this.thread2.getState() != Thread.State.WAITING) {
                    }
                    ConcurrentGetWhenPutTestCase.this.events.add("end_put/key1");
                } else {
                    ConcurrentGetWhenPutTestCase.this.failure = new AssertionFailedError();
                }
            } else {
                ConcurrentGetWhenPutTestCase.this.failure = new AssertionFailedError();
            }
        }

        protected void putOnly(String key, String value) {
            this.put(key, value);
        }
    };
    private final String key1 = new String("foo");
    private final String key2 = new String("foo");
    Thread thread1 = new Thread(){

        @Override
        public void run() {
            String v = (String)ConcurrentGetWhenPutTestCase.this.futureCache.get((Object)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    ConcurrentGetWhenPutTestCase.this.events.add("call/key1");
                    return "foo_value_1";
                }
            }, (Object)ConcurrentGetWhenPutTestCase.this.key1);
            ConcurrentGetWhenPutTestCase.this.events.add("retrieved/key1/" + v);
        }
    };
    Thread thread2 = new Thread(){

        @Override
        public void run() {
            String v = (String)ConcurrentGetWhenPutTestCase.this.futureCache.get((Object)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    ConcurrentGetWhenPutTestCase.this.failure = new AssertionFailedError();
                    return "foo_value_2";
                }
            }, (Object)ConcurrentGetWhenPutTestCase.this.key2);
            ConcurrentGetWhenPutTestCase.this.events.add("retrieved/key2/" + v);
        }
    };

    public void testMain() throws Exception {
        this.thread1.start();
        this.thread1.join();
        this.thread2.join();
        if (this.failure != null) {
            throw this.failure;
        }
        List<String> expectedEvents = Arrays.asList("get/key1", "call/key1", "begin_put/key1/foo_value_1", "get/key2", "end_put/key1");
        ConcurrentGetWhenPutTestCase.assertEquals(expectedEvents, this.events.subList(0, expectedEvents.size()));
        Set expectedEndEvents = Tools.toSet((Object[])new String[]{"retrieved/key1/foo_value_1", "retrieved/key2/foo_value_1"});
        ConcurrentGetWhenPutTestCase.assertEquals((Object)expectedEndEvents, new HashSet<String>(this.events.subList(expectedEvents.size(), this.events.size())));
    }
}

