/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.gatein.common.classloader.DelegatingClassLoader;
import org.gatein.common.classloader.FilteringClassLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingClassLoaderTest {
    private URLClassLoader clOne;
    private URLClassLoader clTwo;
    private URLClassLoader clThree;
    private URLClassLoader clClasses;

    @Before
    public void setup() throws URISyntaxException, MalformedURLException {
        URL root = this.getClass().getClassLoader().getResource("");
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        String[] filteredNames = new String[]{"test.properties", "nonexisting", "test.conf", "sub/test.properties", DelegatingClassLoaderTest.class.getName()};
        this.clOne = new FilteringClassLoader(parent, new URL[]{this.getClass().getResource("one/")}, filteredNames);
        this.clTwo = new FilteringClassLoader(parent, new URL[]{this.getClass().getResource("two/")}, filteredNames);
        this.clThree = new FilteringClassLoader(parent, new URL[]{this.getClass().getResource("three/")}, filteredNames);
        this.clClasses = new FilteringClassLoader(parent, new URL[]{root}, filteredNames);
    }

    private String loadProperty(URL url, String key) throws IOException {
        Properties p = this.loadProperties(url);
        return p.getProperty(key, null);
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties p = new Properties();
        p.load(url.openStream());
        return p;
    }

    private List<URL> loadResources(ClassLoader cl, String name, int foundCount) throws IOException {
        Enumeration<URL> propsEnum = cl.getResources(name);
        Assert.assertNotNull((String)"Expected to get enumeration as a result", propsEnum);
        ArrayList<URL> propsUrls = Collections.list(propsEnum);
        Assert.assertEquals((String)("Expected to get " + foundCount + " properties files returned"), (long)foundCount, (long)propsUrls.size());
        return propsUrls;
    }

    @Test
    public void testGetResource() throws IOException {
        DelegatingClassLoader cl = new DelegatingClassLoader(new ClassLoader[]{this.clOne, this.clTwo, this.clThree});
        URL propsUrl = cl.getResource("test.properties");
        String val = this.loadProperty(propsUrl, "key");
        Assert.assertEquals((Object)"one", (Object)val);
        propsUrl = cl.getResource("nonexisting");
        Assert.assertNull((String)"Looking for non-existing resource must return null", (Object)propsUrl);
        propsUrl = cl.getResource("test.conf");
        val = this.loadProperty(propsUrl, "key");
        Assert.assertEquals((Object)"test.conf", (Object)val);
        propsUrl = cl.getResource("sub/test.properties");
        val = this.loadProperty(propsUrl, "key");
        Assert.assertEquals((Object)"sub one", (Object)val);
        cl = new DelegatingClassLoader(new ClassLoader[]{this.clTwo, this.clThree, this.clOne});
        propsUrl = cl.getResource("test.properties");
        val = this.loadProperty(propsUrl, "key");
        Assert.assertEquals((Object)"two", (Object)val);
        propsUrl = cl.getResource("sub/test.properties");
        val = this.loadProperty(propsUrl, "key");
        Assert.assertEquals((Object)"sub one", (Object)val);
    }

    @Test
    public void testGetResources() throws IOException {
        DelegatingClassLoader cl = new DelegatingClassLoader(new ClassLoader[]{this.clOne, this.clTwo, this.clThree});
        List<URL> propsUrls = this.loadResources((ClassLoader)cl, "test.properties", 3);
        URL url = propsUrls.get(0);
        String val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"one", (Object)val);
        url = propsUrls.get(1);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"two", (Object)val);
        url = propsUrls.get(2);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"three", (Object)val);
        propsUrls = this.loadResources((ClassLoader)cl, "nonexisting", 0);
        propsUrls = this.loadResources((ClassLoader)cl, "test.conf", 1);
        url = propsUrls.get(0);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"test.conf", (Object)val);
        propsUrls = this.loadResources((ClassLoader)cl, "sub/test.properties", 1);
        url = propsUrls.get(0);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"sub one", (Object)val);
        cl = new DelegatingClassLoader(new ClassLoader[]{this.clTwo, this.clThree, this.clOne});
        propsUrls = this.loadResources((ClassLoader)cl, "test.properties", 3);
        url = propsUrls.get(0);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"two", (Object)val);
        url = propsUrls.get(1);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"three", (Object)val);
        url = propsUrls.get(2);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"one", (Object)val);
        propsUrls = this.loadResources((ClassLoader)cl, "sub/test.properties", 1);
        url = propsUrls.get(0);
        val = this.loadProperty(url, "key");
        Assert.assertEquals((Object)"sub one", (Object)val);
    }

    @Test
    public void testLoadClass() {
        DelegatingClassLoader cl = new DelegatingClassLoader(new ClassLoader[]{this.clOne, this.clTwo, this.clThree, this.clClasses});
        Class<?> c = null;
        try {
            c = cl.loadClass(DelegatingClassLoaderTest.class.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load class via DelegatingClassLoader: " + DelegatingClassLoaderTest.class.getName(), e);
        }
        Assert.assertSame((Object)this.clClasses, (Object)c.getClassLoader());
        cl = new DelegatingClassLoader(new ClassLoader[]{this.clOne, this.clTwo, this.clThree});
        try {
            cl.loadClass(DelegatingClassLoaderTest.class.getName());
            Assert.fail((String)("Loading the class should fail: " + DelegatingClassLoaderTest.class.getName()));
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load class unexpectedly: " + DelegatingClassLoaderTest.class.getName(), e);
        }
        cl = new DelegatingClassLoader(new ClassLoader[]{this.clOne, this.clTwo, this.clThree, this.getClass().getClassLoader(), this.clClasses});
        try {
            c = cl.loadClass(DelegatingClassLoaderTest.class.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load class: " + DelegatingClassLoaderTest.class.getName(), e);
        }
        Assert.assertSame(DelegatingClassLoaderTest.class, c);
        Assert.assertNotSame((Object)this.clClasses, (Object)c.getClassLoader());
    }
}

