/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.StringPageListAccess;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestPageListAccess
extends AbstractGateInTest {
    private final String[] l = new String[]{"0", "1", "2", "3", "4", "5", "6"};

    public void testPageList() throws Exception {
        StringPageListAccess pageList = new StringPageListAccess(3, this.l);
        this.assertState1((PageList<String>)pageList);
        pageList = this.clone(pageList);
        this.assertState1((PageList<String>)pageList);
        List list = pageList.getPage(1);
        this.assertListState1(list);
        this.assertState1((PageList<String>)pageList);
        pageList = this.clone(pageList);
        list = pageList.getPage(1);
        this.assertListState1(list);
        this.assertState1((PageList<String>)pageList);
        list = pageList.getPage(2);
        this.assertListState2(list);
        this.assertState2((PageList<String>)pageList);
        pageList = this.clone(pageList);
        list = pageList.getPage(2);
        this.assertListState2(list);
        this.assertState2((PageList<String>)pageList);
        list = pageList.getPage(3);
        this.assertListState3(list);
        this.assertState3((PageList<String>)pageList);
        pageList = this.clone(pageList);
        list = pageList.getPage(3);
        this.assertListState3(list);
        this.assertState3((PageList<String>)pageList);
    }

    private void assertListState3(List<String> list) {
        TestPageListAccess.assertNotNull(list);
        TestPageListAccess.assertEquals((int)1, (int)list.size());
        TestPageListAccess.assertEquals((String)"6", (String)list.get(0));
    }

    private void assertState3(PageList<String> list) {
        TestPageListAccess.assertEquals((int)6, (int)list.getFrom());
        TestPageListAccess.assertEquals((int)7, (int)list.getTo());
        TestPageListAccess.assertEquals((int)3, (int)list.getCurrentPage());
        TestPageListAccess.assertEquals((int)3, (int)list.getAvailablePage());
        TestPageListAccess.assertEquals((int)7, (int)list.getAvailable());
    }

    private void assertState2(PageList<String> list) {
        TestPageListAccess.assertEquals((int)3, (int)list.getFrom());
        TestPageListAccess.assertEquals((int)6, (int)list.getTo());
        TestPageListAccess.assertEquals((int)2, (int)list.getCurrentPage());
        TestPageListAccess.assertEquals((int)3, (int)list.getAvailablePage());
        TestPageListAccess.assertEquals((int)7, (int)list.getAvailable());
    }

    private void assertListState2(List<String> s) {
        TestPageListAccess.assertNotNull(s);
        TestPageListAccess.assertEquals((int)3, (int)s.size());
        TestPageListAccess.assertEquals((String)"3", (String)s.get(0));
        TestPageListAccess.assertEquals((String)"4", (String)s.get(1));
        TestPageListAccess.assertEquals((String)"5", (String)s.get(2));
    }

    private void assertListState1(List<String> s) {
        TestPageListAccess.assertNotNull(s);
        TestPageListAccess.assertEquals((int)3, (int)s.size());
        TestPageListAccess.assertEquals((String)"0", (String)s.get(0));
        TestPageListAccess.assertEquals((String)"1", (String)s.get(1));
        TestPageListAccess.assertEquals((String)"2", (String)s.get(2));
    }

    private void assertState1(PageList<String> list) {
        TestPageListAccess.assertEquals((int)0, (int)list.getFrom());
        TestPageListAccess.assertEquals((int)3, (int)list.getTo());
        TestPageListAccess.assertEquals((int)1, (int)list.getCurrentPage());
        TestPageListAccess.assertEquals((int)3, (int)list.getAvailablePage());
        TestPageListAccess.assertEquals((int)7, (int)list.getAvailable());
    }

    private StringPageListAccess clone(StringPageListAccess pageList) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject((Object)pageList);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (StringPageListAccess)((Object)ois.readObject());
        }
        catch (Exception e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }
}

