/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.exoplatform.commons.file.CommonsJPAIntegrationTest;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.resource.FileUtils;
import org.exoplatform.commons.file.resource.RdbmsResourceProvider;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class RdbmsResourceProviderTest
extends CommonsJPAIntegrationTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.fileBinaryDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() {
        this.fileBinaryDAO.deleteAll();
        super.tearDown();
    }

    public void testWriteBinary() throws Exception {
        RdbmsResourceProvider rdbmsResourceProvider = new RdbmsResourceProvider(this.fileBinaryDAO);
        FileItem file = new FileItem(Long.valueOf(1L), "file1", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream(new byte[0]));
        rdbmsResourceProvider.put(file.getFileInfo().getChecksum(), file.getAsStream());
        ByteArrayInputStream createdData = (ByteArrayInputStream)rdbmsResourceProvider.getStream(file.getFileInfo().getChecksum());
        RdbmsResourceProviderTest.assertNotNull((Object)createdData);
    }

    public void testWriteBinaryWhenFileAlreadyExistsAndBinaryHasChanged() throws Exception {
        RdbmsResourceProvider rdbmsResourceProvider = new RdbmsResourceProvider(this.fileBinaryDAO);
        FileItem file = new FileItem(Long.valueOf(1L), "file2", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test2".getBytes()));
        rdbmsResourceProvider.put(file);
        ByteArrayInputStream createdData = (ByteArrayInputStream)rdbmsResourceProvider.getStream(file.getFileInfo().getChecksum());
        RdbmsResourceProviderTest.assertNotNull((Object)createdData);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test-updated".getBytes());
        file.setInputStream((InputStream)inputStream);
        file.setChecksum((InputStream)inputStream);
        rdbmsResourceProvider.put(file);
        ByteArrayInputStream updateddData = (ByteArrayInputStream)rdbmsResourceProvider.getStream(file.getFileInfo().getChecksum());
        Assert.assertThat((Object)new String(FileUtils.readBytes((InputStream)updateddData)), (Matcher)Is.is((Matcher)IsNot.not((Object)new String(FileUtils.readBytes((InputStream)createdData)))));
    }

    public void testFileAlreadyExistsAndBinaryHasNotChanged() throws Exception {
        RdbmsResourceProvider rdbmsResourceProvider = new RdbmsResourceProvider(this.fileBinaryDAO);
        FileItem file = new FileItem(Long.valueOf(1L), "file3", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test3".getBytes()));
        rdbmsResourceProvider.put(file);
        String created = rdbmsResourceProvider.getFilePath(file.getFileInfo());
        try {
            rdbmsResourceProvider.put(file);
            RdbmsResourceProviderTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String updated = rdbmsResourceProvider.getFilePath(file.getFileInfo());
        RdbmsResourceProviderTest.assertEquals((String)updated, (String)created);
    }

    public void testDeleteBinary() throws Exception {
        RdbmsResourceProvider rdbmsResourceProvider = new RdbmsResourceProvider(this.fileBinaryDAO);
        FileItem file = new FileItem(Long.valueOf(1L), "file4", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test4".getBytes()));
        rdbmsResourceProvider.put(file);
        String created = rdbmsResourceProvider.getFilePath(file.getFileInfo());
        RdbmsResourceProviderTest.assertNotNull((Object)created);
        rdbmsResourceProvider.remove(file.getFileInfo());
        String deleted = rdbmsResourceProvider.getFilePath(file.getFileInfo());
        RdbmsResourceProviderTest.assertNull((Object)deleted);
    }

    public void testDeletingABinaryWhichDoesNotExist() throws Exception {
        RdbmsResourceProvider rdbmsResourceProvider = new RdbmsResourceProvider(this.fileBinaryDAO);
        FileItem file = new FileItem(Long.valueOf(1L), "file5", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test5".getBytes()));
        boolean deleted = rdbmsResourceProvider.remove(file.getFileInfo());
        RdbmsResourceProviderTest.assertEquals((boolean)deleted, (boolean)false);
    }

    public void shouldReturnNullWhenChecksumIsNotValid() throws Exception {
        RdbmsResourceProvider binaryProvider = new RdbmsResourceProvider(this.fileBinaryDAO);
        FileInfo fileInfo = new FileInfo(Long.valueOf(1L), "file6", "", null, 1L, null, "", "", false);
        String path = binaryProvider.getFilePath(fileInfo);
        RdbmsResourceProviderTest.assertNull((Object)path);
    }
}

