/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.commons.file.resource.FileCleaner;
import org.exoplatform.commons.file.resource.TreeFile;

public final class TreeFileUtils {
    private static final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);
    protected final File rootDir;
    private static final FileCleaner cleaner = new FileCleaner(null);

    public TreeFileUtils(File rootDir) {
        this.rootDir = rootDir;
    }

    protected File getFile(String resourceId) throws IOException {
        TreeFile tfile = new TreeFile(this.rootDir.getAbsolutePath() + this.makeFilePath(resourceId), cleaner, this.rootDir);
        TreeFileUtils.mkdirs(tfile.getParentFile());
        return tfile;
    }

    protected String makeFilePath(String resourceId) {
        return this.buildPath(resourceId) + File.separator + resourceId;
    }

    protected String buildPath(String fileName) {
        return this.buildPathX8(fileName);
    }

    protected String buildPathX8(String fileName) {
        int xLength = 8;
        char[] chs = fileName.toCharArray();
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            path.append(File.separator).append(chs[i]);
        }
        return path.toString();
    }

    private static void mkdirs(File dir) {
        if (dir.exists()) {
            return;
        }
        ArrayList<File> dir2Create = new ArrayList<File>();
        dir2Create.add(dir);
        for (dir = dir.getParentFile(); dir != null && !dir.exists(); dir = dir.getParentFile()) {
            dir2Create.add(0, dir);
        }
        int length = dir2Create.size();
        for (int i = 0; i < length; ++i) {
            TreeFileUtils.mkdir((File)dir2Create.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mkdir(File dir) {
        Lock prevLock;
        String path = dir.getAbsolutePath();
        Lock lock = (Lock)locks.get(path);
        if (lock == null && (prevLock = locks.putIfAbsent(path, lock = new ReentrantLock())) != null) {
            lock = prevLock;
        }
        lock.lock();
        try {
            if (!dir.exists()) {
                dir.mkdir();
            }
        }
        finally {
            lock.unlock();
            locks.remove(path, lock);
        }
    }
}

