/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.model.NameSpace;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.resource.FileSystemResourceProvider;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.commons.file.services.impl.FileServiceImpl;
import org.exoplatform.commons.file.storage.DataStorage;
import org.exoplatform.commons.file.storage.dao.FileInfoDAO;
import org.exoplatform.commons.file.storage.dao.NameSpaceDAO;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;
import org.exoplatform.commons.file.storage.entity.NameSpaceEntity;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class FileServiceImplTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Mock
    private FileInfoDAO fileInfoDAO;
    @Mock
    private NameSpaceDAO nameSpaceDAO;
    @Mock
    private DataStorage jpaDataStorage;
    @Mock
    private NameSpaceService nameSpaceService;
    @Mock
    private PortalContainer portalContainer;
    @Mock
    private EntityManagerService emService;
    @Mock
    private EntityManager em;
    @Mock
    private EntityTransaction transaction;
    @Mock
    private ListenerService listenerService;

    @Before
    public void setUp() throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.portalContainer);
        Mockito.when((Object)((EntityManagerService)this.portalContainer.getComponentInstanceOfType(EntityManagerService.class))).thenReturn((Object)this.emService);
        Mockito.when((Object)this.emService.getEntityManager()).thenReturn((Object)this.em);
        Mockito.when((Object)this.em.getTransaction()).thenReturn((Object)this.transaction);
        Mockito.when((Object)this.transaction.isActive()).thenReturn((Object)true);
    }

    @After
    public void tearDown() throws Exception {
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void shouldReturnFile() throws Exception {
        FileSystemResourceProvider binaryProvider = new FileSystemResourceProvider(this.folder.getRoot().getAbsolutePath());
        Mockito.lenient().when((Object)((NameSpaceEntity)this.nameSpaceDAO.find((Serializable)Long.valueOf(Mockito.anyLong())))).thenReturn((Object)new NameSpaceEntity(1L, "file", "Default NameSpace"));
        Mockito.lenient().when((Object)((FileInfoEntity)this.fileInfoDAO.find((Serializable)Long.valueOf(Mockito.anyLong())))).thenReturn((Object)new FileInfoEntity(1L, "file1", null, 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", false).setNameSpaceEntity(new NameSpaceEntity(1L, "file", "Default NameSpace")));
        Mockito.when((Object)this.jpaDataStorage.getFileInfo(Mockito.anyLong())).thenReturn((Object)new FileInfo(Long.valueOf(1L), "file1", null, "file", 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", false));
        FileServiceImpl fileService = new FileServiceImpl(this.jpaDataStorage, (BinaryProvider)binaryProvider, this.nameSpaceService, this.listenerService);
        FileItem file = fileService.getFile(1L);
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((long)1L, (long)file.getFileInfo().getId());
        Assert.assertEquals((Object)"file1", (Object)file.getFileInfo().getName());
    }

    @Test
    public void shouldWriteFile() throws Exception {
        FileSystemResourceProvider binaryProvider = new FileSystemResourceProvider(this.folder.getRoot().getAbsolutePath());
        Mockito.lenient().when((Object)((FileInfoEntity)this.fileInfoDAO.create((Object)((FileInfoEntity)Mockito.any(FileInfoEntity.class))))).thenReturn((Object)new FileInfoEntity());
        Mockito.lenient().when((Object)this.jpaDataStorage.getNameSpace((String)Mockito.any())).thenReturn((Object)new NameSpace(null, null));
        Mockito.lenient().when((Object)this.jpaDataStorage.create((FileInfo)Mockito.any(FileInfo.class), (NameSpace)Mockito.any(NameSpace.class))).thenReturn((Object)new FileInfo(Long.valueOf(1L), "file1", null, "file", 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", false));
        FileServiceImpl fileService = new FileServiceImpl(this.jpaDataStorage, (BinaryProvider)binaryProvider, this.nameSpaceService, this.listenerService);
        FileItem fileItem = new FileItem(null, "file1", "", null, 1L, new Date(), "", false, (InputStream)new ByteArrayInputStream("test".getBytes()));
        fileService.writeFile(fileItem);
        FileInfo fileInfo = fileItem.getFileInfo();
        fileInfo.setId(Long.valueOf(1L));
        ((DataStorage)Mockito.verify((Object)this.jpaDataStorage, (VerificationMode)Mockito.times((int)1))).create((FileInfo)Mockito.any(FileInfo.class), (NameSpace)Mockito.any(NameSpace.class));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)Mockito.eq((Object)"file.created"), (Object)((FileInfo)Mockito.argThat(f -> f.getId() != null && f.getId() > 0L)), Mockito.eq(null));
    }

    @Test
    public void shouldUpdateFile() throws Exception {
        FileSystemResourceProvider binaryProvider = new FileSystemResourceProvider(this.folder.getRoot().getAbsolutePath());
        Mockito.lenient().when((Object)((FileInfoEntity)this.fileInfoDAO.create((Object)((FileInfoEntity)Mockito.any(FileInfoEntity.class))))).thenReturn((Object)new FileInfoEntity());
        Mockito.lenient().when((Object)this.jpaDataStorage.getNameSpace((String)Mockito.any())).thenReturn((Object)new NameSpace(null, null));
        Mockito.lenient().when((Object)this.jpaDataStorage.updateFileInfo((FileInfo)Mockito.any(FileInfo.class))).thenReturn((Object)new FileInfo(Long.valueOf(1L), "fileToUpdate", null, "file", 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", false));
        Mockito.lenient().when((Object)this.jpaDataStorage.getFileInfo(1L)).thenReturn((Object)new FileInfo(Long.valueOf(1L), "file1", null, "file", 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", false));
        FileServiceImpl fileService = new FileServiceImpl(this.jpaDataStorage, (BinaryProvider)binaryProvider, this.nameSpaceService, this.listenerService);
        FileItem fileItem = new FileItem(Long.valueOf(1L), "fileToUpdate", "", null, 1L, new Date(), "", false, (InputStream)new ByteArrayInputStream("test".getBytes()));
        fileService.updateFile(fileItem);
        FileInfo fileInfo = fileItem.getFileInfo();
        fileInfo.setId(Long.valueOf(1L));
        ((DataStorage)Mockito.verify((Object)this.jpaDataStorage, (VerificationMode)Mockito.times((int)1))).updateFileInfo((FileInfo)Mockito.any(FileInfo.class));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("file.updated", (Object)fileInfo, null);
    }

    @Test
    public void shouldDeleteFile() throws Exception {
        FileSystemResourceProvider binaryProvider = new FileSystemResourceProvider(this.folder.getRoot().getAbsolutePath());
        FileInfo fileInfo = new FileInfo(Long.valueOf(1L), "file", null, "file", 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", false);
        FileInfo updatedFileInfo = new FileInfo(Long.valueOf(1L), "file", null, "file", 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", true);
        Mockito.lenient().when((Object)this.jpaDataStorage.updateFileInfo((FileInfo)Mockito.any(FileInfo.class))).thenReturn((Object)updatedFileInfo);
        Mockito.lenient().when((Object)this.jpaDataStorage.getFileInfo(1L)).thenReturn((Object)fileInfo);
        FileServiceImpl fileService = new FileServiceImpl(this.jpaDataStorage, (BinaryProvider)binaryProvider, this.nameSpaceService, this.listenerService);
        fileService.deleteFile(1L);
        ((DataStorage)Mockito.verify((Object)this.jpaDataStorage, (VerificationMode)Mockito.times((int)1))).updateFileInfo((FileInfo)Mockito.any(FileInfo.class));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("file.deleted", (Object)updatedFileInfo, null);
    }

    @Test
    public void shouldRollbackFileWriteWhenSomethingGoesWrong() throws Exception {
        FileSystemResourceProvider binaryProvider = new FileSystemResourceProvider(this.folder.getRoot().getAbsolutePath());
        Mockito.lenient().when((Object)((FileInfoEntity)this.fileInfoDAO.create((Object)((FileInfoEntity)Mockito.any(FileInfoEntity.class))))).thenThrow(RuntimeException.class);
        FileServiceImpl fileService = new FileServiceImpl(this.jpaDataStorage, (BinaryProvider)binaryProvider, this.nameSpaceService, this.listenerService);
        FileItem file = new FileItem(this, null, "file1", "plain/text", null, 1L, new Date(), "john", false, new ByteArrayInputStream("test".getBytes())){

            public InputStream getAsStream() {
                throw new IllegalStateException();
            }
        };
        FileItem createdFile = null;
        try {
            createdFile = fileService.writeFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)createdFile);
    }
}

