/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore;

import exo.portal.component.identiy.opendsconfig.opends.OpenDSService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.externalstore.PicketLinkIDMExternalStoreService;
import org.gatein.portal.idm.impl.repository.ExoFallbackIdentityStoreRepository;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-external-ldap-store-configuration.xml")})
public class TestLDAPAsExternalStore
extends AbstractKernelTest {
    protected UserHandler uHandler;
    OpenDSService openDSService = new OpenDSService(null);
    PicketLinkIDMOrganizationServiceImpl organizationService;
    PicketLinkIDMServiceImpl idmService;
    PicketLinkIDMExternalStoreService externalStoreService;

    protected void setUp() throws Exception {
        this.setForceContainerReload(true);
        this.organizationService = (PicketLinkIDMOrganizationServiceImpl)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.idmService = (PicketLinkIDMServiceImpl)this.getContainer().getComponentInstanceOfType(PicketLinkIDMService.class);
        this.externalStoreService = (PicketLinkIDMExternalStoreService)this.getContainer().getComponentInstanceOfType(IDMExternalStoreService.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    protected void beforeRunBare() {
        try {
            this.openDSService.start();
            this.openDSService.initLDAPServer();
        }
        catch (Exception e) {
            this.log.error((Object)"Error in starting up OPENDS", (Throwable)e);
            e.printStackTrace();
        }
        super.beforeRunBare();
    }

    public void testConfiguration() throws Exception {
        IdentityStoreRepository identityStoreRepository = ((IdentitySessionImpl)this.idmService.getIdentitySession()).getSessionContext().getIdentityStoreRepository();
        TestLDAPAsExternalStore.assertTrue((boolean)this.organizationService.getConfiguration().isCountPaginatedUsers());
        TestLDAPAsExternalStore.assertFalse((boolean)this.organizationService.getConfiguration().isSkipPaginationInMembershipQuery());
        TestLDAPAsExternalStore.assertTrue((boolean)(identityStoreRepository instanceof ExoFallbackIdentityStoreRepository));
        TestLDAPAsExternalStore.assertTrue((boolean)this.organizationService.getConfiguration().isIgnoreMappedMembershipTypeForGroup("/organization_hierarchy/OrganizationD"));
        TestLDAPAsExternalStore.assertTrue((boolean)this.organizationService.getConfiguration().isIgnoreMappedMembershipTypeForGroup("/role_hierarchy/User"));
    }

    public void testStoreToUse() throws Exception {
        ExoFallbackIdentityStoreRepository exoFallbackIdentityStoreRepository = this.externalStoreService.getFallbackStoreRepository();
        TestLDAPAsExternalStore.assertEquals((Object)exoFallbackIdentityStoreRepository.getIdentityStore(), (Object)exoFallbackIdentityStoreRepository.getDefaultIdentityStore());
        exoFallbackIdentityStoreRepository.setUseExternalStore(Boolean.valueOf(true));
        try {
            TestLDAPAsExternalStore.assertEquals((Object)exoFallbackIdentityStoreRepository.getIdentityStore(), (Object)exoFallbackIdentityStoreRepository.getExternalIdentityStore());
        }
        finally {
            exoFallbackIdentityStoreRepository.setUseExternalStore(Boolean.valueOf(false));
        }
        TestLDAPAsExternalStore.assertEquals((Object)exoFallbackIdentityStoreRepository.getIdentityStore(), (Object)exoFallbackIdentityStoreRepository.getDefaultIdentityStore());
    }

    public void testAuthenticate() throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName("jduke1");
        TestLDAPAsExternalStore.assertNull((Object)user);
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        TestLDAPAsExternalStore.assertEquals((int)0, (int)allusers.getSize());
        boolean authenticated = this.organizationService.getUserHandler().authenticate("jduke1", "test");
        TestLDAPAsExternalStore.assertFalse((boolean)authenticated);
        user = this.organizationService.getUserHandler().findUserByName("jduke1");
        TestLDAPAsExternalStore.assertNull((Object)user);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestLDAPAsExternalStore.assertEquals((int)0, (int)allusers.getSize());
        authenticated = this.organizationService.getUserHandler().authenticate("jduke1", "theduke");
        TestLDAPAsExternalStore.assertTrue((boolean)authenticated);
        user = this.organizationService.getUserHandler().findUserByName("jduke1");
        TestLDAPAsExternalStore.assertNotNull((Object)user);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestLDAPAsExternalStore.assertEquals((int)1, (int)allusers.getSize());
    }
}

