/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganization-configuration.xml")})
public class TestHibernateOrganization
extends AbstractKernelTest {
    protected static final String DEFAULT_PASSWORD = "defaultpassword";
    protected OrganizationService organizationService;

    protected void setUp() throws Exception {
        super.setUp();
        this.begin();
        PortalContainer container = this.getContainer();
        this.organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testTransactionRollback() throws Exception {
        try {
            this.createUser("userRollback", new String[0]);
            this.createUser("userRollback", new String[0]);
            TestHibernateOrganization.fail((String)"The user creation must fail since we cannot create 2 users with the same username");
        }
        catch (Exception exception) {
        }
        finally {
            RequestLifeCycle.end();
        }
        User userRollback = this.organizationService.getUserHandler().findUserByName("userRollback");
        TestHibernateOrganization.assertNull((String)"User should not have been created", (Object)userRollback);
        try {
            RequestLifeCycle.begin((ExoContainer)this.getContainer());
            this.createUser("userRollback", new String[0]);
        }
        finally {
            RequestLifeCycle.end();
        }
        userRollback = this.organizationService.getUserHandler().findUserByName("userRollback");
        TestHibernateOrganization.assertNotNull((String)"User should have been created", (Object)userRollback);
        RequestLifeCycle.begin((ExoContainer)this.getContainer());
    }

    protected void createUser(String username, String ... groups) throws Exception {
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.createUserInstance(username);
        user.setPassword(DEFAULT_PASSWORD);
        user.setFirstName("default");
        user.setLastName("default");
        user.setEmail(username + "@exoportal.org");
        if (groups.length > 0) {
            user.setOrganizationId(groups[0]);
        }
        userHandler.createUser(user, true);
    }
}

