/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.TestLDAPOrganization;
import org.exoplatform.services.organization.User;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-ldap-user-only-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganization-configuration.xml")})
public class TestLDAPUserOnlyOrganization
extends TestLDAPOrganization {
    @Override
    public void synchronizeUsers() throws Exception {
    }

    public void testGetUserGroups() throws Exception {
        User user;
        this.begin();
        User testUser = this.userHandler_.findUserByName("jduke");
        Group group = this.groupHandler_.findGroupById("testOrganization_group1");
        MembershipType mt1 = this.mtHandler_.createMembershipTypeInstance();
        mt1.setName("test");
        this.mtHandler_.createMembershipType(mt1, true);
        this.membershipHandler_.linkMembership(testUser, group, mt1, true);
        ListAccess users = this.userHandler_.findUsersByGroupId("testOrganization_group1");
        TestLDAPUserOnlyOrganization.assertTrue((String)"Group memberships is empty", (users.getSize() > 0 ? 1 : 0) != 0);
        User[] usersArray = (User[])users.load(0, users.getSize());
        TestLDAPUserOnlyOrganization.assertTrue((String)"Loaded group memberships is empty which is not coherent with the size of ListAccess", (usersArray.length > 0 ? 1 : 0) != 0);
        boolean foundUser = false;
        for (int i = 0; i < usersArray.length && !foundUser; foundUser |= user.getUserName().equals(testUser.getUserName()), ++i) {
            user = usersArray[i];
        }
        TestLDAPUserOnlyOrganization.assertTrue((String)"User test is not found in group testOrganization_group1", (boolean)foundUser);
    }

    @Override
    public void testFindUser() throws Exception {
    }

    @Override
    public void testFindFilteredGroup() throws Exception {
    }
}

