/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore;

import exo.portal.component.identiy.opendsconfig.opends.OpenDSService;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreImportService;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.organization.externalstore.IDMQueueService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.idm.MembershipDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.externalstore.PicketLinkIDMExternalStoreService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-external-ldap-store-configuration.xml")})
public class TestPLIDMExternalStoreImportService
extends AbstractKernelTest {
    private static final String NICKNAME_PARAM = "user.name.nickName";
    private OpenDSService openDSService = new OpenDSService(null);
    private PicketLinkIDMExternalStoreService externalStoreService;
    private IDMExternalStoreImportService externalStoreImportService;
    private IDMQueueService queueService;
    private ListenerService listenerService;
    private PicketLinkIDMOrganizationServiceImpl organizationService;
    private AtomicInteger listenerDeleteUser = new AtomicInteger(0);
    private AtomicInteger listenerModifyUser = new AtomicInteger(0);
    private AtomicInteger listenerAddUser = new AtomicInteger(0);
    private Listener<IDMExternalStoreService, User> userAddedListener = new Listener<IDMExternalStoreService, User>(){

        public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
            TestCase.assertNotNull(event);
            TestCase.assertNotNull((Object)event.getSource());
            User user = (User)event.getData();
            TestCase.assertNotNull((Object)user);
            TestCase.assertNotNull((Object)TestPLIDMExternalStoreImportService.this.organizationService.getUserHandler().findUserByName(user.getUserName()));
            TestPLIDMExternalStoreImportService.this.listenerAddUser.incrementAndGet();
        }
    };
    private Listener<IDMExternalStoreService, User> userDeleteListener = new Listener<IDMExternalStoreService, User>(){

        public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
            TestCase.assertNotNull(event);
            TestCase.assertNotNull((Object)event.getSource());
            User user = (User)event.getData();
            TestCase.assertNotNull((Object)user);
            TestCase.assertNull((Object)TestPLIDMExternalStoreImportService.this.organizationService.getUserHandler().findUserByName(user.getUserName()));
            TestPLIDMExternalStoreImportService.this.listenerDeleteUser.incrementAndGet();
        }
    };
    private Listener<IDMExternalStoreService, User> userModifiedListener = new Listener<IDMExternalStoreService, User>(){

        public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
            TestCase.assertNotNull(event);
            TestCase.assertNotNull((Object)event.getSource());
            User user = (User)event.getData();
            TestCase.assertNotNull((Object)user);
            TestCase.assertNotNull((Object)TestPLIDMExternalStoreImportService.this.organizationService.getUserHandler().findUserByName(user.getUserName()));
            TestPLIDMExternalStoreImportService.this.listenerModifyUser.incrementAndGet();
        }
    };
    private UserEventListener errorOnUserEventListener = new UserEventListener(this){

        public void preSave(User user, boolean isNew) throws Exception {
            throw new Exception("Fake exception !"){

                @Override
                public void printStackTrace(PrintStream s) {
                }

                @Override
                public void printStackTrace(PrintWriter s) {
                }

                @Override
                public void printStackTrace() {
                }
            };
        }
    };

    public void setUp() throws Exception {
        this.setForceContainerReload(true);
        this.externalStoreService = (PicketLinkIDMExternalStoreService)this.getContainer().getComponentInstanceOfType(IDMExternalStoreService.class);
        this.listenerService = (ListenerService)this.getContainer().getComponentInstanceOfType(ListenerService.class);
        this.organizationService = (PicketLinkIDMOrganizationServiceImpl)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.queueService = (IDMQueueService)this.getContainer().getComponentInstanceOfType(IDMQueueService.class);
        this.externalStoreImportService = (IDMExternalStoreImportService)this.getContainer().getComponentInstanceOfType(IDMExternalStoreImportService.class);
        this.listenerAddUser.set(0);
        this.listenerModifyUser.set(0);
        this.listenerService.addListener("exo.idm.externalStore.user.deleted", this.userDeleteListener);
        this.listenerService.addListener("exo.idm.externalStore.user.new", this.userAddedListener);
        this.listenerService.addListener("exo.idm.externalStore.user.modified", this.userModifiedListener);
        this.begin();
        this.resetData();
        Thread.sleep(2000L);
    }

    public void tearDown() throws Exception {
        this.deleteData();
        this.end();
        super.tearDown();
    }

    private void resetData() throws Exception {
        this.deleteData();
        this.openDSService.initLDAPServer();
        this.openDSService.populateLDIFFile("ldap/ldap/initial-opends-external.ldif");
        this.externalStoreService.initializeGroupTree(this.externalStoreService.getReversedGroupTypeMappings());
    }

    private void deleteData() throws Exception {
        this.openDSService.cleanUpDN("dc=portal,dc=example,dc=com");
        this.removeAllUsers();
        this.removeGroupTree(null);
        this.queueService.setLastCheckedTime(IDMEntityType.USER, null);
        this.queueService.setLastCheckedTime(IDMEntityType.GROUP, null);
        this.organizationService.getUserHandler().removeUserEventListener(this.errorOnUserEventListener);
    }

    private void removeAllUsers() throws Exception {
        User[] users;
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        for (User user : users = (User[])allusers.load(0, allusers.getSize())) {
            this.organizationService.getUserHandler().removeUser(user.getUserName(), true);
        }
    }

    public void beforeRunBare() {
        try {
            this.openDSService.start();
            this.openDSService.initLDAPServer();
        }
        catch (Exception e) {
            this.log.error((Object)"Error in starting up OPENDS", (Throwable)e);
            e.printStackTrace();
        }
        super.beforeRunBare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportGroups() throws Exception {
        Collection allGroups = this.organizationService.getGroupHandler().getAllGroups();
        TestPLIDMExternalStoreImportService.assertEquals((String)"Parent groups of LDAP Groups should exist on internal store", (int)2, (int)allGroups.size());
        ListAccess allGroupsListAccess = this.externalStoreService.getAllOfType(IDMEntityType.GROUP, null);
        String[] groupIds = (String[])allGroupsListAccess.load(0, 100);
        int initialExternalGroupSize = groupIds.length;
        TestPLIDMExternalStoreImportService.assertEquals((String)"8 LDAP groups should be detected", (int)8, (int)initialExternalGroupSize);
        this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.GROUP);
        TestPLIDMExternalStoreImportService.assertEquals((String)"All detected groups on external store should be added to the IDM processing queue", (int)initialExternalGroupSize, (int)this.queueService.countAll());
        this.externalStoreImportService.processQueueEntries();
        TestPLIDMExternalStoreImportService.assertEquals((String)"The queue should be empty once processed", (int)0, (int)this.queueService.countAll());
        allGroups = this.organizationService.getGroupHandler().getAllGroups();
        TestPLIDMExternalStoreImportService.assertEquals((String)"Internal stored groups should equals to External groups + 2 parent LDAP groups", (int)(initialExternalGroupSize + 2), (int)allGroups.size());
        this.openDSService.populateLDIFFile("ldap/ldap/test-group-modification-opends.ldif");
        Thread.sleep(1000L);
        try {
            TestPLIDMExternalStoreImportService.assertNotNull((String)"'/role_hierarchy/Delta' should have been imported on LDAP", (Object)this.externalStoreService.getEntity(IDMEntityType.GROUP, (Object)"/role_hierarchy/Delta"));
            Collection memberships = ((MembershipDAOImpl)this.organizationService.getMembershipHandler()).findMembershipsByGroupId("/role_hierarchy/Delta");
            int initialMembershipsSize = memberships.size();
            this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.GROUP);
            TestPLIDMExternalStoreImportService.assertEquals((String)"A new Group should be detected on external store.", (int)1, (int)this.queueService.countAll());
            this.externalStoreImportService.processQueueEntries();
            TestPLIDMExternalStoreImportService.assertEquals((String)"The queue should be purged once the new group imported on internal store", (int)0, (int)this.queueService.countAll());
            allGroups = this.organizationService.getGroupHandler().getAllGroups();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Internal stored groups should equals to External groups + 2 parent LDAP groups + new added group", (int)(initialExternalGroupSize + 3), (int)allGroups.size());
            Group group = this.organizationService.getGroupHandler().findGroupById("/role_hierarchy/Delta");
            TestPLIDMExternalStoreImportService.assertNotNull((String)"New added group should be detected", (Object)group);
            TestPLIDMExternalStoreImportService.assertFalse((String)"New added group should be recognized as external mapped group", (boolean)group.isInternalStore());
            TestPLIDMExternalStoreImportService.assertEquals((String)"New added group should be recognized as external mapped group", (String)"external", (String)group.getOriginatingStore());
            memberships = ((MembershipDAOImpl)this.organizationService.getMembershipHandler()).findMembershipsByGroupId("/role_hierarchy/Delta");
            TestPLIDMExternalStoreImportService.assertEquals((String)"New added group memberships should be imported too", (int)(initialMembershipsSize + 1), (int)memberships.size());
            this.openDSService.populateLDIFFile("ldap/ldap/test-group-member-modification-opends.ldif");
            Thread.sleep(1000L);
            this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.GROUP);
            TestPLIDMExternalStoreImportService.assertEquals((String)"Membership modification on Group should be detected", (int)1, (int)this.queueService.countAll());
            this.externalStoreImportService.processQueueEntries();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Queue must be purged once the membership entity processing is successfully done", (int)0, (int)this.queueService.countAll());
            allGroups = this.organizationService.getGroupHandler().getAllGroups();
            TestPLIDMExternalStoreImportService.assertEquals((String)"The group size should be kept the same as before membership modification", (int)(initialExternalGroupSize + 3), (int)allGroups.size());
            group = this.organizationService.getGroupHandler().findGroupById("/role_hierarchy/Delta");
            TestPLIDMExternalStoreImportService.assertNotNull((String)"The modified group '/role_hierarchy/Delta' should exist on internal store", (Object)group);
            memberships = ((MembershipDAOImpl)this.organizationService.getMembershipHandler()).findMembershipsByGroupId("/role_hierarchy/Delta");
            TestPLIDMExternalStoreImportService.assertEquals((String)"The deleted membership from external store should be deleted from internal store too", (int)0, (int)memberships.size());
            this.openDSService.cleanUpDN("cn=Delta,ou=Roles,o=test,dc=portal,dc=example,dc=com");
            this.externalStoreImportService.checkEntitiesToDeleteIntoQueue(IDMEntityType.GROUP);
            TestPLIDMExternalStoreImportService.assertEquals((String)"The group deletion should be detected.", (int)1, (int)this.queueService.countAll());
            this.externalStoreImportService.processQueueEntries();
            TestPLIDMExternalStoreImportService.assertEquals((String)"The queue must be purged once the group deletion is processed on internal store.", (int)0, (int)this.queueService.countAll());
            allGroups = this.organizationService.getGroupHandler().getAllGroups();
            TestPLIDMExternalStoreImportService.assertEquals((String)"The group size should be equal to initialGroupSize + 2 parent LDAP groups, since the group '/role_hierarchy/Delta' is deleted.", (int)(initialExternalGroupSize + 2), (int)allGroups.size());
            group = this.organizationService.getGroupHandler().findGroupById("/role_hierarchy/Delta");
            TestPLIDMExternalStoreImportService.assertNull((String)"The group '/role_hierarchy/Delta' should have been deleted from internal store.", (Object)group);
        }
        finally {
            if (this.externalStoreService.getEntity(IDMEntityType.GROUP, (Object)"/role_hierarchy/Delta") != null) {
                this.openDSService.cleanUpDN("cn=Delta,ou=Roles,o=test,dc=portal,dc=example,dc=com");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportUsers() throws Exception {
        TestPLIDMExternalStoreImportService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"Initial listenerDeleteUser invocation count must be 0", (int)0, (int)this.listenerDeleteUser.get());
        this.createLDAPGroup("Admin");
        this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.USER);
        TestPLIDMExternalStoreImportService.assertEquals((String)"Queue size should be greater than 0 to import all users", (int)11, (int)this.queueService.countAll());
        this.externalStoreImportService.processQueueEntries();
        TestPLIDMExternalStoreImportService.assertEquals((String)"Queue should be purged once processed.", (int)0, (int)this.queueService.countAll());
        int initialUsersSize = this.organizationService.getUserHandler().findAllUsers().getSize();
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user creation' should be triggered as many as external users count.", (int)initialUsersSize, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user modification' shouldn't be triggered.", (int)0, (int)this.listenerModifyUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user deletion' shouldn't be triggered.", (int)0, (int)this.listenerDeleteUser.get());
        ListAccess allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreImportService.assertEquals((String)"The internal created users count should be equal to external users count.", (int)initialUsersSize, (int)allUsersListAccess.getSize());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The internal created users count should be equal to external users count.", (int)initialUsersSize, (int)((User[])allUsersListAccess.load(0, allUsersListAccess.getSize())).length);
        this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.USER);
        TestPLIDMExternalStoreImportService.assertEquals((String)"No new user should be detected to be imported on internal store", (int)0, (int)this.queueService.countAll());
        this.externalStoreImportService.processQueueEntries();
        TestPLIDMExternalStoreImportService.assertEquals((String)"Queue must be empty", (int)0, (int)this.queueService.countAll());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user creation' shouldn't be triggered again", (int)initialUsersSize, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user modification' shouldn't be triggered", (int)0, (int)this.listenerModifyUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user deletion' shouldn't be triggered", (int)0, (int)this.listenerDeleteUser.get());
        ListAccess allExternalUsernames = this.externalStoreService.getAllOfType(IDMEntityType.USER, null);
        initialUsersSize = ((String[])allExternalUsernames.load(0, Integer.MAX_VALUE)).length;
        this.openDSService.populateLDIFFile("ldap/ldap/test-user-modification-opends.ldif");
        Thread.sleep(1000L);
        this.openDSService.populateLDIFFile("ldap/ldap/test-user-group-modification-opends.ldif");
        Thread.sleep(1000L);
        try {
            allExternalUsernames = this.externalStoreService.getAllOfType(IDMEntityType.USER, null);
            TestPLIDMExternalStoreImportService.assertEquals((String)"External users count should be (initialUsersSize + 2) after importing LDIF.", (int)(initialUsersSize + 2), (int)((String[])allExternalUsernames.load(0, Integer.MAX_VALUE)).length);
            Collection memberships = ((MembershipDAOImpl)this.organizationService.getMembershipHandler()).findMembershipsByGroupId("/role_hierarchy/Admin");
            TestPLIDMExternalStoreImportService.assertNotNull((String)"'/role_hierarchy/Admin' should have memberships since LDIF is successfully imported", (Object)memberships);
            int initialMembershipsCount = memberships.size();
            TestPLIDMExternalStoreImportService.assertNotNull((String)"'jduke10' should have been imported on LDAP", (Object)this.externalStoreService.getEntity(IDMEntityType.USER, (Object)"jduke10"));
            TestPLIDMExternalStoreImportService.assertNotNull((String)"'jduke11' should have been imported on LDAP", (Object)this.externalStoreService.getEntity(IDMEntityType.USER, (Object)"jduke11"));
            this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.USER);
            TestPLIDMExternalStoreImportService.assertEquals((String)"Two new users should be detected as added on external store", (int)2, (int)this.queueService.countAll());
            this.externalStoreImportService.processQueueEntries();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Queue must be purged once the two new users are imported", (int)0, (int)this.queueService.countAll());
            allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Internal users size should equal to initialUsersSize + two added users", (int)(initialUsersSize + 2), (int)allUsersListAccess.getSize());
            TestPLIDMExternalStoreImportService.assertEquals((String)"Internal users size should equal to initialUsersSize + two added users", (int)(initialUsersSize + 2), (int)((User[])allUsersListAccess.load(0, allUsersListAccess.getSize())).length);
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user creation' should be triggered two more times", (int)(initialUsersSize + 2), (int)this.listenerAddUser.get());
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user modification' shouldn't be triggered since we created two new users only", (int)0, (int)this.listenerModifyUser.get());
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user deletion' shouldn't be triggered since we created two new users only", (int)0, (int)this.listenerDeleteUser.get());
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName("jduke10");
            TestPLIDMExternalStoreImportService.assertNotNull((String)"The user 'jduke10' profile should have been imported", (Object)userProfile);
            TestPLIDMExternalStoreImportService.assertEquals((String)"The user 'jduke10' profile should have been imported with attribute 'user.name.nickName'", (String)"Duke10", (String)userProfile.getAttribute(NICKNAME_PARAM));
            memberships = this.organizationService.getMembershipHandler().findMembershipsByUser("jduke10");
            TestPLIDMExternalStoreImportService.assertNotNull((String)"User 'jduke10' memberships should have been imported", (Object)memberships);
            TestPLIDMExternalStoreImportService.assertEquals((String)"User 'jduke10' single membership should have been imported", (int)1, (int)memberships.size());
            memberships = ((MembershipDAOImpl)this.organizationService.getMembershipHandler()).findMembershipsByGroupId("/role_hierarchy/Admin");
            TestPLIDMExternalStoreImportService.assertNotNull((String)"'/role_hierarchy/Admin' should have memberships since LDIF is successfully imported", (Object)memberships);
            TestPLIDMExternalStoreImportService.assertEquals((String)"User 'jduke10' membership should have been imported on group '/role_hierarchy/Admin'", (int)(initialMembershipsCount + 1), (int)memberships.size());
            this.openDSService.populateLDIFFile("ldap/ldap/test-user-attribute-modification-opends.ldif");
            User user = (User)this.externalStoreService.getEntity(IDMEntityType.USER, (Object)"jduke10");
            TestPLIDMExternalStoreImportService.assertEquals((String)"User 'jduke10' should have been modified on external store", (String)"Duke", (String)user.getLastName());
            this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.USER);
            TestPLIDMExternalStoreImportService.assertTrue((String)"User 'jduke10' attribute modification should have been detected.", (this.queueService.countAll() > 0 ? 1 : 0) != 0);
            this.externalStoreImportService.processQueueEntries();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Queue must be purged once 'jduke10' user modified", (int)0, (int)this.queueService.countAll());
            allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
            TestPLIDMExternalStoreImportService.assertEquals((String)"User 'jduke10' modification import operation shouldn't modify internal users count", (int)(initialUsersSize + 2), (int)allUsersListAccess.getSize());
            TestPLIDMExternalStoreImportService.assertEquals((String)"User 'jduke10' modification import operation shouldn't modify internal users count", (int)(initialUsersSize + 2), (int)((User[])allUsersListAccess.load(0, allUsersListAccess.getSize())).length);
            user = this.organizationService.getUserHandler().findUserByName("jduke10");
            TestPLIDMExternalStoreImportService.assertEquals((String)"User 'jduke10' modification import operation should have modified user last name", (String)"Duke", (String)user.getLastName());
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user creation' shouldn't be triggered once a modification is imported on internal store", (int)(initialUsersSize + 2), (int)this.listenerAddUser.get());
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user modification' should be triggered once a modification is imported on internal store", (int)1, (int)this.listenerModifyUser.get());
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user deletion' shouldn't be triggered once a modification is imported on internal store", (int)0, (int)this.listenerDeleteUser.get());
            this.openDSService.cleanUpDN("uid=jduke10,ou=People,o=test,dc=portal,dc=example,dc=com");
            this.openDSService.cleanUpDN("uid=jduke11,ou=People,o=test,dc=portal,dc=example,dc=com");
            Thread.sleep(1000L);
            this.externalStoreImportService.checkEntitiesToDeleteIntoQueue(IDMEntityType.USER);
            TestPLIDMExternalStoreImportService.assertEquals((String)"Users deletion should have been detected.", (int)2, (int)this.queueService.countAll());
            this.externalStoreImportService.processQueueEntries();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Queue must be purged once deletion is processed on internal store", (int)0, (int)this.queueService.countAll());
            allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Internal users size should equals to initialUsersSize once two users are deleted", (int)initialUsersSize, (int)allUsersListAccess.getSize());
            TestPLIDMExternalStoreImportService.assertEquals((String)"Internal users size should equals to initialUsersSize once two users are deleted", (int)initialUsersSize, (int)((User[])allUsersListAccess.load(0, allUsersListAccess.getSize())).length);
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user creation' shouldn't be triggered once a deletion is made on internal store", (int)(initialUsersSize + 2), (int)this.listenerAddUser.get());
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user modification' shouldn't be triggered once a deletion is made on internal store", (int)1, (int)this.listenerModifyUser.get());
            TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user deletion' should be triggered once two deletions are made on internal store", (int)2, (int)this.listenerDeleteUser.get());
            userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName("jduke10");
            TestPLIDMExternalStoreImportService.assertNull((String)"The user 'jduke10' profile should be deleted once the user is deleted from internal store", (Object)userProfile);
            memberships = ((MembershipDAOImpl)this.organizationService.getMembershipHandler()).findMembershipsByGroupId("/role_hierarchy/Admin");
            TestPLIDMExternalStoreImportService.assertNotNull((Object)memberships);
            TestPLIDMExternalStoreImportService.assertEquals((String)"The user 'jduke10' membership in Group '/role_hierarchy/Admin' should have been deleted", (int)initialMembershipsCount, (int)memberships.size());
            this.openDSService.populateLDIFFile("ldap/ldap/test-user-disable-opends.ldif");
            Thread.sleep(1000L);
            this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.USER);
            TestPLIDMExternalStoreImportService.assertEquals((String)"Users creation should have been detected.", (int)2, (int)this.queueService.countAll());
            this.externalStoreImportService.processQueueEntries();
            allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
            TestPLIDMExternalStoreImportService.assertEquals((String)"Internal users size should equals to initialUsersSize because users were disabled and were not deleted", (int)(initialUsersSize + 2), (int)allUsersListAccess.getSize());
            this.externalStoreImportService.setDeleteMissingEntriesFromInternalStore(false);
            this.openDSService.cleanUpDN("uid=jdukeX,ou=People,o=test,dc=portal,dc=example,dc=com");
            this.openDSService.cleanUpDN("uid=jdukeY,ou=People,o=test,dc=portal,dc=example,dc=com");
            Thread.sleep(1000L);
            this.externalStoreImportService.checkEntitiesToDeleteIntoQueue(IDMEntityType.USER);
            TestPLIDMExternalStoreImportService.assertEquals((String)"Users deletion should have been detected.", (int)2, (int)this.queueService.countAll());
            this.externalStoreImportService.processQueueEntries();
            allUsersListAccess = this.organizationService.getUserHandler().findAllUsers(UserStatus.ANY);
            TestPLIDMExternalStoreImportService.assertEquals((String)"Internal users size should equals to initialUsersSize because users were disabled and were not deleted", (int)(initialUsersSize + 2), (int)allUsersListAccess.getSize());
            TestPLIDMExternalStoreImportService.assertNotNull((Object)this.organizationService.getUserHandler().findUserByName("jdukeX", UserStatus.DISABLED));
            TestPLIDMExternalStoreImportService.assertNotNull((Object)this.organizationService.getUserHandler().findUserByName("jdukeY", UserStatus.DISABLED));
        }
        finally {
            if (this.externalStoreService.getEntity(IDMEntityType.USER, (Object)"jduke10") != null) {
                this.openDSService.cleanUpDN("uid=jduke10,ou=People,o=test,dc=portal,dc=example,dc=com");
            }
            if (this.externalStoreService.getEntity(IDMEntityType.USER, (Object)"jduke11") != null) {
                this.openDSService.cleanUpDN("uid=jduke11,ou=People,o=test,dc=portal,dc=example,dc=com");
            }
        }
    }

    public void testLargeImportUsers() throws Exception {
        TestPLIDMExternalStoreImportService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"Initial listenerDeleteUser invocation count must be 0", (int)0, (int)this.listenerDeleteUser.get());
        this.createLDAPGroup("Admin");
        this.openDSService.populateLDIFFile("ldap/ldap/test-100-users-opends.ldif");
        Thread.sleep(2000L);
        this.externalStoreImportService.importModifiedEntitiesOfTypeToQueue(IDMEntityType.USER);
        TestPLIDMExternalStoreImportService.assertEquals((String)"Queue size should be greater than 0 to import all users", (int)111, (int)this.queueService.countAll());
        this.externalStoreImportService.processQueueEntries();
        TestPLIDMExternalStoreImportService.assertEquals((String)"Queue should be purged once processed.", (int)0, (int)this.queueService.countAll());
        int initialUsersSize = this.organizationService.getUserHandler().findAllUsers().getSize();
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user creation' should be triggered as many as external users count.", (int)initialUsersSize, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user modification' shouldn't be triggered.", (int)0, (int)this.listenerModifyUser.get());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The listener 'user deletion' shouldn't be triggered.", (int)0, (int)this.listenerDeleteUser.get());
        ListAccess allUsersListAccess = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreImportService.assertEquals((String)"The internal created users count should be equal to external users count.", (int)initialUsersSize, (int)allUsersListAccess.getSize());
        TestPLIDMExternalStoreImportService.assertEquals((String)"The internal created users count should be equal to external users count.", (int)initialUsersSize, (int)((User[])allUsersListAccess.load(0, allUsersListAccess.getSize())).length);
    }

    private void removeGroupTree(Group group) throws Exception {
        Collection groups = this.organizationService.getGroupHandler().findGroups(group);
        if (groups != null && groups.size() > 0) {
            for (Group childgroup : groups) {
                this.removeGroupTree(childgroup);
            }
        }
        if (group != null) {
            this.organizationService.getGroupHandler().removeGroup(group, true);
        }
    }

    private void createLDAPGroup(String groupName) throws Exception {
        Group parentLDAPGroup = this.organizationService.getGroupHandler().findGroupById("/role_hierarchy");
        if (parentLDAPGroup == null) {
            TestPLIDMExternalStoreImportService.fail((String)"Parent LDAP Group /role_hierarchy wasn't created");
        }
        Group ldapGroup = this.organizationService.getGroupHandler().createGroupInstance();
        ldapGroup.setId("/role_hierarchy/" + groupName);
        ldapGroup.setGroupName(groupName);
        this.organizationService.getGroupHandler().addChild(parentLDAPGroup, ldapGroup, true);
    }
}

