/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import jakarta.persistence.EntityTransaction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.dao.AbstractDAOTest;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.gatein.api.common.Pagination;

public class WindowDAOTest
extends AbstractDAOTest {
    private WindowDAO windowDAO;
    private EntityTransaction transaction;

    @Override
    protected void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.windowDAO = (WindowDAO)this.getContainer().getComponentInstanceOfType(WindowDAO.class);
        EntityManagerService managerService = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        this.transaction = managerService.getEntityManager().getTransaction();
        this.transaction.begin();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.transaction.isActive()) {
            this.transaction.rollback();
        }
        super.tearDown();
        this.end();
    }

    public void testCreateContainer() {
        WindowEntity entity = this.createInstance("content1", WindowEntity.AppType.PORTLET);
        this.windowDAO.create((Object)entity);
        this.restartTransaction();
        WindowEntity result = (WindowEntity)this.windowDAO.find((Serializable)entity.getId());
        WindowDAOTest.assertNotNull((Object)result);
        this.assertContainer(entity, result);
    }

    public void testFindByIds() {
        WindowEntity entity1 = this.createInstance("content1", WindowEntity.AppType.PORTLET);
        this.windowDAO.create((Object)entity1);
        WindowEntity entity2 = this.createInstance("content2", WindowEntity.AppType.PORTLET);
        this.windowDAO.create((Object)entity2);
        this.restartTransaction();
        List results = this.windowDAO.findByIds(Arrays.asList(entity1.getId(), entity2.getId()));
        WindowDAOTest.assertEquals((int)2, (int)results.size());
    }

    public void testDeleteByContentId() {
        String toDeleteContentId = "App1/toDeletePortlet1";
        this.windowDAO.create((Object)this.createInstance(toDeleteContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(toDeleteContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(toDeleteContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(toDeleteContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(toDeleteContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance("App2/toNotDeletePortlet2", WindowEntity.AppType.PORTLET));
        this.restartTransaction();
        List results = this.windowDAO.findIdsByContentIds(Arrays.asList(toDeleteContentId, "App2/toNotDeletePortlet2"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)6, (int)results.size());
        this.windowDAO.deleteByContentId(toDeleteContentId);
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(toDeleteContentId), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)0, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(toDeleteContentId, "App2/toNotDeletePortlet2"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)1, (int)results.size());
    }

    public void testUpdateContentId() {
        String oldContentId = "App1/toUpdatePortlet1";
        String newContentId = "App1/updatedPortlet1";
        this.windowDAO.create((Object)this.createInstance(oldContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(oldContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(oldContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(oldContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance(oldContentId, WindowEntity.AppType.PORTLET));
        this.windowDAO.create((Object)this.createInstance("App2/toNotUpdatePortlet2", WindowEntity.AppType.PORTLET));
        this.restartTransaction();
        List results = this.windowDAO.findIdsByContentIds(Arrays.asList(newContentId), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)0, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(oldContentId, "App2/toNotUpdatePortlet2"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)6, (int)results.size());
        this.windowDAO.updateContentId(oldContentId, newContentId);
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(oldContentId), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)0, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(oldContentId, "App2/toNotUpdatePortlet2"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)1, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(oldContentId, newContentId, "App2/toNotUpdatePortlet2"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)6, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(newContentId), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)5, (int)results.size());
    }

    public void testfindByContentIds() {
        WindowEntity entity1 = this.createInstance("App1/portlet1", WindowEntity.AppType.PORTLET);
        this.windowDAO.create((Object)entity1);
        WindowEntity entity2 = this.createInstance("App2/portlet2", WindowEntity.AppType.PORTLET);
        this.windowDAO.create((Object)entity2);
        this.restartTransaction();
        List results = this.windowDAO.findIdsByContentIds(Arrays.asList("App1/portlet1", "App2/portlet1"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)1, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList("app1/portlet1", "app2/portlet2"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)0, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList("App1/portlet1", "App2/portlet2"), new Pagination(0, 10));
        WindowDAOTest.assertEquals((int)2, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList("App1/portlet1", "App2/portlet2"), new Pagination(0, 1));
        WindowDAOTest.assertEquals((int)1, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList("App1/portlet1", "App2/portlet2"), new Pagination(0, 1).getNext());
        WindowDAOTest.assertEquals((int)1, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList("App1/portlet1", "App2/portlet2"), new Pagination(0, 1).getNext().getNext());
        WindowDAOTest.assertEquals((int)0, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList(new String[0]), new Pagination(0, 10));
        WindowDAOTest.assertNotNull((Object)results);
        WindowDAOTest.assertEquals((int)0, (int)results.size());
        results = this.windowDAO.findIdsByContentIds(Arrays.asList("app1"), new Pagination(0, 10));
        WindowDAOTest.assertNotNull((Object)results);
        WindowDAOTest.assertEquals((int)0, (int)results.size());
    }

    private WindowEntity createInstance(String contentId, WindowEntity.AppType type) {
        WindowEntity entity = new WindowEntity();
        entity.setAppType(type);
        entity.setContentId(contentId);
        entity.setCustomization("testCustom".getBytes());
        entity.setHeight("testHeight");
        entity.setIcon("testIcon");
        entity.setProperties("testProps");
        entity.setShowApplicationMode(true);
        entity.setShowApplicationState(true);
        entity.setShowInfoBar(true);
        entity.setTheme("testTheme");
        entity.setTitle("testTitle");
        entity.setDescription("testDesc");
        entity.setTitle("testTitle");
        entity.setWidth("testWidth");
        return entity;
    }

    private void assertContainer(WindowEntity expected, WindowEntity result) {
        WindowDAOTest.assertEquals((String)expected.getDescription(), (String)result.getDescription());
        WindowDAOTest.assertEquals((String)expected.getHeight(), (String)result.getHeight());
        WindowDAOTest.assertEquals((String)expected.getIcon(), (String)result.getIcon());
        WindowDAOTest.assertEquals((Object)expected.getId(), (Object)result.getId());
        WindowDAOTest.assertEquals((String)expected.getProperties(), (String)result.getProperties());
        WindowDAOTest.assertEquals((String)expected.getTitle(), (String)result.getTitle());
        WindowDAOTest.assertEquals((String)expected.getWidth(), (String)result.getWidth());
        WindowDAOTest.assertEquals((String)expected.getContentId(), (String)result.getContentId());
        WindowDAOTest.assertEquals((String)expected.getTheme(), (String)result.getTheme());
        WindowDAOTest.assertEquals((boolean)expected.isShowApplicationMode(), (boolean)result.isShowApplicationMode());
        WindowDAOTest.assertEquals((boolean)expected.isShowApplicationState(), (boolean)result.isShowApplicationState());
        WindowDAOTest.assertEquals((boolean)expected.isShowInfoBar(), (boolean)result.isShowInfoBar());
        WindowDAOTest.assertEquals((Object)expected.getAppType(), (Object)result.getAppType());
        WindowDAOTest.assertEquals((int)expected.getCustomization().length, (int)result.getCustomization().length);
    }
}

