/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

public class UserPortalTest
extends AbstractConfigTest {
    private static final String TEST_USER_PORTAL_GROUP = "/platform";
    private static final SiteKey TEST_USER_PORTAL_SITE_KEY = SiteKey.group((String)"/platform");
    private UserPortal userPortal;
    private NavigationService navigationService;
    private UserPortalConfigService portalConfigService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.begin();
        Identity identity = new Identity("root", Arrays.asList(new MembershipEntry(TEST_USER_PORTAL_GROUP), new MembershipEntry("/platform/users"), new MembershipEntry("/platform/administrators")));
        ConversationState conversationState = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)conversationState);
        this.navigationService = (NavigationService)this.getContainer().getComponentInstanceOfType(NavigationService.class);
        this.portalConfigService = (UserPortalConfigService)this.getContainer().getComponentInstanceOfType(UserPortalConfigService.class);
        UserPortalConfig userPortalConfig = this.portalConfigService.getUserPortalConfig("classic", "root");
        this.userPortal = userPortalConfig.getUserPortal();
        this.removeTestedNavigation();
    }

    @Override
    protected void tearDown() throws Exception {
        this.removeTestedNavigation();
        this.end();
        ConversationState.setCurrent(null);
        super.tearDown();
    }

    public void testCreate() throws Exception {
        List navs = this.userPortal.getNavigations();
        UserPortalTest.assertFalse((boolean)navs.isEmpty());
        int initialSize = navs.size();
        this.createTestedNavigation();
        this.userPortal.refresh();
        navs = this.userPortal.getNavigations();
        UserPortalTest.assertEquals((int)(initialSize + 1), (int)navs.size());
    }

    public void testUpdate() throws Exception {
        List navs = this.userPortal.getNavigations();
        UserPortalTest.assertFalse((boolean)navs.isEmpty());
        int initialSize = navs.size();
        this.createTestedNavigation();
        this.userPortal.refresh();
        navs = this.userPortal.getNavigations();
        UserPortalTest.assertFalse((boolean)navs.isEmpty());
        UserPortalTest.assertEquals((int)(initialSize + 1), (int)navs.size());
        UserNavigation userNavigation = this.userPortal.getNavigation(TEST_USER_PORTAL_SITE_KEY);
        UserPortalTest.assertNotNull((Object)userNavigation);
        NodeContext root = this.navigationService.loadNode(NodeModel.SELF_MODEL, userNavigation.navigation, Scope.ALL, null);
        root.add(null, "foo");
        this.navigationService.saveNode(root, null);
        this.userPortal.refresh();
        navs = this.userPortal.getNavigations();
        UserPortalTest.assertEquals((int)(initialSize + 1), (int)navs.size());
        this.navigationService.destroyNavigation(TEST_USER_PORTAL_SITE_KEY);
        this.userPortal.refresh();
        navs = this.userPortal.getNavigations();
        UserPortalTest.assertEquals((int)initialSize, (int)navs.size());
    }

    public void testDestroy() throws Exception {
        List navs = this.userPortal.getNavigations();
        UserPortalTest.assertFalse((boolean)navs.isEmpty());
        int initialSize = navs.size();
        this.createTestedNavigation();
        this.userPortal.refresh();
        navs = this.userPortal.getNavigations();
        UserPortalTest.assertFalse((boolean)navs.isEmpty());
        UserPortalTest.assertEquals((int)(initialSize + 1), (int)navs.size());
        UserNavigation userNavigation = this.userPortal.getNavigation(TEST_USER_PORTAL_SITE_KEY);
        UserPortalTest.assertNotNull((Object)userNavigation);
        this.navigationService.destroyNavigation(TEST_USER_PORTAL_SITE_KEY);
        this.userPortal.refresh();
        navs = this.userPortal.getNavigations();
        UserPortalTest.assertEquals((int)initialSize, (int)navs.size());
    }

    public void testGetSiteLabels() {
        UserPortalTest.assertEquals((String)"Classic", (String)this.userPortal.getPortalLabel(SiteKey.portal((String)"classic")));
        UserPortalTest.assertEquals((String)"Site classique", (String)this.userPortal.getPortalLabel(SiteKey.portal((String)"classic"), Locale.FRENCH));
        UserPortalTest.assertEquals((String)"This is classic portal for testing", (String)this.userPortal.getPortalDescription(SiteKey.portal((String)"classic")));
        UserPortalTest.assertEquals((String)"Un site pour test seulement", (String)this.userPortal.getPortalDescription(SiteKey.portal((String)"classic"), Locale.FRENCH));
    }

    private void createTestedNavigation() throws Exception {
        this.portalConfigService.createUserPortalConfig(PortalConfig.GROUP_TYPE, TEST_USER_PORTAL_GROUP, "group", "jar:/org/exoplatform/portal/config/conf");
        this.navigationService.saveNavigation(new NavigationContext(TEST_USER_PORTAL_SITE_KEY, new NavigationState(Integer.valueOf(1))));
    }

    private void removeTestedNavigation() throws Exception {
        NavigationContext navigationContext = this.navigationService.loadNavigation(TEST_USER_PORTAL_SITE_KEY);
        if (navigationContext != null) {
            this.portalConfigService.removeUserPortalConfig(TEST_USER_PORTAL_SITE_KEY.getTypeName(), TEST_USER_PORTAL_SITE_KEY.getName());
            this.restartTransaction();
        }
    }
}

