/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.encoder;

import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.gatein.portal.encoder.EncoderService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.encoder-configuration.xml")})
public class TestEncoderService
extends AbstractConfigTest {
    private EncoderService encoderService;

    @Override
    protected void setUp() throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        this.encoderService = (EncoderService)portalContainer.getComponentInstanceOfType(EncoderService.class);
        super.setUp();
    }

    public void testEncoder() throws Exception {
        this.encodeDecodeTest("gtn", "6MSyXIj3kkQ=");
        this.encodeDecodeTest("blabla", "tstM3KRJOU4=");
        this.encodeDecodeTest("gogog", "zlGKEql9zxE=");
    }

    private void encodeDecodeTest(String plainText, String expectedEncoded) throws Exception {
        String encoded = this.encoderService.encode64(plainText);
        TestEncoderService.assertEquals((String)encoded, (String)expectedEncoded);
        String decoded = this.encoderService.decode64(encoded);
        TestEncoderService.assertEquals((String)decoded, (String)plainText);
    }
}

