/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.storage.PageStorage;

public class TestSearch
extends AbstractConfigTest {
    private LayoutService layoutService;
    private PageStorage pageStorage;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.pageStorage = (PageStorage)this.getContainer().getComponentInstanceOfType(PageStorage.class);
    }

    private void assertPageFound(int offset, int limit, SiteType siteType, String siteName, String pageName, String title, String expectedPage) {
        QueryResult res = this.pageStorage.findPages(offset, limit, siteType, siteName, pageName, title);
        TestSearch.assertEquals((int)1, (int)res.getSize());
        TestSearch.assertEquals((String)expectedPage, (String)((PageContext)res.iterator().next()).getKey().format());
    }

    private void assertPageNotFound(int offset, int limit, SiteType siteType, String siteName, String pageName, String title) {
        QueryResult res = this.pageStorage.findPages(offset, limit, siteType, siteName, pageName, title);
        TestSearch.assertEquals((int)0, (int)res.getSize());
    }

    public void testSearchPage() {
        Page page = new Page();
        page.setPageId("portal::test::searchedpage");
        this.pageStorage.savePage(new PageContext(page.getPageKey(), null));
        PageContext pageContext = this.pageStorage.loadPage(page.getPageKey());
        pageContext.setState(pageContext.getState().builder().displayName("Juuu Ziii").build());
        this.pageStorage.savePage(pageContext);
        this.assertPageFound(0, 10, null, null, null, "Juuu Ziii", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "Juuu", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "Ziii", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "juuu ziii", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "juuu", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "ziii", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "juu", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "zii", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "ju", "portal::test::searchedpage");
        this.assertPageFound(0, 10, null, null, null, "zi", "portal::test::searchedpage");
        this.assertPageNotFound(0, 10, null, null, null, "foo");
        this.assertPageNotFound(0, 10, null, null, null, "foo bar");
    }

    public void testSearchPageByOwnerID() {
        QueryResult res = this.pageStorage.findPages(0, 10, null, "foo", null, null);
        TestSearch.assertEquals((int)0, (int)res.getSize());
        res = this.pageStorage.findPages(0, 10, null, "test", null, null);
        int pageNum = res.getSize();
        TestSearch.assertTrue((pageNum > 0 ? 1 : 0) != 0);
        res = this.pageStorage.findPages(0, 10, null, "   test   ", null, null);
        TestSearch.assertEquals((int)pageNum, (int)res.getSize());
        res = this.pageStorage.findPages(0, 10, null, null, null, null);
        TestSearch.assertTrue((res.getSize() > 0 ? 1 : 0) != 0);
    }
}

