/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.rest.NavigationRest;
import org.exoplatform.portal.mop.rest.model.UserNodeBreadcrumbItem;
import org.exoplatform.portal.mop.rest.model.UserNodeRestEntity;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.portal.mop.user.UserPortalImpl;
import org.exoplatform.portal.rest.services.BaseRestServicesTestCase;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NavigationRestTest
extends BaseRestServicesTestCase {
    @Mock
    private UserPortalConfigService portalConfigService;
    @Mock
    private LayoutService layoutService;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private UserACL userACL;

    @Override
    protected Class<?> getComponentClass() {
        return NavigationRest.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.binder.addResource((Object)new NavigationRest(this.portalConfigService, this.layoutService, this.organizationService, this.userACL), null);
    }

    @Override
    protected void registry(Class<?> resourceClass) throws Exception {
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetSiteNavigation() throws Exception {
        String path = "/v1/navigations/";
        String username = "testuser";
        String metaPortalName = "default";
        String globalPortalName = "global";
        String portalName = "test";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        UserPortalConfig userPortalConfig = (UserPortalConfig)Mockito.mock(UserPortalConfig.class);
        UserPortalImpl userPortal = (UserPortalImpl)Mockito.mock(UserPortalImpl.class);
        NavigationState navigationState = (NavigationState)Mockito.mock(NavigationState.class);
        List<UserNavigation> userNavigations = Arrays.asList(new UserNavigation(userPortal, new NavigationContext(SiteKey.portal((String)globalPortalName), navigationState), false), new UserNavigation(userPortal, new NavigationContext(SiteKey.portal((String)portalName), navigationState), false));
        this.startUserSession(username);
        Mockito.when((Object)this.portalConfigService.getMetaPortal()).thenReturn((Object)metaPortalName);
        Mockito.when((Object)this.portalConfigService.getGlobalPortal()).thenReturn((Object)globalPortalName);
        Mockito.when((Object)this.portalConfigService.getUserPortalConfig((String)ArgumentMatchers.eq((Object)metaPortalName), (String)ArgumentMatchers.eq((Object)username), (UserPortalContext)ArgumentMatchers.any())).thenReturn((Object)userPortalConfig);
        Mockito.when((Object)userPortalConfig.getUserPortal()).thenReturn((Object)userPortal);
        Mockito.when((Object)userPortal.getNavigations()).thenReturn(userNavigations);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        NavigationRestTest.assertEquals((int)200, (int)resp.getStatus());
        Object entity = resp.getEntity();
        NavigationRestTest.assertNotNull((Object)entity);
        NavigationRestTest.assertTrue((boolean)(entity instanceof List));
        List navigations = (List)entity;
        NavigationRestTest.assertEquals((int)1, (int)navigations.size());
        NavigationRestTest.assertEquals((String)portalName, (String)((NavigationRest.ResultUserNavigation)navigations.get(0)).getKey().getName());
        NavigationRestTest.assertEquals((Object)SiteType.PORTAL, (Object)((NavigationRest.ResultUserNavigation)navigations.get(0)).getKey().getType());
        Mockito.when((Object)userPortal.getNavigations()).thenThrow(IllegalStateException.class);
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        NavigationRestTest.assertEquals((int)500, (int)resp.getStatus());
    }

    @Test
    public void testGetSiteNavigationWithPageDetails() throws Exception {
        String path = "/v1/navigations/PORTAL?siteName=SiteName&expand=true";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startUserSession("root1");
        ArrayList<UserNode> nodes = new ArrayList<UserNode>();
        Page nodePage = (Page)Mockito.mock(Page.class);
        UserNode userNode = (UserNode)Mockito.mock(UserNode.class);
        nodes.add(userNode);
        UserPortalConfig userPortalConfig = (UserPortalConfig)Mockito.mock(UserPortalConfig.class);
        UserPortal userPortal = (UserPortal)Mockito.mock(UserPortal.class);
        GroupHandler groupHandler = (GroupHandler)Mockito.mock(GroupHandler.class);
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)this.organizationService.getGroupHandler()).thenReturn((Object)groupHandler);
        Mockito.when((Object)groupHandler.findGroupById("/platform/users")).thenReturn((Object)group);
        PageKey pageKey = PageKey.parse((String)"portal::page::ref");
        Mockito.when((Object)this.layoutService.getPage(pageKey)).thenReturn((Object)nodePage);
        Mockito.when((Object)nodePage.getEditPermission()).thenReturn((Object)"*:/platform/users");
        Mockito.when((Object)nodePage.getAccessPermissions()).thenReturn((Object)new String[]{"*:/platform/users"});
        Mockito.when((Object)nodePage.getType()).thenReturn((Object)"LINK");
        Mockito.when((Object)nodePage.getLink()).thenReturn((Object)"www.test.com");
        Mockito.when((Object)userNode.getPageRef()).thenReturn((Object)pageKey);
        Mockito.when((Object)this.portalConfigService.getUserPortalConfig(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (UserPortalContext)ArgumentMatchers.any())).thenReturn((Object)userPortalConfig);
        Mockito.when((Object)userPortalConfig.getUserPortal()).thenReturn((Object)userPortal);
        Mockito.when((Object)userPortal.getNodes((SiteType)ArgumentMatchers.any(SiteType.class), (Scope)ArgumentMatchers.any(Scope.class), (UserNodeFilterConfig)ArgumentMatchers.any(UserNodeFilterConfig.class), ArgumentMatchers.anyBoolean())).thenReturn(nodes);
        Mockito.when((Object)this.userACL.hasEditPermission((Page)ArgumentMatchers.any(Page.class))).thenReturn((Object)true);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        Object entity = resp.getEntity();
        NavigationRestTest.assertEquals((int)200, (int)resp.getStatus());
        NavigationRestTest.assertNotNull((Object)entity);
        List resultUserNodes = (List)resp.getEntity();
        NavigationRestTest.assertEquals((int)1, (int)resultUserNodes.size());
        NavigationRestTest.assertEquals((Object)"*", ((UserNodeRestEntity)resultUserNodes.get(0)).getPageEditPermission().get("membershipType"));
        NavigationRestTest.assertEquals((Object)group, ((UserNodeRestEntity)resultUserNodes.get(0)).getPageEditPermission().get("group"));
        NavigationRestTest.assertEquals((int)1, (int)((UserNodeRestEntity)resultUserNodes.get(0)).getPageAccessPermissions().size());
        NavigationRestTest.assertEquals((Object)"*", ((Map)((UserNodeRestEntity)resultUserNodes.get(0)).getPageAccessPermissions().get(0)).get("membershipType"));
        NavigationRestTest.assertEquals((Object)group, ((Map)((UserNodeRestEntity)resultUserNodes.get(0)).getPageAccessPermissions().get(0)).get("group"));
        Mockito.when((Object)nodePage.getEditPermission()).thenReturn((Object)"manager:/platform/users");
        Mockito.when((Object)nodePage.getAccessPermissions()).thenReturn((Object)new String[]{"Everyone"});
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        entity = resp.getEntity();
        NavigationRestTest.assertEquals((int)200, (int)resp.getStatus());
        NavigationRestTest.assertNotNull((Object)entity);
        resultUserNodes = (List)resp.getEntity();
        NavigationRestTest.assertEquals((int)1, (int)resultUserNodes.size());
        NavigationRestTest.assertEquals((Object)"manager", ((UserNodeRestEntity)resultUserNodes.get(0)).getPageEditPermission().get("membershipType"));
        NavigationRestTest.assertEquals((Object)group, ((UserNodeRestEntity)resultUserNodes.get(0)).getPageEditPermission().get("group"));
        NavigationRestTest.assertEquals((int)1, (int)((UserNodeRestEntity)resultUserNodes.get(0)).getPageAccessPermissions().size());
        NavigationRestTest.assertEquals((Object)"Everyone", ((Map)((UserNodeRestEntity)resultUserNodes.get(0)).getPageAccessPermissions().get(0)).get("membershipType"));
        NavigationRestTest.assertEquals(null, ((Map)((UserNodeRestEntity)resultUserNodes.get(0)).getPageAccessPermissions().get(0)).get("group"));
        NavigationRestTest.assertEquals((String)"www.test.com", (String)((UserNodeRestEntity)resultUserNodes.get(0)).getPageLink());
    }

    @Test
    public void testGetSiteNavigationWithBreadcrumbs() throws Exception {
        String path = "/v1/navigations/PORTAL?siteName=SiteName&expandBreadcrumb=true";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startUserSession("root1");
        ArrayList<UserNode> nodes = new ArrayList<UserNode>();
        Page nodePage = (Page)Mockito.mock(Page.class);
        UserNode parentNode = (UserNode)Mockito.mock(UserNode.class);
        UserNode userNode = (UserNode)Mockito.mock(UserNode.class);
        nodes.add(userNode);
        UserNavigation userNavigation = (UserNavigation)Mockito.mock(UserNavigation.class);
        UserPortalConfig userPortalConfig = (UserPortalConfig)Mockito.mock(UserPortalConfig.class);
        UserPortal userPortal = (UserPortal)Mockito.mock(UserPortal.class);
        PageKey pageKey = PageKey.parse((String)"portal::page::ref");
        Mockito.when((Object)this.layoutService.getPage(pageKey)).thenReturn((Object)nodePage);
        Mockito.when((Object)nodePage.getType()).thenReturn((Object)"PAGE");
        Mockito.when((Object)userNode.getPageRef()).thenReturn((Object)pageKey);
        Mockito.when((Object)userNode.getURI()).thenReturn((Object)"homepage/usernode");
        Mockito.when((Object)userNode.getId()).thenReturn((Object)"1");
        Mockito.when((Object)userNode.getName()).thenReturn((Object)"usernode");
        Mockito.when((Object)userNode.getResolvedLabel()).thenReturn((Object)"user node label");
        Mockito.when((Object)userNode.getTarget()).thenReturn((Object)"SAME_TAB");
        Mockito.when((Object)userNode.getNavigation()).thenReturn((Object)userNavigation);
        SiteKey siteKey = (SiteKey)Mockito.mock(SiteKey.class);
        Mockito.when((Object)userNavigation.getKey()).thenReturn((Object)siteKey);
        Mockito.when((Object)siteKey.getName()).thenReturn((Object)"siteName");
        Mockito.when((Object)userNode.getParent()).thenReturn((Object)parentNode);
        Mockito.when((Object)parentNode.getName()).thenReturn((Object)"default");
        Mockito.when((Object)parentNode.getChildren()).thenReturn(nodes);
        Mockito.when((Object)this.portalConfigService.getUserPortalConfig(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (UserPortalContext)ArgumentMatchers.any())).thenReturn((Object)userPortalConfig);
        Mockito.when((Object)userPortalConfig.getUserPortal()).thenReturn((Object)userPortal);
        Mockito.when((Object)userPortal.getNodes((SiteType)ArgumentMatchers.any(SiteType.class), (Scope)ArgumentMatchers.any(Scope.class), (UserNodeFilterConfig)ArgumentMatchers.any(UserNodeFilterConfig.class), ArgumentMatchers.anyBoolean())).thenReturn(nodes);
        Mockito.when((Object)userPortal.getNode((UserNavigation)ArgumentMatchers.any(UserNavigation.class), (Scope)ArgumentMatchers.any(Scope.class), (UserNodeFilterConfig)ArgumentMatchers.any(UserNodeFilterConfig.class), (NodeChangeListener)ArgumentMatchers.nullable(NodeChangeListener.class))).thenReturn((Object)parentNode);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        Object entity = resp.getEntity();
        NavigationRestTest.assertEquals((int)200, (int)resp.getStatus());
        NavigationRestTest.assertNotNull((Object)entity);
        List resultUserNodes = (List)resp.getEntity();
        NavigationRestTest.assertEquals((int)1, (int)resultUserNodes.size());
        List userNodeBreadcrumbItemList = ((UserNodeRestEntity)resultUserNodes.get(0)).getUserNodeBreadcrumbItemList();
        NavigationRestTest.assertNotNull((Object)userNodeBreadcrumbItemList);
        NavigationRestTest.assertEquals((int)1, (int)userNodeBreadcrumbItemList.size());
        NavigationRestTest.assertEquals((String)"1", (String)((UserNodeBreadcrumbItem)userNodeBreadcrumbItemList.get(0)).getNodeId());
        NavigationRestTest.assertEquals((String)"usernode", (String)((UserNodeBreadcrumbItem)userNodeBreadcrumbItemList.get(0)).getName());
        NavigationRestTest.assertEquals((String)"SAME_TAB", (String)((UserNodeBreadcrumbItem)userNodeBreadcrumbItemList.get(0)).getTarget());
        NavigationRestTest.assertEquals((String)"user node label", (String)((UserNodeBreadcrumbItem)userNodeBreadcrumbItemList.get(0)).getLabel());
        NavigationRestTest.assertEquals((String)"/portal/siteName/homepage/usernode", (String)((UserNodeBreadcrumbItem)userNodeBreadcrumbItemList.get(0)).getUri());
        Mockito.when((Object)userNode.getTarget()).thenReturn((Object)"NEW_TAB");
        Mockito.when((Object)nodePage.getType()).thenReturn((Object)"LINK");
        Mockito.when((Object)nodePage.getLink()).thenReturn((Object)"www.test.com");
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        entity = resp.getEntity();
        NavigationRestTest.assertEquals((int)200, (int)resp.getStatus());
        NavigationRestTest.assertNotNull((Object)entity);
        resultUserNodes = (List)resp.getEntity();
        NavigationRestTest.assertEquals((int)1, (int)resultUserNodes.size());
        userNodeBreadcrumbItemList = ((UserNodeRestEntity)resultUserNodes.get(0)).getUserNodeBreadcrumbItemList();
        NavigationRestTest.assertNotNull((Object)userNodeBreadcrumbItemList);
        NavigationRestTest.assertTrue((userNodeBreadcrumbItemList.size() > 0 ? 1 : 0) != 0);
        NavigationRestTest.assertEquals((String)"NEW_TAB", (String)((UserNodeBreadcrumbItem)userNodeBreadcrumbItemList.get(0)).getTarget());
        NavigationRestTest.assertNotNull((String)"www.test.com", (Object)((UserNodeBreadcrumbItem)userNodeBreadcrumbItemList.get(0)).getUri());
    }
}

