/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.NodeTarget;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.HierarchyError;
import org.exoplatform.portal.mop.navigation.HierarchyException;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.Node;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/mop/navigation/configuration.xml")})
public class TestJDBCNavigationServiceUpdate
extends AbstractKernelTest {
    protected NavigationService service;
    private SiteStorage siteStorage;

    protected void setUp() throws Exception {
        this.begin();
        this.service = (NavigationService)this.getContainer().getComponentInstanceOfType(NavigationService.class);
        this.siteStorage = (SiteStorage)this.getContainer().getComponentInstanceOfType(SiteStorage.class);
    }

    protected void tearDown() throws Exception {
        this.end();
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, new ArrayList(), null, null, null, container, true, 5, 0L);
        this.siteStorage.create(portal);
        this.restartTransaction();
    }

    protected void createNavigation(SiteType siteType, String siteName) throws Exception {
        this.createSite(siteType, siteName);
        this.service.saveNavigation(new NavigationContext(new SiteKey(siteType, siteName), new NavigationState(Integer.valueOf(1))));
    }

    public void testNoop() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_no_op");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_no_op"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        rootContext1.add(null, "c");
        rootContext1.add(null, "d");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NodeContext root = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        Iterator<NodeChange<Node>> it = ((Node)root.getNode()).update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)it.hasNext());
    }

    public void testHasChanges() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_cannot_save");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_cannot_save"));
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)root.getContext().hasChanges());
        root.addChild("foo");
        TestJDBCNavigationServiceUpdate.assertTrue((boolean)root.getContext().hasChanges());
        try {
            root.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestJDBCNavigationServiceUpdate.assertTrue((boolean)root.getContext().hasChanges());
        this.service.saveNode(root.getContext(), null);
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)root.getContext().hasChanges());
        Iterator<NodeChange<Node>> it = root.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)it.hasNext());
    }

    public void testAddFirst() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_add_first");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_add_first"));
        NodeContext root1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        TestJDBCNavigationServiceUpdate.assertEquals((int)0, (int)root1.getNodeSize());
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        ((Node)root1.getNode()).update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        TestJDBCNavigationServiceUpdate.assertEquals((int)1, (int)root1.getNodeSize());
        Node a = (Node)root1.getNode(0);
        TestJDBCNavigationServiceUpdate.assertEquals((String)"a", (String)a.getName());
    }

    public void testAddSecond() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_add_second");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_add_second"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a = root1.getChild("a");
        TestJDBCNavigationServiceUpdate.assertEquals((int)1, (int)root1.getSize());
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("b");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = root1.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        NodeChange.Added added = (NodeChange.Added)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)root1, (Object)added.getParent());
        TestJDBCNavigationServiceUpdate.assertSame((Object)root1.getChild("b"), (Object)added.getTarget());
        TestJDBCNavigationServiceUpdate.assertSame((Object)a, (Object)added.getPrevious());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
        TestJDBCNavigationServiceUpdate.assertEquals((int)2, (int)root1.getSize());
        TestJDBCNavigationServiceUpdate.assertEquals((String)"a", (String)root1.getChild(0).getName());
        TestJDBCNavigationServiceUpdate.assertEquals((String)"b", (String)root1.getChild(1).getName());
    }

    public void testRemove() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_remove");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_remove"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NodeContext root1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        TestJDBCNavigationServiceUpdate.assertEquals((int)1, (int)root1.getNodeSize());
        Node a = (Node)root1.getNode("a");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = ((Node)root1.getNode()).update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        NodeChange.Removed removed = (NodeChange.Removed)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)root1.getNode(), (Object)removed.getParent());
        TestJDBCNavigationServiceUpdate.assertSame((Object)a, (Object)removed.getTarget());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
        TestJDBCNavigationServiceUpdate.assertEquals((int)0, (int)root1.getNodeSize());
    }

    public void testMove() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_move");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_move"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NodeContext root1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        TestJDBCNavigationServiceUpdate.assertEquals((int)2, (int)root1.getNodeSize());
        Node a = (Node)root1.getNode("a");
        Node b = a.getChild("b");
        Node c = (Node)root1.getNode("c");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.getChild("c").addChild(root2.getChild("a").getChild("b"));
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = ((Node)root1.getNode()).update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        NodeChange.Moved moved = (NodeChange.Moved)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)a, (Object)moved.getFrom());
        TestJDBCNavigationServiceUpdate.assertSame((Object)c, (Object)moved.getTo());
        TestJDBCNavigationServiceUpdate.assertSame((Object)b, (Object)moved.getTarget());
        TestJDBCNavigationServiceUpdate.assertSame(null, (Object)moved.getPrevious());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
        TestJDBCNavigationServiceUpdate.assertEquals((int)0, (int)((Node)root1.getNode("a")).getSize());
        TestJDBCNavigationServiceUpdate.assertEquals((int)1, (int)((Node)root1.getNode("c")).getSize());
    }

    public void testAddWithSameName() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_add_with_same_name");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_add_with_same_name"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.addChild("a").addChild("b");
        root1.addChild("c");
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a = root1.getChild("a");
        Node b = a.getChild("b");
        Node c = root1.getChild("c");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.getChild("c").addChild(root2.getChild("a").getChild("b"));
        Node b2 = root2.getChild("a").addChild("b");
        this.service.saveNode(root2.getContext(), null);
        TestJDBCNavigationServiceUpdate.assertSame((Object)a, (Object)root1.getChild("a"));
        TestJDBCNavigationServiceUpdate.assertSame((Object)c, (Object)root1.getChild("c"));
    }

    public void testComplex() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_complex");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_complex"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a1 = root1.addChild("a");
        a1.addChild("c");
        a1.addChild("d");
        a1.addChild("e");
        Node b1 = root1.addChild("b");
        b1.addChild("f");
        b1.addChild("g");
        b1.addChild("h");
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        a1 = root1.getChild("a");
        Node c1 = a1.getChild("c");
        Node d1 = a1.getChild("d");
        Node e1 = a1.getChild("e");
        b1 = root1.getChild("b");
        Node f1 = b1.getChild("f");
        Node g1 = b1.getChild("g");
        Node h1 = b1.getChild("h");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a2 = root2.getChild("a");
        a2.removeChild("e");
        Node b2 = root2.getChild("b");
        b2.addChild(2, a2.getChild("d"));
        a2.addChild(1, "d");
        b2.removeChild("g");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = root1.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        NodeChange.Added added = (NodeChange.Added)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)a1, (Object)added.getParent());
        TestJDBCNavigationServiceUpdate.assertEquals((String)"d", (String)((Node)added.getTarget()).getName());
        TestJDBCNavigationServiceUpdate.assertSame((Object)c1, (Object)added.getPrevious());
        NodeChange.Removed removed1 = (NodeChange.Removed)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)a1, (Object)removed1.getParent());
        TestJDBCNavigationServiceUpdate.assertSame((Object)e1, (Object)removed1.getTarget());
        NodeChange.Moved moved = (NodeChange.Moved)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)a1, (Object)moved.getFrom());
        TestJDBCNavigationServiceUpdate.assertSame((Object)b1, (Object)moved.getTo());
        TestJDBCNavigationServiceUpdate.assertSame((Object)d1, (Object)moved.getTarget());
        TestJDBCNavigationServiceUpdate.assertSame((Object)f1, (Object)moved.getPrevious());
        NodeChange.Removed removed2 = (NodeChange.Removed)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)b1, (Object)removed2.getParent());
        TestJDBCNavigationServiceUpdate.assertSame((Object)g1, (Object)removed2.getTarget());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
        TestJDBCNavigationServiceUpdate.assertSame((Object)a1, (Object)root1.getChild("a"));
        TestJDBCNavigationServiceUpdate.assertSame((Object)b1, (Object)root1.getChild("b"));
        TestJDBCNavigationServiceUpdate.assertEquals((int)2, (int)a1.getSize());
        TestJDBCNavigationServiceUpdate.assertSame((Object)c1, (Object)a1.getChild(0));
        TestJDBCNavigationServiceUpdate.assertNotNull((Object)a1.getChild(1));
        TestJDBCNavigationServiceUpdate.assertEquals((String)"d", (String)a1.getChild(1).getName());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)d1.getId().equals(a1.getChild(1).getId()));
        TestJDBCNavigationServiceUpdate.assertEquals((int)3, (int)b1.getSize());
        TestJDBCNavigationServiceUpdate.assertSame((Object)f1, (Object)b1.getChild(0));
        TestJDBCNavigationServiceUpdate.assertSame((Object)d1, (Object)b1.getChild(1));
        TestJDBCNavigationServiceUpdate.assertSame((Object)h1, (Object)b1.getChild(2));
    }

    public void testReplaceChild() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_replace_child");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_replace_child"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        String foo1Id = root1.getChild("foo").getId();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        root2.removeChild("foo");
        Node foo = root2.addChild("foo");
        foo.setState(new NodeState.Builder().label("foo2").build());
        this.service.saveNode(root2.getContext(), null);
        String foo2Id = foo.getId();
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = root1.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        NodeChange.Added added = (NodeChange.Added)changes.next();
        TestJDBCNavigationServiceUpdate.assertEquals((String)foo2Id, (String)((Node)added.getTarget()).getId());
        NodeChange.Removed removed = (NodeChange.Removed)changes.next();
        TestJDBCNavigationServiceUpdate.assertEquals((String)foo1Id, (String)((Node)removed.getTarget()).getId());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
        foo = root1.getChild("foo");
        TestJDBCNavigationServiceUpdate.assertEquals((String)foo2Id, (String)foo.getId());
        TestJDBCNavigationServiceUpdate.assertEquals((String)"foo2", (String)root1.getChild("foo").getState().getLabel());
    }

    public void testRename() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_rename");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_rename"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        root2.getChild("foo").setName("bar");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> it = root1.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        Node bar = root1.getChild(0);
        TestJDBCNavigationServiceUpdate.assertEquals((String)"bar", (String)bar.getName());
        NodeChange.Renamed renamed = (NodeChange.Renamed)it.next();
        TestJDBCNavigationServiceUpdate.assertEquals((String)"bar", (String)renamed.getName());
        TestJDBCNavigationServiceUpdate.assertSame((Object)bar, (Object)renamed.getTarget());
    }

    public void testState() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_state");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_state"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo").add(null, "bar");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node root3 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        root.getChild("foo").setState(new NodeState.Builder().label("foo").build());
        this.service.saveNode(root.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = root1.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, Scope.GRANDCHILDREN);
        Node foo = root1.getChild("foo");
        TestJDBCNavigationServiceUpdate.assertEquals((String)"foo", (String)foo.getState().getLabel());
        NodeChange.Added added = (NodeChange.Added)changes.next();
        TestJDBCNavigationServiceUpdate.assertEquals((String)"bar", (String)((Node)added.getTarget()).getName());
        NodeChange.Updated updated = (NodeChange.Updated)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)foo, (Object)updated.getTarget());
        TestJDBCNavigationServiceUpdate.assertNotSame((Object)0, (Object)updated.getState().getUpdatedDate());
        TestJDBCNavigationServiceUpdate.assertEquals((Object)new NodeState.Builder().label("foo").target(NodeTarget.SAME_TAB.name()).updatedDate(updated.getState().getUpdatedDate()).build(), (Object)updated.getState());
        TestJDBCNavigationServiceUpdate.assertEquals((String)NodeTarget.SAME_TAB.name(), (String)updated.getState().getTarget());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
        changes = root2.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        foo = root2.getChild("foo");
        TestJDBCNavigationServiceUpdate.assertEquals((String)"foo", (String)foo.getState().getLabel());
        updated = (NodeChange.Updated)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)foo, (Object)updated.getTarget());
        TestJDBCNavigationServiceUpdate.assertEquals((Object)new NodeState.Builder().label("foo").target(NodeTarget.SAME_TAB.name()).updatedDate(updated.getState().getUpdatedDate()).build(), (Object)updated.getState());
        TestJDBCNavigationServiceUpdate.assertNotSame((Object)0, (Object)updated.getState().getUpdatedDate());
        TestJDBCNavigationServiceUpdate.assertEquals((String)NodeTarget.SAME_TAB.name(), (String)updated.getState().getTarget());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
        changes = root3.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, null);
        foo = root3.getChild("foo");
        TestJDBCNavigationServiceUpdate.assertEquals((String)"foo", (String)foo.getState().getLabel());
        updated = (NodeChange.Updated)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)foo, (Object)updated.getTarget());
        TestJDBCNavigationServiceUpdate.assertEquals((Object)new NodeState.Builder().label("foo").target(NodeTarget.SAME_TAB.name()).updatedDate(updated.getState().getUpdatedDate()).build(), (Object)updated.getState());
        TestJDBCNavigationServiceUpdate.assertNotSame((Object)0, (Object)updated.getState().getUpdatedDate());
        TestJDBCNavigationServiceUpdate.assertEquals((String)NodeTarget.SAME_TAB.name(), (String)updated.getState().getTarget());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
    }

    public void testUseMostActualChildren() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_with_most_actual_children");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_with_most_actual_children"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo").add(null, "bar");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node foo = root.getChild("foo");
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("foo").removeChild("bar");
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        foo.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, Scope.CHILDREN);
        TestJDBCNavigationServiceUpdate.assertNull((Object)foo.getChild("bar"));
        foo.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, Scope.CHILDREN);
        TestJDBCNavigationServiceUpdate.assertNull((Object)foo.getChild("bar"));
    }

    public void testUpdateDeletedNode() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_deleted_node");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_deleted_node"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo").add(null, "bar");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node bar = root.getChild("foo").getChild("bar");
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("foo").removeChild("bar");
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = bar.update((org.exoplatform.portal.mop.navigation.NavigationService)this.service, Scope.CHILDREN);
        NodeChange.Removed removed = (NodeChange.Removed)changes.next();
        TestJDBCNavigationServiceUpdate.assertSame((Object)bar, (Object)removed.getTarget());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)changes.hasNext());
    }

    public void testLoadEvents() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_load_events");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_load_events"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        NodeContext foo = rootContext1.add(null, "foo");
        foo.add(null, "bar1");
        foo.add(null, "bar2");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node fooNode = root.getChild(0);
        TestJDBCNavigationServiceUpdate.assertEquals((String)"foo", (String)fooNode.getName());
        Node bar1 = fooNode.getChild(0);
        TestJDBCNavigationServiceUpdate.assertEquals((String)"bar1", (String)bar1.getName());
        Node bar2 = fooNode.getChild(1);
        TestJDBCNavigationServiceUpdate.assertEquals((String)"bar2", (String)bar2.getName());
    }

    public void testUpdateTwice2() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_twice2");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_twice2"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo").add(null, "bar");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node foo = root.getChild("foo");
        this.service.updateNode(foo.getContext(), Scope.CHILDREN, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("foo").removeChild("bar");
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        this.service.updateNode(foo.getContext(), Scope.CHILDREN, null);
        this.service.updateNode(foo.getContext(), Scope.CHILDREN, null);
    }

    public void testMove2() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_move2");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_move2"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NodeContext root = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        Node a = (Node)root.getNode("a");
        Node b = a.getChild("b");
        Node c = (Node)root.getNode("c");
        NodeContext root1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        ((Node)root1.getNode("c")).addChild(((Node)root1.getNode("a")).getChild("b"));
        this.service.saveNode(((Node)root1.getNode()).getContext(), null);
        this.restartTransaction();
        NodeChangeQueue queue = new NodeChangeQueue();
        this.service.updateNode(a.getContext(), Scope.CHILDREN, (NodeChangeListener)queue);
        Iterator changes = queue.iterator();
        TestJDBCNavigationServiceUpdate.assertTrue((boolean)changes.hasNext());
    }

    public void testScope() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_scope");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_scope"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        rootContext1.add(null, "c").add(null, "d");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node a = root1.getChild("a");
        Node c = root1.getChild("c");
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)a.getContext().isExpanded());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)c.getContext().isExpanded());
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("e");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        this.service.updateNode(a.getContext(), Scope.CHILDREN, null);
        TestJDBCNavigationServiceUpdate.assertSame((Object)a, (Object)root1.getChild("a"));
        TestJDBCNavigationServiceUpdate.assertSame((Object)c, (Object)root1.getChild("c"));
        TestJDBCNavigationServiceUpdate.assertNotNull((Object)root1.getChild("e"));
        TestJDBCNavigationServiceUpdate.assertTrue((boolean)a.getContext().isExpanded());
        TestJDBCNavigationServiceUpdate.assertFalse((boolean)c.getContext().isExpanded());
        TestJDBCNavigationServiceUpdate.assertNotNull((Object)a.getChild("b"));
    }

    public void _testPendingChange() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_pending_change");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_pending_change"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        rootContext1.add(null, "bar");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node foo = root.getChild("foo");
        Node bar = root.getChild("bar");
        this.service.updateNode(bar.getContext(), Scope.CHILDREN, null);
        bar.addChild("juu");
        this.service.updateNode(foo.getContext(), Scope.CHILDREN, null);
    }

    public void testRemovedNavigation() throws Exception {
        this.createNavigation(SiteType.PORTAL, "update_removed_navigation");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"update_removed_navigation"));
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        this.service.destroyNavigation(navigation);
        this.restartTransaction();
        try {
            this.service.updateNode(root.getContext(), null, null);
        }
        catch (HierarchyException e) {
            TestJDBCNavigationServiceUpdate.assertSame((Object)HierarchyError.UPDATE_CONCURRENTLY_REMOVED_NODE, (Object)e.getError());
        }
    }

    protected NavigationService getNavigationService() {
        PortalContainer container = PortalContainer.getInstance();
        return (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
    }
}

