/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.Node;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/mop/navigation/configuration.xml")})
public class TestJDBCNavigationServiceWrapper
extends AbstractKernelTest {
    private NavigationService navigationService;
    private SiteStorage modelStorage;
    private ListenerService listenerService;

    protected void setUp() throws Exception {
        PortalContainer container = this.getContainer();
        this.listenerService = (ListenerService)container.getComponentInstanceOfType(ListenerService.class);
        this.navigationService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.modelStorage = (SiteStorage)container.getComponentInstanceOfType(SiteStorage.class);
        super.setUp();
        this.begin();
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, new ArrayList(), null, null, null, container, true, 88, 0L);
        this.modelStorage.create(portal);
        NavigationContext nav = new NavigationContext(type.key(siteName), new NavigationState(Integer.valueOf(1)));
        this.navigationService.saveNavigation(nav);
        this.restartTransaction();
    }

    protected void createNavigation(SiteType siteType, String siteName) throws Exception {
        this.createSite(siteType, siteName);
        this.navigationService.saveNavigation(new NavigationContext(new SiteKey(siteType, siteName), new NavigationState(Integer.valueOf(1))));
        this.restartTransaction();
    }

    public void testNotification() throws Exception {
        class ListenerImpl
        extends Listener<NavigationService, SiteKey> {
            private final LinkedList<Event> events = new LinkedList();

            ListenerImpl(TestJDBCNavigationServiceWrapper this$0) {
            }

            public void onEvent(Event event) throws Exception {
                this.events.addLast(event);
            }
        }
        ListenerImpl createListener = new ListenerImpl(this);
        ListenerImpl updateListener = new ListenerImpl(this);
        ListenerImpl destroyListener = new ListenerImpl(this);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_created", (ListenerBase)createListener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_updated", (ListenerBase)updateListener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_destroyed", (ListenerBase)destroyListener);
        this.createSite(SiteType.PORTAL, "notification");
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)updateListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)destroyListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)1, (int)createListener.events.size());
        Event event = createListener.events.removeFirst();
        TestJDBCNavigationServiceWrapper.assertEquals((Object)SiteKey.portal((String)"notification"), (Object)event.getData());
        TestJDBCNavigationServiceWrapper.assertEquals((String)"org.exoplatform.portal.mop.navigation.navigation_created", (String)event.getEventName());
        this.restartTransaction();
        NavigationContext navigation = new NavigationContext(SiteKey.portal((String)"notification"), new NavigationState(Integer.valueOf(3)));
        this.navigationService.saveNavigation(navigation);
        TestJDBCNavigationServiceWrapper.assertSame((Object)this.navigationService, (Object)event.getSource());
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)createListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)1, (int)updateListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)destroyListener.events.size());
        event = updateListener.events.removeFirst();
        TestJDBCNavigationServiceWrapper.assertEquals((Object)SiteKey.portal((String)"notification"), (Object)event.getData());
        TestJDBCNavigationServiceWrapper.assertEquals((String)"org.exoplatform.portal.mop.navigation.navigation_updated", (String)event.getEventName());
        TestJDBCNavigationServiceWrapper.assertSame((Object)this.navigationService, (Object)event.getSource());
        navigation = this.navigationService.loadNavigation(SiteKey.portal((String)"notification"));
        Node root = (Node)this.navigationService.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        root.setState(new NodeState.Builder(root.getState()).label("foo").build());
        this.navigationService.saveNode(root.getContext(), null);
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)createListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)updateListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)destroyListener.events.size());
        this.navigationService.destroyNavigation(navigation);
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)createListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)0, (int)updateListener.events.size());
        TestJDBCNavigationServiceWrapper.assertEquals((int)1, (int)destroyListener.events.size());
        event = destroyListener.events.removeFirst();
        TestJDBCNavigationServiceWrapper.assertEquals((Object)SiteKey.portal((String)"notification"), (Object)event.getData());
        TestJDBCNavigationServiceWrapper.assertEquals((String)"org.exoplatform.portal.mop.navigation.navigation_destroyed", (String)event.getEventName());
        TestJDBCNavigationServiceWrapper.assertSame((Object)this.navigationService, (Object)event.getSource());
    }

    public void testCacheInvalidation() throws Exception {
        SiteKey key = SiteKey.portal((String)"wrapper_cache_invalidation");
        this.createNavigation(SiteType.PORTAL, "wrapper_cache_invalidation");
        this.restartTransaction();
        this.navigationService.saveNavigation(new NavigationContext(key, new NavigationState(Integer.valueOf(0))));
        this.restartTransaction();
        NavigationContext nav = this.navigationService.loadNavigation(key);
        TestJDBCNavigationServiceWrapper.assertNotNull((Object)nav);
        NodeContext root = this.navigationService.loadNode(Node.MODEL, nav, Scope.ALL, null);
        TestJDBCNavigationServiceWrapper.assertNotNull((Object)root);
    }

    public void testCachingInMultiThreading() throws Exception {
        final SiteKey foo = SiteKey.portal((String)"test_caching_in_multi_threading");
        TestJDBCNavigationServiceWrapper.assertNull((Object)this.navigationService.loadNavigation(foo));
        this.createSite(SiteType.PORTAL, "test_caching_in_multi_threading");
        this.navigationService.saveNavigation(new NavigationContext(foo, new NavigationState(Integer.valueOf(0))));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ExoContainerContext.setCurrentContainer((ExoContainer)TestJDBCNavigationServiceWrapper.this.getContainer());
                TestJDBCNavigationServiceWrapper.this.begin();
                try {
                    TestCase.assertNotNull((Object)TestJDBCNavigationServiceWrapper.this.navigationService.loadNavigation(foo));
                }
                finally {
                    TestJDBCNavigationServiceWrapper.this.end();
                }
            }
        });
        t.start();
        t.join();
        TestJDBCNavigationServiceWrapper.assertNotNull((Object)this.navigationService.loadNavigation(foo));
        this.restartTransaction();
        TestJDBCNavigationServiceWrapper.assertNotNull((Object)this.navigationService.loadNavigation(foo));
    }
}

