/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao.mock;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.organization.mock.InMemoryListAccess;
import org.gatein.api.common.Pagination;
import org.gatein.api.page.PageQuery;

public class InMemoryPageDAO
extends AbstractInMemoryDAO<PageEntity>
implements PageDAO {
    public PageEntity findByKey(PageKey pageKey) {
        return this.entities.values().stream().filter(page -> StringUtils.equals((CharSequence)pageKey.getName(), (CharSequence)page.getName()) && StringUtils.equals((CharSequence)pageKey.getSite().getName(), (CharSequence)page.getOwnerId()) && pageKey.getSite().getType().equals((Object)page.getOwnerType())).findFirst().orElse(null);
    }

    public InMemoryListAccess<PageKey> findByQuery(PageQuery query) {
        Pagination pagination = query.getPagination();
        Stream<PageKey> pagesStream = this.entities.values().stream().filter(page -> {
            if (StringUtils.isNotBlank((CharSequence)query.getSiteName()) && !StringUtils.equals((CharSequence)query.getSiteName(), (CharSequence)page.getOwnerId())) {
                return false;
            }
            if (query.getSiteType() != null && this.convertSiteType(query.getSiteType()) != page.getOwnerType()) {
                return false;
            }
            return query.getDisplayName() == null || page.getDisplayName() != null && StringUtils.contains((CharSequence)page.getDisplayName().toLowerCase(), (CharSequence)query.getDisplayName().toLowerCase());
        }).map(entity -> new PageKey(entity.getOwnerType(), entity.getOwnerId(), entity.getName()));
        if (pagination != null && pagination.getLimit() > 0) {
            pagesStream = pagesStream.limit((long)pagination.getOffset() + (long)pagination.getLimit());
            List<Object> result = pagesStream.toList();
            if (pagination.getOffset() > 0) {
                result = result.size() > pagination.getOffset() ? result.subList(pagination.getOffset(), result.size()) : Collections.emptyList();
            }
            return new InMemoryListAccess(result, (Object[])new PageKey[0]);
        }
        List<PageKey> result = pagesStream.toList();
        return new InMemoryListAccess(result, (Object[])new PageKey[result.size()]);
    }

    public void deleteByOwner(long ownerId) {
        List<PageEntity> ownerPages = this.entities.values().stream().filter(page -> ownerId == page.getOwner().getId()).toList();
        this.deleteAll(ownerPages);
    }

    private SiteType convertSiteType(org.gatein.api.site.SiteType siteType) {
        switch (siteType) {
            case SITE: {
                return SiteType.PORTAL;
            }
            case SPACE: {
                return SiteType.GROUP;
            }
        }
        return SiteType.USER;
    }
}

