/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.AbstractSiteDataImportTest;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.storage.PageStorage;

public class TestSiteDataImportMerge
extends AbstractSiteDataImportTest {
    @Override
    protected ImportMode getMode() {
        return ImportMode.MERGE;
    }

    @Override
    protected void afterSecondBootWithOverride(PortalContainer container) throws Exception {
        this.restartTransaction();
        LayoutService layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        PageStorage pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        PortalConfig portal = layoutService.getPortalConfig("classic");
        TestSiteDataImportMerge.assertNotNull((Object)portal);
        Container layout = portal.getPortalLayout();
        TestSiteDataImportMerge.assertEquals((int)1, (int)layout.getChildren().size());
        Application layoutPortlet = (Application)layout.getChildren().get(0);
        TestSiteDataImportMerge.assertEquals((String)"site2/layout", (String)layoutService.getId(layoutPortlet.getState()));
        PageContext page1 = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page1"));
        TestSiteDataImportMerge.assertNotNull((Object)page1);
        TestSiteDataImportMerge.assertEquals((String)"site 2", (String)page1.getState().getDisplayName());
        PageContext page2 = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page2"));
        TestSiteDataImportMerge.assertNotNull((Object)page2);
        TestSiteDataImportMerge.assertEquals((String)"site 2", (String)page2.getState().getDisplayName());
        PageContext home = pageStorage.loadPage(PageKey.parse((String)"portal::classic::home"));
        TestSiteDataImportMerge.assertNotNull((Object)home);
        TestSiteDataImportMerge.assertEquals((String)"site 1", (String)home.getState().getDisplayName());
    }
}

