/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.HierarchyError;
import org.exoplatform.portal.mop.navigation.HierarchyException;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationError;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.Node;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/mop/navigation/configuration.xml")})
public class TestNavigationServiceSave
extends AbstractKernelTest {
    protected NavigationService service;
    private SiteStorage modelStorage;

    protected void setUp() throws Exception {
        super.setUp();
        PortalContainer container = PortalContainer.getInstance();
        this.service = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.modelStorage = (SiteStorage)container.getComponentInstanceOfType(SiteStorage.class);
        this.begin();
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", null, null, Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, new ArrayList(), null, null, null, container, true, 4, 0L);
        this.modelStorage.create(portal);
        this.restartTransaction();
    }

    protected void createNavigation(SiteType siteType, String siteName) throws Exception {
        this.createSite(siteType, siteName);
        this.service.saveNavigation(new NavigationContext(new SiteKey(siteType, siteName), new NavigationState(Integer.valueOf(1))));
    }

    public void testNonExistingSite() throws Exception {
        TestNavigationServiceSave.assertNull((Object)this.service.loadNavigation(SiteKey.portal((String)"non_existing")));
    }

    public void testSaveNavigation() throws Exception {
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"save_navigation"));
        TestNavigationServiceSave.assertNull((Object)nav);
        this.createSite(SiteType.PORTAL, "save_navigation");
        this.restartTransaction();
        nav = this.service.loadNavigation(SiteKey.portal((String)"save_navigation"));
        TestNavigationServiceSave.assertNull((Object)nav);
        nav = new NavigationContext(SiteKey.portal((String)"save_navigation"), new NavigationState(Integer.valueOf(5)));
        TestNavigationServiceSave.assertNull((Object)nav.getData());
        TestNavigationServiceSave.assertNotNull((Object)nav.getState());
        this.service.saveNavigation(nav);
        TestNavigationServiceSave.assertNotNull((Object)nav.getData());
        nav.setState(new NavigationState(Integer.valueOf(5)));
        this.service.saveNavigation(nav);
        nav = this.service.loadNavigation(SiteKey.portal((String)"save_navigation"));
        TestNavigationServiceSave.assertNotNull((Object)nav.getData().getState());
        TestNavigationServiceSave.assertEquals((int)5, (int)nav.getData().getState().getPriority());
        this.restartTransaction();
        nav = this.service.loadNavigation(SiteKey.portal((String)"save_navigation"));
        TestNavigationServiceSave.assertNotNull((Object)nav);
        TestNavigationServiceSave.assertEquals((Object)SiteKey.portal((String)"save_navigation"), (Object)nav.getKey());
        NavigationState state = nav.getData().getState();
        Integer p = state.getPriority();
        TestNavigationServiceSave.assertEquals((int)5, (int)p);
    }

    public void testDestroyNavigation() throws Exception {
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"destroy_navigation"));
        TestNavigationServiceSave.assertNull((Object)nav);
        this.createNavigation(SiteType.PORTAL, "destroy_navigation");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"destroy_navigation"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        nav = this.service.loadNavigation(SiteKey.portal((String)"destroy_navigation"));
        TestNavigationServiceSave.assertNotNull((Object)nav);
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        TestNavigationServiceSave.assertTrue((boolean)this.service.destroyNavigation(nav));
        TestNavigationServiceSave.assertNull((Object)nav.getState());
        TestNavigationServiceSave.assertNull((Object)nav.getData());
        try {
            this.service.destroyNavigation(nav);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nav = this.service.loadNavigation(SiteKey.portal((String)"destroy_navigation"));
        TestNavigationServiceSave.assertNull((Object)nav);
        this.restartTransaction();
        nav = this.service.loadNavigation(SiteKey.portal((String)"destroy_navigation"));
        TestNavigationServiceSave.assertNull((Object)nav);
    }

    public void testAddChild() throws Exception {
        this.createNavigation(SiteType.PORTAL, "add_child");
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"add_child"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        TestNavigationServiceSave.assertEquals((int)0, (int)root1.getNodeCount());
        try {
            root1.addChild((String)null);
            TestNavigationServiceSave.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            root1.addChild(-1, "foo");
            TestNavigationServiceSave.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            root1.addChild(1, "foo");
            TestNavigationServiceSave.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Node foo = root1.addChild("foo");
        TestNavigationServiceSave.assertNull((Object)foo.getId());
        TestNavigationServiceSave.assertEquals((String)"foo", (String)foo.getName());
        TestNavigationServiceSave.assertSame((Object)foo, (Object)root1.getChild("foo"));
        TestNavigationServiceSave.assertEquals((int)1, (int)root1.getNodeCount());
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node foo2 = root2.getChild("foo");
        TestNavigationServiceSave.assertNotNull((Object)foo2);
        TestNavigationServiceSave.assertEquals((int)1, (int)root2.getNodeCount());
        TestNavigationServiceSave.assertEquals((String)"foo", (String)foo2.getName());
        root1.assertEquals(root2);
    }

    public void testRemoveChild() throws Exception {
        this.createNavigation(SiteType.PORTAL, "remove_child");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"remove_child"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"remove_child"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        try {
            root1.removeChild(null);
            TestNavigationServiceSave.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            root1.removeChild("bar");
            TestNavigationServiceSave.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Node foo1 = root1.getChild("foo");
        TestNavigationServiceSave.assertNotNull((Object)foo1.getId());
        TestNavigationServiceSave.assertEquals((String)"foo", (String)foo1.getName());
        TestNavigationServiceSave.assertSame((Object)foo1, (Object)root1.getChild("foo"));
        TestNavigationServiceSave.assertTrue((boolean)root1.removeChild("foo"));
        TestNavigationServiceSave.assertNull((Object)root1.getChild("foo"));
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node foo2 = root2.getChild("foo");
        TestNavigationServiceSave.assertNull((Object)foo2);
        root1.assertEquals(root2);
    }

    public void testRemoveTransientChild() throws Exception {
        this.createNavigation(SiteType.PORTAL, "remove_transient_child");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"remove_transient_child"));
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"remove_transient_child"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node foo1 = root1.addChild("foo");
        TestNavigationServiceSave.assertNull((Object)foo1.getId());
        TestNavigationServiceSave.assertEquals((String)"foo", (String)foo1.getName());
        TestNavigationServiceSave.assertSame((Object)foo1, (Object)root1.getChild("foo"));
        TestNavigationServiceSave.assertTrue((boolean)root1.removeChild("foo"));
        TestNavigationServiceSave.assertNull((Object)root1.getChild("foo"));
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node foo2 = root2.getChild("foo");
        TestNavigationServiceSave.assertNull((Object)foo2);
        root1.assertEquals(root2);
    }

    public void testRename() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rename");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rename"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"rename"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.GRANDCHILDREN, null).getNode();
        try {
            root1.setName("something");
            TestNavigationServiceSave.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Node a1 = root1.getChild("a");
        TestNavigationServiceSave.assertEquals((int)0, (int)a1.getContext().getIndex());
        try {
            a1.setName(null);
            TestNavigationServiceSave.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            a1.setName("b");
            TestNavigationServiceSave.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        a1.setName("c");
        TestNavigationServiceSave.assertEquals((String)"c", (String)a1.getName());
        TestNavigationServiceSave.assertEquals((int)0, (int)a1.getContext().getIndex());
        this.service.saveNode(a1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        nav = this.service.loadNavigation(SiteKey.portal((String)"rename"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node a2 = root2.getChild("c");
        TestNavigationServiceSave.assertNotNull((Object)a2);
    }

    public void testReorderChild() throws Exception {
        this.createNavigation(SiteType.PORTAL, "reorder_child");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"reorder_child"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        rootContext1.add(null, "bar");
        rootContext1.add(null, "juu");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"reorder_child"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Iterator<Node> i = root1.getChildren().iterator();
        Node foo1 = i.next();
        TestNavigationServiceSave.assertEquals((String)"foo", (String)foo1.getName());
        Node bar1 = i.next();
        TestNavigationServiceSave.assertEquals((String)"bar", (String)bar1.getName());
        Node juu1 = i.next();
        TestNavigationServiceSave.assertEquals((String)"juu", (String)juu1.getName());
        TestNavigationServiceSave.assertFalse((boolean)i.hasNext());
        try {
            root1.addChild(1, (Node)null);
            TestNavigationServiceSave.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            root1.addChild(-1, juu1);
            TestNavigationServiceSave.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            root1.addChild(4, juu1);
            TestNavigationServiceSave.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        root1.addChild(1, juu1);
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        root1.assertConsistent();
    }

    public void testMoveChild() throws Exception {
        this.createNavigation(SiteType.PORTAL, "move_child");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"move_child"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo").add(null, "juu");
        rootContext1.add(null, "bar");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"move_child"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node foo1 = root1.getChild("foo");
        Node bar1 = root1.getChild("bar");
        Node juu1 = foo1.getChild("juu");
        bar1.addChild(juu1);
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node foo2 = root2.getChild("foo");
        Node juu2 = foo2.getChild("juu");
        TestNavigationServiceSave.assertNull((Object)juu2);
        Node bar2 = root2.getChild("bar");
        juu2 = bar2.getChild("juu");
        TestNavigationServiceSave.assertNotNull((Object)juu2);
        root1.assertEquals(root2);
    }

    public void testMoveAfter1() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_move_after_1");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_move_after_1"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"save_move_after_1"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node a = root.getChild("a");
        Node b = root.getChild("b");
        Node c = root.getChild("c");
        root.addChild(0, a);
        TestNavigationServiceSave.assertSame((Object)a, (Object)root.getChild(0));
        TestNavigationServiceSave.assertSame((Object)b, (Object)root.getChild(1));
        TestNavigationServiceSave.assertSame((Object)c, (Object)root.getChild(2));
        this.service.saveNode(root.getContext(), null);
        TestNavigationServiceSave.assertSame((Object)a, (Object)root.getChild(0));
        TestNavigationServiceSave.assertSame((Object)b, (Object)root.getChild(1));
        TestNavigationServiceSave.assertSame((Object)c, (Object)root.getChild(2));
        this.restartTransaction();
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        c = root.getChild("c");
        TestNavigationServiceSave.assertSame((Object)a, (Object)root.getChild(0));
        TestNavigationServiceSave.assertSame((Object)b, (Object)root.getChild(1));
        TestNavigationServiceSave.assertSame((Object)c, (Object)root.getChild(2));
    }

    public void testMoveAfter2() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_move_after_2");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_move_after_2"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"save_move_after_2"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node a = root.getChild("a");
        Node b = root.getChild("b");
        Node c = root.getChild("c");
        root.addChild(2, a);
        TestNavigationServiceSave.assertSame((Object)b, (Object)root.getChild(0));
        TestNavigationServiceSave.assertSame((Object)a, (Object)root.getChild(1));
        TestNavigationServiceSave.assertSame((Object)c, (Object)root.getChild(2));
        this.service.saveNode(root.getContext(), null);
        TestNavigationServiceSave.assertSame((Object)b, (Object)root.getChild(0));
        TestNavigationServiceSave.assertSame((Object)a, (Object)root.getChild(1));
        TestNavigationServiceSave.assertSame((Object)c, (Object)root.getChild(2));
        this.restartTransaction();
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        c = root.getChild("c");
        TestNavigationServiceSave.assertSame((Object)b, (Object)root.getChild(0));
        TestNavigationServiceSave.assertSame((Object)a, (Object)root.getChild(1));
        TestNavigationServiceSave.assertSame((Object)c, (Object)root.getChild(2));
    }

    public void testRenameNode() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rename_node");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rename_node"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"rename_node"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node foo1 = root1.getChild("foo");
        foo1.setName("foo");
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        nav = this.service.loadNavigation(SiteKey.portal((String)"rename_node"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        root1.assertEquals(root2);
        Node foo2 = root2.getChild("foo");
        foo2.setName("bar");
        TestNavigationServiceSave.assertEquals((String)"bar", (String)foo2.getName());
        TestNavigationServiceSave.assertSame((Object)foo2, (Object)root2.getChild("bar"));
        this.service.saveNode(root2.getContext(), null);
        TestNavigationServiceSave.assertEquals((String)"bar", (String)foo2.getName());
        TestNavigationServiceSave.assertSame((Object)foo2, (Object)root2.getChild("bar"));
        root2.assertConsistent();
        this.restartTransaction();
        Node root3 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node bar3 = root3.getChild("bar");
        TestNavigationServiceSave.assertNotNull((Object)bar3);
        TestNavigationServiceSave.assertSame((Object)bar3, (Object)root3.getChild("bar"));
        root2.assertEquals(root3);
        root3.addChild("foo");
        try {
            bar3.setName("foo");
            TestNavigationServiceSave.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSaveChildren() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_children");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_children"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "1");
        rootContext1.add(null, "2");
        rootContext1.add(null, "3");
        rootContext1.add(null, "4");
        rootContext1.add(null, "5");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"save_children"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        root1.removeChild("5");
        root1.removeChild("2");
        root1.addChild(0, root1.getChild("3"));
        root1.addChild(1, root1.addChild("."));
        this.service.saveNode(root1.getContext(), null);
        Iterator<Node> i = root1.getChildren().iterator();
        TestNavigationServiceSave.assertEquals((String)"3", (String)i.next().getName());
        TestNavigationServiceSave.assertEquals((String)".", (String)i.next().getName());
        TestNavigationServiceSave.assertEquals((String)"1", (String)i.next().getName());
        TestNavigationServiceSave.assertEquals((String)"4", (String)i.next().getName());
        TestNavigationServiceSave.assertFalse((boolean)i.hasNext());
    }

    public void testSaveRecursive() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_recursive");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_recursive"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"save_recursive"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node foo1 = root1.getChild("foo");
        Node bar1 = foo1.addChild("bar");
        bar1.addChild("juu");
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node foo2 = root2.getChild("foo");
        Node bar2 = foo2.getChild("bar");
        TestNavigationServiceSave.assertNotNull((Object)bar2.getId());
        Node juu2 = bar2.getChild("juu");
        TestNavigationServiceSave.assertNotNull((Object)juu2.getId());
        root1.assertEquals(root2);
    }

    public void testSaveState() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_state");
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"save_state"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.SINGLE, null).getNode();
        NodeState state = root1.getState();
        TestNavigationServiceSave.assertNull((Object)state.getLabel());
        TestNavigationServiceSave.assertEquals((long)0L, (long)state.getStartPublicationTime());
        TestNavigationServiceSave.assertEquals((long)0L, (long)state.getEndPublicationTime());
        long now = System.currentTimeMillis();
        root1.setState(new NodeState.Builder().endPublicationTime(now).label("bar").build());
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        state = root2.getState();
        TestNavigationServiceSave.assertEquals((String)"bar", (String)state.getLabel());
        TestNavigationServiceSave.assertEquals((long)-1L, (long)state.getStartPublicationTime());
        TestNavigationServiceSave.assertEquals((long)now, (long)state.getEndPublicationTime());
        TestNavigationServiceSave.assertEquals((Object)Visibility.DISPLAYED, (Object)state.getVisibility());
        root1.assertEquals(root2);
    }

    public void testRecreateNode() throws Exception {
        this.createNavigation(SiteType.PORTAL, "recreate_node");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"recreate_node"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "foo");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"recreate_node"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        String fooId = root1.getChild("foo").getId();
        TestNavigationServiceSave.assertTrue((boolean)root1.removeChild("foo"));
        TestNavigationServiceSave.assertNull((Object)root1.addChild("foo").getId());
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        TestNavigationServiceSave.assertNotNull((Object)root2.getChild("foo").getId());
        TestNavigationServiceSave.assertNotSame((Object)fooId, (Object)root2.getChild("foo").getId());
        root1.assertEquals(root2);
    }

    public void testMoveToAdded() throws Exception {
        this.createNavigation(SiteType.PORTAL, "move_to_added");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"move_to_added"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        Node a1 = root1.getChild("a");
        Node b1 = a1.getChild("b");
        Node c1 = root1.addChild("c");
        c1.addChild(b1);
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        navigation = this.service.loadNavigation(SiteKey.portal((String)"move_to_added"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        Node a2 = root2.getChild("a");
        TestNavigationServiceSave.assertNotNull((Object)a2);
        Node c2 = root2.getChild("c");
        TestNavigationServiceSave.assertNotNull((Object)c2);
        Node b2 = c2.getChild("b");
        TestNavigationServiceSave.assertNotNull((Object)b2);
        root1.assertEquals(root2);
    }

    public void testMoveFromRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "moved_from_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"moved_from_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "c");
        rootContext1.add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        Node a1 = root1.getChild("a");
        Node b1 = root1.getChild("b");
        Node c1 = a1.getChild("c");
        b1.addChild(c1);
        root1.removeChild("a");
        this.service.saveNode(root1.getContext(), null);
        root1.assertConsistent();
        this.restartTransaction();
        navigation = this.service.loadNavigation(SiteKey.portal((String)"moved_from_removed"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        TestNavigationServiceSave.assertNull((Object)root2.getChild("a"));
        Node b2 = root2.getChild("b");
        TestNavigationServiceSave.assertNotNull((Object)b2);
        Node c2 = b2.getChild("c");
        TestNavigationServiceSave.assertNotNull((Object)c2);
        root1.assertEquals(root2);
    }

    public void testRemoveAdded() throws Exception {
        this.createNavigation(SiteType.PORTAL, "remove_added");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"remove_added"));
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        root.addChild("foo");
        root.removeChild("foo");
        this.service.saveNode(root.getContext(), null);
        root.assertConsistent();
        this.restartTransaction();
        root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        TestNavigationServiceSave.assertEquals((int)0, (int)root.getChildren().size());
    }

    public void testTransitiveRemoveTransient() throws Exception {
        this.createNavigation(SiteType.PORTAL, "transitive_remove_transient");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"transitive_remove_transient"));
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        root.addChild("foo").addChild("bar");
        root.removeChild("foo");
        this.service.saveNode(root.getContext(), null);
        root.assertConsistent();
        this.restartTransaction();
        root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.GRANDCHILDREN, null).getNode();
        TestNavigationServiceSave.assertEquals((int)0, (int)root.getChildren().size());
    }

    public void testRenameCreatedNode() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_rename_created");
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"save_rename_created"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.ALL, null).getNode();
        Node temp = root.addChild("temp");
        temp.setName("bar");
        Iterator<NodeChange<Node>> changes = root.save(this.service);
        TestNavigationServiceSave.assertTrue((boolean)changes.hasNext());
        NodeChange.Created created = (NodeChange.Created)changes.next();
        Node n = (Node)created.getTarget();
        TestNavigationServiceSave.assertEquals((String)"bar", (String)n.getName());
        TestNavigationServiceSave.assertSame((Object)"bar", (Object)root.getChild(0).getName());
    }

    public void testConcurrentAddToRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "add_to_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"add_to_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root.getChild("a").addChild("b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.ADD_CONCURRENTLY_REMOVED_PARENT_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentMerge() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_merge");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_merge"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        root2.addChild(1, root2.addChild("2"));
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        this.service.saveNode(root1.getContext(), null);
        root1.addChild(1, root1.addChild("1"));
        this.service.saveNode(root1.getContext(), null);
    }

    public void testConcurrentRemoveRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "remove_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"remove_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.removeChild("a");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        this.service.saveNode(root1.getContext(), null);
        root1.assertEquals(root2);
    }

    public void testConcurrentMoveRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "move_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"move_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.addChild(root1.getChild("a").getChild("b"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.getChild("a").removeChild("b");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.MOVE_CONCURRENTLY_REMOVED_MOVED_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentMoveToRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "move_to_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"move_to_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("b").addChild(root1.getChild("a"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("b");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.MOVE_CONCURRENTLY_REMOVED_DST_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentMoveMoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "move_moved");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"move_moved"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("b").addChild(root1.getChild("a"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.getChild("c").addChild(root2.getChild("a"));
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.MOVE_CONCURRENTLY_CHANGED_SRC_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentAddDuplicate() throws Exception {
        this.createNavigation(SiteType.PORTAL, "concurrent_add_duplicate");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"concurrent_add_duplicate"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        root1.addChild("a");
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.ADD_CONCURRENTLY_ADDED_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentAddAfterRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "concurrent_add_after_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"concurrent_add_after_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.addChild(1, "b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.ADD_CONCURRENTLY_REMOVED_PREVIOUS_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentMoveAfterRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "concurrent_move_after_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"concurrent_move_after_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.addChild(2, root1.getChild("a").getChild("b"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("c");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.MOVE_CONCURRENTLY_REMOVED_PREVIOUS_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentMoveFromRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "concurrent_move_from_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"concurrent_move_from_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        rootContext1.add(null, "c");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("c").addChild(root1.getChild("a").getChild("b"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.MOVE_CONCURRENTLY_REMOVED_SRC_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentRenameRemoved() throws Exception {
        this.createNavigation(SiteType.PORTAL, "concurrent_rename_removed");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"concurrent_rename_removed"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("a").setName("b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.RENAME_CONCURRENTLY_REMOVED_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentDuplicateRename() throws Exception {
        this.createNavigation(SiteType.PORTAL, "concurrent_duplicate_rename");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"concurrent_duplicate_rename"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("a").setName("b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("b");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.RENAME_CONCURRENTLY_DUPLICATE_NAME, (Object)e.getError());
        }
    }

    public void testSavePhantomNode() throws Exception {
        this.createNavigation(SiteType.PORTAL, "concurrent_save");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"concurrent_save"));
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.addChild("a");
        this.service.saveNode(root1.getContext(), null);
        this.restartTransaction();
        root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("a").setState(root1.getState().builder().label("foo").build());
        this.restartTransaction();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertEquals((Object)NavigationError.UPDATE_CONCURRENTLY_REMOVED_NODE, (Object)e.getError());
        }
    }

    public void testConcurrentRemovalDoesNotPreventSave() throws Exception {
        this.createNavigation(SiteType.PORTAL, "removal_does_not_prevent_save");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"removal_does_not_prevent_save"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        this.service.saveNode(root1.getContext(), null);
    }

    public void testConcurrentRename() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_concurrent_rename");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_concurrent_rename"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a = root1.getChild("a");
        a.setName("b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a2 = root2.getChild("a");
        a2.setName("c");
        this.service.saveNode(root2.getContext(), null);
        Iterator<NodeChange<Node>> changes = root1.save(this.service);
        TestNavigationServiceSave.assertTrue((boolean)changes.hasNext());
        NodeChange.Renamed renamed = (NodeChange.Renamed)changes.next();
        Node n = (Node)renamed.getTarget();
        TestNavigationServiceSave.assertEquals((String)"b", (String)n.getName());
    }

    public void testRemovedNavigation() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_removed_navigation");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_removed_navigation"));
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        this.service.destroyNavigation(navigation);
        this.restartTransaction();
        try {
            this.service.saveNode(root.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (HierarchyException e) {
            TestNavigationServiceSave.assertSame((Object)HierarchyError.UPDATE_CONCURRENTLY_REMOVED_NODE, (Object)e.getError());
        }
    }

    public void testPendingChangesBypassCache() throws Exception {
        this.createNavigation(SiteType.PORTAL, "pending_changes_bypass_cache");
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"pending_changes_bypass_cache"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        root.addChild("foo");
        this.service.saveNode(root.getContext(), null);
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        TestNavigationServiceSave.assertNotNull((Object)root.getChild("foo"));
    }

    public void testAtomic() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_atomic");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_atomic"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root1.getChild("a").addChild("c");
        root1.getChild("b").addChild("d");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("b");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.saveNode(root1.getContext(), null);
            TestNavigationServiceSave.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceSave.assertSame((Object)NavigationError.ADD_CONCURRENTLY_REMOVED_PARENT_NODE, (Object)e.getError());
        }
    }

    public void testSaveRebase() throws Exception {
        this.createNavigation(SiteType.PORTAL, "save_rebase");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"save_rebase"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a = root1.getChild("a");
        Node b = root1.addChild("b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node c = root2.addChild("c");
        this.service.saveNode(root2.getContext(), null);
        Iterator<NodeChange<Node>> changes = root1.save(this.service);
        NodeChange.Created added = (NodeChange.Created)changes.next();
        Node n = (Node)added.getTarget();
        TestNavigationServiceSave.assertEquals((String)"b", (String)n.getName());
        TestNavigationServiceSave.assertFalse((boolean)changes.hasNext());
        TestNavigationServiceSave.assertSame((Object)a.getName(), (Object)root1.getChild(0).getName());
        TestNavigationServiceSave.assertSame((Object)b.getName(), (Object)root1.getChild(1).getName());
        TestNavigationServiceSave.assertSame((Object)c.getName(), (Object)root1.getChild(2).getName());
    }

    protected NavigationService getNavigationService() {
        PortalContainer container = PortalContainer.getInstance();
        return (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
    }
}

