/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import jakarta.persistence.EntityTransaction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.portal.jdbc.entity.NavigationEntity;
import org.exoplatform.portal.jdbc.entity.NodeEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.NodeTarget;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.dao.AbstractDAOTest;
import org.exoplatform.portal.mop.dao.NavigationDAO;
import org.exoplatform.portal.mop.dao.NodeDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;

public class NavigationDAOTest
extends AbstractDAOTest {
    private SiteDAO siteDAO;
    private NavigationDAO navigationDAO;
    private NodeDAO nodeDAO;
    private EntityTransaction transaction;

    @Override
    protected void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.navigationDAO = (NavigationDAO)this.getContainer().getComponentInstanceOfType(NavigationDAO.class);
        this.nodeDAO = (NodeDAO)this.getContainer().getComponentInstanceOfType(NodeDAO.class);
        this.siteDAO = (SiteDAO)this.getContainer().getComponentInstanceOfType(SiteDAO.class);
        EntityManagerService managerService = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        this.transaction = managerService.getEntityManager().getTransaction();
        this.transaction.begin();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.transaction.isActive()) {
            this.transaction.rollback();
        }
        super.tearDown();
        this.end();
    }

    public void testCreateNav() {
        NavigationEntity nav = this.createNav("classic");
        this.navigationDAO.create((Object)nav);
        NavigationEntity expected = (NavigationEntity)this.navigationDAO.find((Serializable)nav.getId());
        NavigationDAOTest.assertNotNull((Object)expected);
        this.assertNav(expected, nav);
    }

    public void testCreateNode() {
        NodeEntity node1 = this.createNode("node1");
        NodeEntity node2 = this.createNode("node2");
        node2.setParent(node1);
        NodeEntity node3 = this.createNode("node3");
        node3.setParent(node1);
        node1.setChildren(Arrays.asList(node3, node2));
        this.nodeDAO.create((Object)node1);
        NodeEntity expected = (NodeEntity)this.nodeDAO.find((Serializable)node1.getId());
        NavigationDAOTest.assertNotNull((Object)expected);
        this.assertNode(expected, node1);
        List children = expected.getChildren();
        NavigationDAOTest.assertEquals((int)2, (int)children.size());
        this.assertNode((NodeEntity)children.get(0), node3);
        this.assertNode((NodeEntity)children.get(1), node2);
    }

    public void testUpdateNav() {
        NodeEntity node1 = this.createNode("node1");
        this.nodeDAO.create((Object)node1);
        NavigationEntity nav = this.createNav("classic");
        nav.setRootNode(node1);
        this.navigationDAO.create((Object)nav);
        NavigationEntity expected = (NavigationEntity)this.navigationDAO.find((Serializable)nav.getId());
        NavigationDAOTest.assertNotNull((Object)expected);
        this.assertNav(expected, nav);
        nav.setPriority(2);
        this.navigationDAO.update((Object)nav);
        expected = (NavigationEntity)this.navigationDAO.find((Serializable)nav.getId());
        this.assertNav(expected, nav);
    }

    private NavigationEntity createNav(String ownerId) {
        NavigationEntity nav = new NavigationEntity();
        nav.setOwner(this.getOrCreateSite("classic"));
        nav.setPriority(1);
        return nav;
    }

    private SiteEntity getOrCreateSite(String name) {
        SiteEntity siteEntity = this.siteDAO.findByKey(SiteType.PORTAL.key(name));
        if (siteEntity == null) {
            siteEntity = new SiteEntity();
            siteEntity.setSiteType(SiteType.PORTAL);
            siteEntity.setName(name);
            this.siteDAO.create((Object)siteEntity);
        }
        return siteEntity;
    }

    private void assertNode(NodeEntity expected, NodeEntity node) {
        NavigationDAOTest.assertEquals((long)expected.getEndTime(), (long)node.getEndTime());
        NavigationDAOTest.assertEquals((String)expected.getIcon(), (String)node.getIcon());
        NavigationDAOTest.assertEquals((int)expected.getIndex(), (int)node.getIndex());
        NavigationDAOTest.assertEquals((String)expected.getLabel(), (String)node.getLabel());
        NavigationDAOTest.assertEquals((String)expected.getName(), (String)node.getName());
        NavigationDAOTest.assertEquals((long)expected.getStartTime(), (long)node.getStartTime());
        NavigationDAOTest.assertEquals((Object)expected.getId(), (Object)node.getId());
        NavigationDAOTest.assertEquals((Object)expected.getVisibility(), (Object)node.getVisibility());
        NavigationDAOTest.assertEquals((Object)expected.getTarget(), (Object)node.getTarget());
    }

    private NodeEntity createNode(String name) {
        NodeEntity node = new NodeEntity();
        node.setName(name);
        node.setEndTime(1L);
        node.setIcon("icon");
        node.setIndex(1);
        node.setLabel("label");
        node.setStartTime(2L);
        node.setVisibility(Visibility.SYSTEM);
        node.setTarget(NodeTarget.SAME_TAB);
        return node;
    }

    private void assertNav(NavigationEntity expected, NavigationEntity nav) {
        NavigationDAOTest.assertEquals((String)expected.getOwnerId(), (String)nav.getOwnerId());
        NavigationDAOTest.assertEquals((int)expected.getPriority(), (int)nav.getPriority());
        NavigationDAOTest.assertEquals((Object)expected.getId(), (Object)nav.getId());
        NavigationDAOTest.assertEquals((Object)expected.getOwnerType(), (Object)nav.getOwnerType());
    }
}

