/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.rest.model.UserNodeBreadcrumbItem;
import org.exoplatform.portal.mop.rest.model.UserNodeRestEntity;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;

public class EntityBuilder {
    private EntityBuilder() {
    }

    public static List<UserNodeRestEntity> toUserNodeRestEntity(Collection<UserNode> nodes, boolean expand, OrganizationService organizationService, LayoutService layoutService, UserACL userACL, UserPortal userPortal, boolean expandBreadcrumb) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<UserNodeRestEntity> result = new ArrayList<UserNodeRestEntity>();
        for (UserNode userNode : nodes) {
            if (userNode == null) continue;
            UserNodeRestEntity resultNode = new UserNodeRestEntity(userNode);
            if (expand && userNode.getPageRef() != null) {
                Page userNodePage = layoutService.getPage(userNode.getPageRef());
                resultNode.setPageAccessPermissions(userNodePage.getAccessPermissions());
                if (!StringUtils.isBlank((CharSequence)userNodePage.getEditPermission())) {
                    resultNode.setCanEditPage(userACL.hasEditPermission(userNodePage, ConversationState.getCurrent().getIdentity()));
                    resultNode.setPageEditPermission(userNodePage.getEditPermission());
                }
                if (PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType()))) {
                    resultNode.setPageLink(userNodePage.getLink());
                }
            }
            if (expandBreadcrumb) {
                List<UserNodeBreadcrumbItem> userNodeBreadcrumbItemList = EntityBuilder.getUserNodeBreadcrumbList(userPortal, layoutService, userNode);
                Collections.reverse(userNodeBreadcrumbItemList);
                resultNode.setUserNodeBreadcrumbItemList(userNodeBreadcrumbItemList);
            }
            resultNode.setChildren(EntityBuilder.toUserNodeRestEntity(userNode.getChildren(), expand, organizationService, layoutService, userACL, userPortal, expandBreadcrumb));
            result.add(resultNode);
        }
        return result;
    }

    private static List<UserNodeBreadcrumbItem> getUserNodeBreadcrumbList(UserPortal userPortal, LayoutService layoutService, UserNode userNode) {
        UserNavigation userNodeNavigation = userNode.getNavigation();
        UserNode rootNavigationNode = userPortal.getNode(userNodeNavigation, Scope.ALL, UserNodeFilterConfig.builder().build(), null);
        ArrayList<UserNodeBreadcrumbItem> userNodeBreadcrumbItemList = new ArrayList<UserNodeBreadcrumbItem>();
        String portalName = PortalContainer.getCurrentPortalContainerName();
        for (userNode = EntityBuilder.findTargetNode(userNode.getId(), rootNavigationNode); userNode != null && !userNode.getName().equals("default"); userNode = userNode.getParent()) {
            userNodeBreadcrumbItemList.add(EntityBuilder.computeUserNodeBreadcrumbItem(layoutService, userNode, portalName, userNodeNavigation.getKey().getName()));
        }
        return userNodeBreadcrumbItemList;
    }

    private static UserNodeBreadcrumbItem computeUserNodeBreadcrumbItem(LayoutService layoutService, UserNode node, String portalName, String siteName) {
        String nodeUri = null;
        if (node.getPageRef() != null) {
            Page userNodePage = layoutService.getPage(node.getPageRef());
            if (PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType()))) {
                nodeUri = userNodePage.getLink();
            } else {
                if (((String)siteName).contains("/spaces/")) {
                    siteName = "g/" + ((String)siteName).replace("/", ":");
                }
                nodeUri = "/" + portalName + "/" + (String)siteName + "/" + node.getURI();
            }
        }
        return new UserNodeBreadcrumbItem(node.getId(), node.getName(), node.getResolvedLabel(), nodeUri, node.getTarget());
    }

    private static UserNode findTargetNode(String nodeId, UserNode rootNode) {
        for (UserNode userNode : rootNode.getChildren()) {
            if (userNode.getId().equals(nodeId)) {
                return userNode;
            }
            UserNode targetUserNode = EntityBuilder.findTargetNode(nodeId, userNode);
            if (targetUserNode == null) continue;
            return targetUserNode;
        }
        return null;
    }
}

