/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.List;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.KernelBootstrap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.importer.Status;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.Node;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;

@ConfiguredBy(value={})
public abstract class AbstractImportTest
extends AbstractConfigTest {
    private static PortalContainer container;

    protected abstract ImportMode getMode();

    protected abstract String getConfig2();

    protected abstract String getConfig1();

    protected abstract void afterOnePhaseBoot(NodeContext<?> var1);

    protected abstract void afterTwoPhasesBoot(NodeContext<?> var1);

    protected abstract void afterTwoPhaseOverrideReboot(NodeContext<?> var1);

    @Override
    protected void setUp() {
    }

    @Override
    protected void tearDown() {
    }

    protected void beforeClass() {
        if (container != null) {
            RootContainer.getInstance().stop();
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    protected void afterClass() {
        if (container != null) {
            RootContainer.getInstance().stop();
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    public PortalContainer getContainer() {
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnePhase() throws Exception {
        KernelBootstrap bootstrap = this.startContainer(false, true, true, false);
        System.setProperty("override.1", "true");
        System.setProperty("import.mode.1", "overwrite");
        System.setProperty("import.portal.1", this.getConfig1());
        System.setProperty("override_2", "true");
        System.setProperty("import.mode_2", this.getMode().toString());
        System.setProperty("import.portal_2", this.getConfig2());
        this.bootContainer(bootstrap);
        NavigationService service = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.begin();
        try {
            NavigationContext nav = service.loadNavigation(SiteKey.portal((String)"classic"));
            NodeContext root = service.loadNode(Node.MODEL, nav, Scope.ALL, null);
            this.afterOnePhaseBoot(root);
        }
        finally {
            this.restartTransaction();
            this.clearPortalData(container);
            this.end();
            bootstrap.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoPhasesOverride() throws Exception {
        NodeContext root;
        NavigationContext nav;
        KernelBootstrap bootstrap = this.startContainer(false, true, false, false);
        System.setProperty("override.1", "true");
        System.setProperty("import.mode.1", this.getMode().toString());
        System.setProperty("import.portal.1", this.getConfig1());
        this.bootContainer(bootstrap);
        NavigationService service = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.begin();
        try {
            nav = service.loadNavigation(SiteKey.portal((String)"classic"));
            root = service.loadNode(Node.MODEL, nav, Scope.ALL, null);
            this.afterTwoPhasesBoot(root);
        }
        finally {
            this.restartTransaction();
            this.end();
            this.stopContainer(bootstrap);
        }
        System.setProperty("import.portal.1", this.getConfig2());
        this.bootContainer(bootstrap);
        service = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.begin();
        try {
            nav = service.loadNavigation(SiteKey.portal((String)"classic"));
            root = service.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
            this.afterTwoPhaseOverrideReboot(root);
        }
        finally {
            this.restartTransaction();
            this.clearPortalData(container);
            this.end();
            this.stopContainer(bootstrap);
        }
    }

    private void clearPortalData(PortalContainer container) throws Exception {
        PortalConfig portalConfig;
        LayoutService dataStorage = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        List portalNames = dataStorage.getSiteNames(SiteType.GROUP, 0, 200);
        for (String portalName : portalNames) {
            portalConfig = dataStorage.getPortalConfig(PortalConfig.GROUP_TYPE, portalName);
            dataStorage.remove(portalConfig);
        }
        portalNames = dataStorage.getSiteNames(SiteType.PORTAL, 0, 200);
        for (String portalName : portalNames) {
            portalConfig = dataStorage.getPortalConfig(PortalConfig.PORTAL_TYPE, portalName);
            dataStorage.remove(portalConfig);
        }
        dataStorage.saveImportStatus(Status.WANT_REIMPORT);
    }

    protected void stopContainer(KernelBootstrap bootstrap) {
        PortalContainer portalContainer;
        if (bootstrap != null) {
            bootstrap.dispose();
        }
        if ((portalContainer = PortalContainer.getInstanceIfPresent()) != null) {
            RootContainer.getInstance().stop();
            ExoContainerContext.setCurrentContainer(null);
            container = null;
        }
    }

    protected void bootContainer(KernelBootstrap bootstrap) {
        bootstrap.boot();
        container = bootstrap.getContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
    }

    protected KernelBootstrap startContainer(boolean importFile0, boolean importFile1, boolean importFile2, boolean importFile3) {
        PortalContainer portalContainer = PortalContainer.getInstanceIfPresent();
        if (portalContainer != null) {
            RootContainer.getInstance().stop();
            ExoContainerContext.setCurrentContainer(null);
        }
        KernelBootstrap bootstrap = new KernelBootstrap();
        bootstrap.addConfiguration(ContainerScope.ROOT, "conf/configuration.xml");
        bootstrap.addConfiguration(ContainerScope.PORTAL, "conf/portal/configuration.xml");
        bootstrap.addConfiguration(ContainerScope.PORTAL, "conf/exo.portal.component.portal-configuration-local.xml");
        if (importFile0) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport0-configuration.xml");
        }
        if (importFile1) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport1-configuration.xml");
        }
        if (importFile2) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport2-configuration.xml");
        }
        if (importFile3) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport3-configuration.xml");
        }
        return bootstrap;
    }
}

