/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.tree.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.exoplatform.portal.tree.list.ListTree;

public class TestListTree
extends TestCase {
    private static IntegerTree tree(String name, int value, IntegerTree ... trees) {
        IntegerTree tree = new IntegerTree(value);
        if (trees != null) {
            for (IntegerTree child : trees) {
                tree.insertAt(null, child);
            }
        }
        return tree;
    }

    private void assertChildren(IntegerTree tree, Integer ... expected) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        ListIterator iterator = tree.listIterator();
        while (iterator.hasNext()) {
            IntegerTree next = (IntegerTree)((Object)iterator.next());
            children.add(next.value);
        }
        TestListTree.assertEquals(Arrays.asList(expected), children);
    }

    private void assertAllChildren(IntegerTree tree, Integer ... expected) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        for (IntegerTree current = (IntegerTree)tree.getFirst(); current != null; current = (IntegerTree)current.getNext()) {
            children.add(current.value);
        }
        TestListTree.assertEquals(Arrays.asList(expected), children);
    }

    private void assertAllChildren(IntegerTree tree) {
        this.assertAllChildren(tree, new Integer[0]);
    }

    public void testInsert1() {
        IntegerTree root = TestListTree.tree("", 0, new IntegerTree[0]);
        this.assertChildren(root, new Integer[0]);
        this.assertAllChildren(root);
        root = TestListTree.tree("", 0, new IntegerTree[0]);
        root.insertAt(0, TestListTree.tree("a", 1, new IntegerTree[0]));
        this.assertChildren(root, 1);
        this.assertAllChildren(root, 1);
        root = TestListTree.tree("", 0, new IntegerTree[0]);
        root.insertAt(null, TestListTree.tree("a", 1, new IntegerTree[0]));
        this.assertChildren(root, 1);
        this.assertAllChildren(root, 1);
    }

    public void testInsertMove1() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree b = TestListTree.tree("b", 2, new IntegerTree[0]);
        IntegerTree root1 = TestListTree.tree("", 0, a, b);
        root1.insertAt(0, b);
        this.assertAllChildren(root1, 2, 1);
    }

    public void testInsertMove2() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree root1 = TestListTree.tree("", 0, a);
        root1.insertAt(null, a);
        this.assertAllChildren(root1, 1);
        root1.insertAt(0, a);
        this.assertAllChildren(root1, 1);
    }

    public void testInsertMove3() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree root1 = TestListTree.tree("", 0, a);
        IntegerTree root2 = TestListTree.tree("", 0, new IntegerTree[0]);
        root2.insertAt(0, a);
        this.assertAllChildren(root1);
        this.assertAllChildren(root2, 1);
        TestListTree.assertSame((Object)((Object)root2), (Object)a.getParent());
    }

    public void testInsertReorder1() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree root1 = TestListTree.tree("", 0, a);
        root1.insertAt(0, a);
        this.assertAllChildren(root1, 1);
        TestListTree.assertSame((Object)((Object)root1), (Object)a.getParent());
    }

    public void testInsertReorder2() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree root1 = TestListTree.tree("", 0, a, TestListTree.tree("b", 2, new IntegerTree[0]));
        root1.insertAt(2, a);
        this.assertAllChildren(root1, 2, 1);
        TestListTree.assertSame((Object)((Object)root1), (Object)a.getParent());
        root1.insertAt(0, a);
        this.assertAllChildren(root1, 1, 2);
        TestListTree.assertSame((Object)((Object)root1), (Object)a.getParent());
    }

    public void testRemove() {
        IntegerTree root = TestListTree.tree("", 0, TestListTree.tree("a", 1, new IntegerTree[0]), TestListTree.tree("b", 2, new IntegerTree[0]), TestListTree.tree("c", 3, new IntegerTree[0]));
        this.assertAllChildren(root, 1, 2, 3);
        IntegerTree b = (IntegerTree)root.get(1);
        b.remove();
        TestListTree.assertNull((Object)b.getParent());
        TestListTree.assertNull((Object)b.getPrevious());
        TestListTree.assertNull((Object)b.getNext());
        TestListTree.assertEquals((int)2, (int)b.value);
        this.assertAllChildren(root, 1, 3);
    }

    public void testRemoveLast() {
        IntegerTree root = TestListTree.tree("", 0, TestListTree.tree("a", 1, new IntegerTree[0]), TestListTree.tree("b", 2, new IntegerTree[0]));
        this.assertAllChildren(root, 1, 2);
        IntegerTree b = (IntegerTree)root.get(1);
        TestListTree.assertEquals((int)2, (int)b.value);
        b.remove();
        this.assertAllChildren(root, 1);
        TestListTree.assertEquals((int)1, (int)((IntegerTree)root.getLast()).value);
    }

    public void testIteratorRemove() {
        IntegerTree root = TestListTree.tree("", 0, TestListTree.tree("a", 1, new IntegerTree[0]));
        ListIterator it = root.listIterator();
        try {
            it.remove();
            TestListTree.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        IntegerTree a = (IntegerTree)((Object)it.next());
        it.remove();
        TestListTree.assertNull((Object)a.getParent());
        TestListTree.assertFalse((boolean)it.hasNext());
        this.assertAllChildren(root);
    }

    public void testListIterator1() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree root = TestListTree.tree("", 0, a);
        ListIterator i = root.listIterator();
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)0, (int)i.nextIndex());
        TestListTree.assertFalse((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)-1, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)a), i.next());
        TestListTree.assertFalse((boolean)i.hasNext());
        TestListTree.assertEquals((int)1, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)0, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)a), i.previous());
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)0, (int)i.nextIndex());
        TestListTree.assertFalse((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)-1, (int)i.previousIndex());
    }

    public void testListIterator2() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree b = TestListTree.tree("b", 2, new IntegerTree[0]);
        IntegerTree root = TestListTree.tree("", 0, a, b);
        ListIterator i = root.listIterator();
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)0, (int)i.nextIndex());
        TestListTree.assertFalse((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)-1, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)a), i.next());
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)1, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)0, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)b), i.next());
        TestListTree.assertFalse((boolean)i.hasNext());
        TestListTree.assertEquals((int)2, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)1, (int)i.previousIndex());
        i.remove();
        TestListTree.assertFalse((boolean)i.hasNext());
        TestListTree.assertEquals((int)1, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)0, (int)i.previousIndex());
    }

    public void testListIterator3() {
        IntegerTree a = TestListTree.tree("a", 1, new IntegerTree[0]);
        IntegerTree b = TestListTree.tree("b", 2, new IntegerTree[0]);
        IntegerTree c = TestListTree.tree("c", 3, new IntegerTree[0]);
        IntegerTree root = TestListTree.tree("", 0, a, b, c);
        ListIterator i = root.listIterator();
        i.next();
        i.next();
        i.remove();
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)1, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)0, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)c), i.next());
        a = TestListTree.tree("a", 1, new IntegerTree[0]);
        root = TestListTree.tree("", 0, a, b = TestListTree.tree("b", 2, new IntegerTree[0]), c = TestListTree.tree("c", 3, new IntegerTree[0]));
        i = root.listIterator();
        i.next();
        i.next();
        i.next();
        i.previous();
        i.previous();
        i.remove();
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)1, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)0, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)c), i.next());
        a = TestListTree.tree("a", 1, new IntegerTree[0]);
        root = TestListTree.tree("", 0, a, b = TestListTree.tree("b", 2, new IntegerTree[0]), c = TestListTree.tree("c", 3, new IntegerTree[0]));
        i = root.listIterator();
        i.next();
        i.next();
        i.remove();
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)1, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)0, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)a), i.previous());
        a = TestListTree.tree("a", 1, new IntegerTree[0]);
        root = TestListTree.tree("", 0, a, b = TestListTree.tree("b", 2, new IntegerTree[0]), c = TestListTree.tree("c", 3, new IntegerTree[0]));
        i = root.listIterator();
        i.next();
        i.next();
        i.next();
        i.previous();
        i.previous();
        i.remove();
        TestListTree.assertTrue((boolean)i.hasNext());
        TestListTree.assertEquals((int)1, (int)i.nextIndex());
        TestListTree.assertTrue((boolean)i.hasPrevious());
        TestListTree.assertEquals((int)0, (int)i.previousIndex());
        TestListTree.assertSame((Object)((Object)a), i.previous());
    }

    public void testListIteratorNavigation() {
        IntegerTree root = TestListTree.tree("", 0, TestListTree.tree("1", 1, new IntegerTree[0]), TestListTree.tree("2", 2, new IntegerTree[0]), TestListTree.tree("3", 3, new IntegerTree[0]), TestListTree.tree("4", 4, new IntegerTree[0]), TestListTree.tree("5", 5, new IntegerTree[0]));
        ListIterator it = root.listIterator();
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        TestListTree.assertEquals((int)-1, (int)it.previousIndex());
        TestListTree.assertEquals((int)0, (int)it.nextIndex());
        TestListTree.assertEquals((int)1, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)0, (int)it.previousIndex());
        TestListTree.assertEquals((int)1, (int)it.nextIndex());
        TestListTree.assertEquals((int)1, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        TestListTree.assertEquals((int)-1, (int)it.previousIndex());
        TestListTree.assertEquals((int)0, (int)it.nextIndex());
        TestListTree.assertEquals((int)1, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)0, (int)it.previousIndex());
        TestListTree.assertEquals((int)1, (int)it.nextIndex());
        TestListTree.assertEquals((int)2, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)1, (int)it.previousIndex());
        TestListTree.assertEquals((int)2, (int)it.nextIndex());
        TestListTree.assertEquals((int)2, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)0, (int)it.previousIndex());
        TestListTree.assertEquals((int)1, (int)it.nextIndex());
        TestListTree.assertEquals((int)2, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)1, (int)it.previousIndex());
        TestListTree.assertEquals((int)2, (int)it.nextIndex());
        TestListTree.assertEquals((int)3, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)2, (int)it.previousIndex());
        TestListTree.assertEquals((int)3, (int)it.nextIndex());
        TestListTree.assertEquals((int)4, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)3, (int)it.previousIndex());
        TestListTree.assertEquals((int)4, (int)it.nextIndex());
        TestListTree.assertEquals((int)5, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)4, (int)it.previousIndex());
        TestListTree.assertEquals((int)5, (int)it.nextIndex());
        TestListTree.assertEquals((int)5, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)3, (int)it.previousIndex());
        TestListTree.assertEquals((int)4, (int)it.nextIndex());
        TestListTree.assertEquals((int)4, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)2, (int)it.previousIndex());
        TestListTree.assertEquals((int)3, (int)it.nextIndex());
        TestListTree.assertEquals((int)3, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)1, (int)it.previousIndex());
        TestListTree.assertEquals((int)2, (int)it.nextIndex());
        TestListTree.assertEquals((int)2, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((boolean)it.hasPrevious());
        TestListTree.assertEquals((int)0, (int)it.previousIndex());
        TestListTree.assertEquals((int)1, (int)it.nextIndex());
        TestListTree.assertEquals((int)1, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertTrue((boolean)it.hasNext());
        TestListTree.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        TestListTree.assertEquals((int)-1, (int)it.previousIndex());
        TestListTree.assertEquals((int)0, (int)it.nextIndex());
    }

    public void testListIteratorRemove() {
        IntegerTree root = TestListTree.tree("", 0, TestListTree.tree("1", 1, new IntegerTree[0]), TestListTree.tree("2", 2, new IntegerTree[0]), TestListTree.tree("3", 3, new IntegerTree[0]), TestListTree.tree("4", 4, new IntegerTree[0]), TestListTree.tree("5", 5, new IntegerTree[0]));
        ListIterator it = root.listIterator();
        try {
            it.remove();
            TestListTree.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestListTree.assertEquals((int)1, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertEquals((int)2, (int)((IntegerTree)((Object)it.next())).value);
        this.assertAllChildren(root, 1, 2, 3, 4, 5);
        it.remove();
        this.assertAllChildren(root, 1, 3, 4, 5);
        TestListTree.assertEquals((int)3, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertEquals((int)3, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertEquals((int)1, (int)((IntegerTree)((Object)it.previous())).value);
        it.remove();
        this.assertAllChildren(root, 3, 4, 5);
        TestListTree.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        TestListTree.assertEquals((int)3, (int)((IntegerTree)((Object)it.next())).value);
        it.remove();
        this.assertAllChildren(root, 4, 5);
        try {
            it.remove();
            TestListTree.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestListTree.assertEquals((int)4, (int)((IntegerTree)((Object)it.next())).value);
        TestListTree.assertEquals((int)5, (int)((IntegerTree)((Object)it.next())).value);
        it.remove();
        this.assertAllChildren(root, 4);
        TestListTree.assertEquals((int)4, (int)((IntegerTree)((Object)it.previous())).value);
        it.remove();
        this.assertAllChildren(root);
    }

    public void testListIteratorAdd() {
        IntegerTree root = TestListTree.tree("", 0, new IntegerTree[0]);
        ListIterator it = root.listIterator();
        it.add(TestListTree.tree("a", 1, new IntegerTree[0]));
        TestListTree.assertEquals((int)0, (int)it.previousIndex());
        TestListTree.assertEquals((int)1, (int)it.nextIndex());
        this.assertAllChildren(root, 1);
        it.add(TestListTree.tree("c", 3, new IntegerTree[0]));
        TestListTree.assertEquals((int)1, (int)it.previousIndex());
        TestListTree.assertEquals((int)2, (int)it.nextIndex());
        this.assertAllChildren(root, 1, 3);
        it.add(TestListTree.tree("e", 5, new IntegerTree[0]));
        TestListTree.assertEquals((int)2, (int)it.previousIndex());
        TestListTree.assertEquals((int)3, (int)it.nextIndex());
        this.assertAllChildren(root, 1, 3, 5);
        TestListTree.assertEquals((int)5, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertEquals((int)1, (int)it.previousIndex());
        TestListTree.assertEquals((int)2, (int)it.nextIndex());
        it.add(TestListTree.tree("d", 4, new IntegerTree[0]));
        TestListTree.assertEquals((int)2, (int)it.previousIndex());
        TestListTree.assertEquals((int)3, (int)it.nextIndex());
        this.assertAllChildren(root, 1, 3, 4, 5);
        TestListTree.assertEquals((int)4, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertEquals((int)1, (int)it.previousIndex());
        TestListTree.assertEquals((int)2, (int)it.nextIndex());
        TestListTree.assertEquals((int)3, (int)((IntegerTree)((Object)it.previous())).value);
        TestListTree.assertEquals((int)0, (int)it.previousIndex());
        TestListTree.assertEquals((int)1, (int)it.nextIndex());
        it.add(TestListTree.tree("b", 2, new IntegerTree[0]));
        TestListTree.assertEquals((int)1, (int)it.previousIndex());
        TestListTree.assertEquals((int)2, (int)it.nextIndex());
        this.assertAllChildren(root, 1, 2, 3, 4, 5);
    }

    public void testListIteratorMove() {
        IntegerTree root = TestListTree.tree("", 0, TestListTree.tree("a", 1, new IntegerTree[0]), TestListTree.tree("b", 2, new IntegerTree[0]), TestListTree.tree("c", 3, new IntegerTree[0]));
        ListIterator it = root.listIterator();
        it.add((IntegerTree)root.get(2));
        this.assertAllChildren(root, 3, 1, 2);
    }

    public void testInsertFirstThrowsNPE() {
        IntegerTree a = TestListTree.tree("a", 0, new IntegerTree[0]);
        try {
            a.insertFirst(null);
            TestListTree.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testInsertLastThrowsNPE() {
        IntegerTree a = TestListTree.tree("a", 0, new IntegerTree[0]);
        try {
            a.insertLast(null);
            TestListTree.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testInsertBeforeThrowsNPE() {
        IntegerTree a = TestListTree.tree("a", 0, new IntegerTree[0]);
        try {
            a.insertBefore(null);
            TestListTree.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testInsertBeforeThrowsISE() {
        IntegerTree a = TestListTree.tree("a", 0, new IntegerTree[0]);
        IntegerTree b = TestListTree.tree("b", 1, new IntegerTree[0]);
        try {
            a.insertBefore(b);
            TestListTree.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInsertAfterThrowsNPE() {
        IntegerTree a = TestListTree.tree("a", 0, new IntegerTree[0]);
        try {
            a.insertAfter(null);
            TestListTree.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testInsertAfterThrowsISE() {
        IntegerTree a = TestListTree.tree("a", 0, new IntegerTree[0]);
        IntegerTree b = TestListTree.tree("b", 1, new IntegerTree[0]);
        try {
            a.insertAfter(b);
            TestListTree.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRemoveThrowsISE() {
        IntegerTree a = TestListTree.tree("a", 0, new IntegerTree[0]);
        try {
            a.remove();
            TestListTree.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static class IntegerTree
    extends ListTree<IntegerTree> {
        private final int value;

        public IntegerTree(int value) {
            this.value = value;
        }
    }
}

