/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeContextChangeAdapter;
import org.exoplatform.portal.mop.navigation.NodeFilter;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.junit.Assert;

public class Node {
    public static final NodeModel<Node> MODEL = new NodeModel<Node>(){

        public NodeContext<Node> getContext(Node node) {
            return node.context;
        }

        public Node create(NodeContext<Node> context) {
            return new Node(context);
        }
    };
    final NodeContext<Node> context;

    Node(NodeContext<Node> context) {
        this.context = context;
    }

    public String getId() {
        return this.context.getId();
    }

    public String getHandle() {
        return this.context.handle;
    }

    public String getName() {
        return this.context.getName();
    }

    public void setName(String name) {
        this.context.setName(name);
    }

    public NodeContext getContext() {
        return this.context;
    }

    public NodeState getState() {
        return this.context.getState();
    }

    public void setState(NodeState state) {
        this.context.setState(state);
    }

    public Node getParent() {
        return (Node)this.context.getParentNode();
    }

    public Collection<Node> getChildren() {
        return this.context.getNodes();
    }

    public Node getChild(String childName) {
        return (Node)this.context.getNode(childName);
    }

    public Node getChild(int childIndex) {
        return (Node)this.context.getNode(childIndex);
    }

    public void addChild(Node child) {
        this.context.add(null, child.context);
    }

    public void addChild(int index, Node child) {
        this.context.add(Integer.valueOf(index), child.context);
    }

    public Node addChild(String childName) {
        return (Node)this.context.add(null, (String)childName).node;
    }

    public Node addChild(int index, String childName) {
        return (Node)this.context.add((Integer)Integer.valueOf((int)index), (String)childName).node;
    }

    public boolean removeChild(String childName) {
        return this.context.removeNode(childName);
    }

    public int getNodeCount() {
        return this.context.getNodeCount();
    }

    public int getSize() {
        return this.context.getSize();
    }

    public void setHidden(boolean hidden) {
        this.context.setHidden(hidden);
    }

    public boolean isHidden() {
        return this.context.isHidden();
    }

    public void filter(NodeFilter filter) {
        this.context.filter(filter);
    }

    public void assertConsistent() {
        if (this.context.isExpanded()) {
            Object b;
            ArrayList<String> a = new ArrayList<String>();
            for (b = (NodeContext)this.context.getFirst(); b != null; b = (NodeContext)b.getNext()) {
                Assert.assertNotNull((Object)b.data);
                a.add(b.data.getId());
            }
            b = Arrays.asList(this.context.data.children);
            Assert.assertEquals(a, (Object)b);
            for (NodeContext c = (NodeContext)this.context.getFirst(); c != null; c = (NodeContext)c.getNext()) {
                ((Node)c.getNode()).assertConsistent();
            }
        }
    }

    public void assertEquals(Node node) {
        if (this.context.data != null) {
            Assert.assertNotNull((Object)node.context.data);
            Assert.assertEquals((Object)this.context.data.id, (Object)node.context.data.id);
            Assert.assertEquals((Object)this.context.data.name, (Object)node.context.data.name);
            Assert.assertEquals((Object)this.context.data.state, (Object)node.context.data.state);
            Assert.assertEquals((Object)this.context.state, (Object)node.context.state);
        } else {
            Assert.assertNull((Object)node.context.data);
            Assert.assertEquals((Object)this.context.getName(), (Object)node.context.getName());
            Assert.assertEquals((Object)this.context.state, (Object)node.context.state);
        }
        ArrayList<Node> nodes1 = new ArrayList<Node>();
        for (NodeContext current = (NodeContext)this.context.getFirst(); current != null; current = (NodeContext)current.getNext()) {
            nodes1.add((Node)current.getNode());
        }
        ArrayList<Node> nodes2 = new ArrayList<Node>();
        for (NodeContext current = (NodeContext)node.context.getFirst(); current != null; current = (NodeContext)current.getNext()) {
            nodes2.add((Node)current.getNode());
        }
        Assert.assertEquals((String)("Was expecting to have the same children for node " + this.toString(1) + " " + node.toString(1)), (long)nodes1.size(), (long)nodes2.size());
        for (int i = 0; i < nodes1.size(); ++i) {
            ((Node)nodes1.get(i)).assertEquals((Node)nodes2.get(i));
        }
    }

    public Iterator<NodeChange<Node>> update(NavigationService service, Scope scope) throws NavigationServiceException {
        NodeChangeQueue queue = new NodeChangeQueue();
        service.updateNode(this.context, scope, (NodeChangeListener)new NodeContextChangeAdapter((NodeChangeListener)queue));
        return queue.iterator();
    }

    public Iterator<NodeChange<Node>> rebase(NavigationService service, Scope scope) throws NavigationServiceException {
        NodeChangeQueue queue = new NodeChangeQueue();
        service.rebaseNode(this.context, scope, (NodeChangeListener)new NodeContextChangeAdapter((NodeChangeListener)queue));
        return queue.iterator();
    }

    public Iterator<NodeChange<Node>> save(NavigationService service) throws NavigationServiceException {
        NodeChangeQueue queue = new NodeChangeQueue();
        service.saveNode(this.context, (NodeChangeListener)new NodeContextChangeAdapter((NodeChangeListener)queue));
        return queue.iterator();
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int depth) {
        return this.context.toString(depth, new StringBuilder("Node[")).append("]").toString();
    }
}

