/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.junit.Assert;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestLoadedPOM
extends AbstractConfigTest {
    private LayoutService layoutService;
    private PageStorage pageStorage;
    private NavigationService navService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        PortalContainer container = this.getContainer();
        this.layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        this.pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        this.navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
    }

    public void testLegacyGroupWithNormalizedName() throws Exception {
        SiteKey key = SiteKey.group((String)"/test/legacy");
        NavigationContext nav = this.navService.loadNavigation(key);
        TestLoadedPOM.assertNotNull((Object)nav);
        NodeContext root = this.navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
        NodeContext node = (NodeContext)root.get(0);
        TestLoadedPOM.assertEquals((Object)SiteKey.group((String)"/test/legacy").page("register"), (Object)node.getState().getPageRef());
        Page page = this.layoutService.getPage("group::/test/legacy::register");
        TestLoadedPOM.assertNotNull((Object)page);
        TestLoadedPOM.assertEquals((String)"group::/test/legacy::register", (String)page.getPageId());
        TestLoadedPOM.assertEquals((String)"/test/legacy", (String)page.getOwnerId());
    }

    public void testGroupWithNormalizedName() throws Exception {
        SiteKey key = SiteKey.group((String)"/test/normalized");
        this.restartTransaction();
        NavigationContext nav = this.navService.loadNavigation(key);
        TestLoadedPOM.assertNotNull((Object)nav);
        NodeContext root = this.navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
        NodeContext node = (NodeContext)root.get(0);
        TestLoadedPOM.assertEquals((Object)SiteKey.group((String)"/test/normalized").page("register"), (Object)node.getState().getPageRef());
        Page page = this.layoutService.getPage("group::/test/normalized::register");
        TestLoadedPOM.assertNotNull((Object)page);
        TestLoadedPOM.assertEquals((String)"group::/test/normalized::register", (String)page.getPageId());
        TestLoadedPOM.assertEquals((String)"/test/normalized", (String)page.getOwnerId());
    }

    public void testPageProfiles() throws Exception {
        try (MockedStatic exoContainer = Mockito.mockStatic(ExoContainer.class);){
            exoContainer.when(ExoContainer::getProfiles).thenReturn(Stream.of("test").collect(Collectors.toSet()));
            SiteKey key = SiteKey.portal((String)"profiles");
            NavigationContext nav = this.navService.loadNavigation(key);
            TestLoadedPOM.assertNotNull((Object)nav);
            NodeContext root = this.navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
            NodeContext node = (NodeContext)root.get(0);
            TestLoadedPOM.assertEquals((String)"register", (String)node.getName());
            TestLoadedPOM.assertNull((Object)node.getState().getPageRef());
            node = (NodeContext)root.get(1);
            TestLoadedPOM.assertEquals((String)"register2", (String)node.getName());
            TestLoadedPOM.assertEquals((Object)SiteKey.portal((String)"profiles").page("register2"), (Object)node.getState().getPageRef());
            Page page = this.layoutService.getPage("portal::profiles::register");
            TestLoadedPOM.assertNotNull((Object)page);
            TestLoadedPOM.assertEquals((String)"portal::profiles::register", (String)page.getPageId());
            TestLoadedPOM.assertEquals((String)"profiles", (String)page.getOwnerId());
            TestLoadedPOM.assertEquals((String)"unknown", (String)page.getProfiles());
            page = this.layoutService.getPage("portal::profiles::register2");
            TestLoadedPOM.assertNotNull((Object)page);
            TestLoadedPOM.assertEquals((String)"portal::profiles::register2", (String)page.getPageId());
            TestLoadedPOM.assertEquals((String)"profiles", (String)page.getOwnerId());
            TestLoadedPOM.assertEquals((String)"test", (String)page.getProfiles());
            node = (NodeContext)root.get(0);
            NodeContext subNode = node.get("subpage");
            TestLoadedPOM.assertNotNull((Object)subNode);
            TestLoadedPOM.assertEquals((String)"subpage", (String)subNode.getName());
            TestLoadedPOM.assertEquals((Object)SiteKey.portal((String)"profiles").page("subpage"), (Object)subNode.getState().getPageRef());
        }
    }

    public void testPageWithSections() throws Exception {
        Page page = this.layoutService.getPage("portal::profiles::sections");
        TestLoadedPOM.assertNotNull((Object)page);
        TestLoadedPOM.assertEquals((int)1, (int)page.getChildren().size());
        Container sectionsParent = (Container)page.getChildren().get(0);
        TestLoadedPOM.assertEquals((String)"system:/groovy/portal/webui/container/UIPageLayout.gtmpl", (String)sectionsParent.getTemplate());
        TestLoadedPOM.assertEquals((int)2, (int)sectionsParent.getChildren().size());
        Container columnsSection = (Container)sectionsParent.getChildren().get(0);
        TestLoadedPOM.assertEquals((int)2, (int)columnsSection.getChildren().size());
        TestLoadedPOM.assertEquals((String)"FlexContainer", (String)columnsSection.getTemplate());
        TestLoadedPOM.assertNotNull((Object)columnsSection.getCssClass());
        TestLoadedPOM.assertTrue((String)"'grid-cols-md-12' not found", (boolean)columnsSection.getCssClass().contains("grid-cols-md-12"));
        TestLoadedPOM.assertTrue((String)"'grid-cols-lg-12' not found", (boolean)columnsSection.getCssClass().contains("grid-cols-lg-12"));
        TestLoadedPOM.assertTrue((String)"'grid-cols-xl-12' not found", (boolean)columnsSection.getCssClass().contains("grid-cols-xl-12"));
        TestLoadedPOM.assertTrue((String)"'layout-mobile-columns' not found", (boolean)columnsSection.getCssClass().contains("layout-mobile-columns"));
        TestLoadedPOM.assertTrue((String)"'layout-sticky-application' not found", (boolean)columnsSection.getCssClass().contains("layout-sticky-application"));
        TestLoadedPOM.assertFalse((String)"'grid-rows' should not be present", (boolean)columnsSection.getCssClass().contains("grid-rows"));
        TestLoadedPOM.assertTrue((String)"'TEST-columns-section-class' not found", (boolean)columnsSection.getCssClass().contains("TEST-columns-section-class"));
        Container column = (Container)columnsSection.getChildren().get(0);
        TestLoadedPOM.assertEquals((int)1, (int)column.getChildren().size());
        TestLoadedPOM.assertEquals((String)"CellContainer", (String)column.getTemplate());
        TestLoadedPOM.assertNotNull((Object)column.getCssClass());
        TestLoadedPOM.assertTrue((String)"'flex-cell' not found", (boolean)column.getCssClass().contains("flex-cell"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-colspan-md-9' not found", (boolean)column.getCssClass().contains("grid-cell-colspan-md-9"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-colspan-lg-9' not found", (boolean)column.getCssClass().contains("grid-cell-colspan-lg-9"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-colspan-xl-9' not found", (boolean)column.getCssClass().contains("grid-cell-colspan-xl-9"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-rowspan-md-1' not found", (boolean)column.getCssClass().contains("grid-cell-rowspan-md-1"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-rowspan-lg-1' not found", (boolean)column.getCssClass().contains("grid-cell-rowspan-lg-1"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-rowspan-xl-1' not found", (boolean)column.getCssClass().contains("grid-cell-rowspan-xl-1"));
        TestLoadedPOM.assertTrue((String)"'TEST-column-class' custom class not found", (boolean)column.getCssClass().contains("TEST-column-class"));
        Application columnApplication = (Application)column.getChildren().get(0);
        TestLoadedPOM.assertNotNull((Object)columnApplication.getCssClass());
        TestLoadedPOM.assertTrue((String)"'mt-n1' not found", (boolean)columnApplication.getCssClass().contains("mt-n1"));
        TestLoadedPOM.assertTrue((String)"'mb-n3' not found", (boolean)columnApplication.getCssClass().contains("mb-n3"));
        TestLoadedPOM.assertTrue((String)"'me-n4' not found", (boolean)columnApplication.getCssClass().contains("me-n4"));
        TestLoadedPOM.assertTrue((String)"'ms-n5' not found", (boolean)columnApplication.getCssClass().contains("ms-n5"));
        TestLoadedPOM.assertTrue((String)"'brtr-4' not found", (boolean)columnApplication.getCssClass().contains("brtr-4"));
        TestLoadedPOM.assertTrue((String)"'brtl-2' not found", (boolean)columnApplication.getCssClass().contains("brtl-2"));
        TestLoadedPOM.assertTrue((String)"'brbr-1' not found", (boolean)columnApplication.getCssClass().contains("brbr-1"));
        TestLoadedPOM.assertTrue((String)"'brbl-0' not found", (boolean)columnApplication.getCssClass().contains("brbl-0"));
        TestLoadedPOM.assertTrue((String)"'hidden-sm-and-down' not found", (boolean)columnApplication.getCssClass().contains("hidden-sm-and-down"));
        Container gridSection = (Container)sectionsParent.getChildren().get(1);
        TestLoadedPOM.assertEquals((int)3, (int)gridSection.getChildren().size());
        TestLoadedPOM.assertEquals((String)"GridContainer", (String)gridSection.getTemplate());
        TestLoadedPOM.assertNotNull((Object)gridSection.getCssClass());
        TestLoadedPOM.assertTrue((String)"'grid-cols-md-4' not found", (boolean)gridSection.getCssClass().contains("grid-cols-md-4"));
        TestLoadedPOM.assertTrue((String)"'grid-cols-lg-4' not found", (boolean)gridSection.getCssClass().contains("grid-cols-lg-4"));
        TestLoadedPOM.assertTrue((String)"'grid-cols-xl-4' not found", (boolean)gridSection.getCssClass().contains("grid-cols-xl-4"));
        TestLoadedPOM.assertTrue((String)"'grid-rows-md-2' not found", (boolean)gridSection.getCssClass().contains("grid-rows-md-2"));
        TestLoadedPOM.assertTrue((String)"'grid-rows-lg-2' not found", (boolean)gridSection.getCssClass().contains("grid-rows-lg-2"));
        TestLoadedPOM.assertTrue((String)"'grid-rows-xl-2' not found", (boolean)gridSection.getCssClass().contains("grid-rows-xl-2"));
        TestLoadedPOM.assertTrue((String)"'TEST-grid-section-class' not found", (boolean)gridSection.getCssClass().contains("TEST-grid-section-class"));
        Container cell = (Container)gridSection.getChildren().get(0);
        TestLoadedPOM.assertEquals((int)1, (int)cell.getChildren().size());
        TestLoadedPOM.assertEquals((String)"CellContainer", (String)cell.getTemplate());
        TestLoadedPOM.assertNotNull((Object)cell.getCssClass());
        TestLoadedPOM.assertTrue((String)"'grid-cell' not found", (boolean)cell.getCssClass().contains("grid-cell"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-colspan-md-2' not found", (boolean)cell.getCssClass().contains("grid-cell-colspan-md-2"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-colspan-lg-2' not found", (boolean)cell.getCssClass().contains("grid-cell-colspan-lg-2"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-colspan-xl-2' not found", (boolean)cell.getCssClass().contains("grid-cell-colspan-xl-2"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-rowspan-md-3' not found", (boolean)cell.getCssClass().contains("grid-cell-rowspan-md-3"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-rowspan-lg-3' not found", (boolean)cell.getCssClass().contains("grid-cell-rowspan-lg-3"));
        TestLoadedPOM.assertTrue((String)"'grid-cell-rowspan-xl-3' not found", (boolean)cell.getCssClass().contains("grid-cell-rowspan-xl-3"));
        TestLoadedPOM.assertTrue((String)"'TEST-grid-cell-class' custom class not found", (boolean)cell.getCssClass().contains("TEST-grid-cell-class"));
        TestLoadedPOM.assertTrue((String)"'mt-n5' not found", (boolean)cell.getCssClass().contains("mt-n5"));
        TestLoadedPOM.assertTrue((String)"'mb-n4' not found", (boolean)cell.getCssClass().contains("mb-n4"));
        TestLoadedPOM.assertTrue((String)"'me-n3' not found", (boolean)cell.getCssClass().contains("me-n3"));
        TestLoadedPOM.assertTrue((String)"'ms-n1' not found", (boolean)cell.getCssClass().contains("ms-n1"));
        TestLoadedPOM.assertTrue((String)"'brtr-0' not found", (boolean)cell.getCssClass().contains("brtr-0"));
        TestLoadedPOM.assertTrue((String)"'brtl-1' not found", (boolean)cell.getCssClass().contains("brtl-1"));
        TestLoadedPOM.assertTrue((String)"'brbr-2' not found", (boolean)cell.getCssClass().contains("brbr-2"));
        TestLoadedPOM.assertTrue((String)"'brbl-4' not found", (boolean)cell.getCssClass().contains("brbl-4"));
        TestLoadedPOM.assertTrue((String)"'hidden-sm-and-down' not found", (boolean)cell.getCssClass().contains("hidden-sm-and-down"));
    }

    public void testNavigation() throws Exception {
        SiteKey key = SiteKey.portal((String)"test");
        NavigationContext nav = this.navService.loadNavigation(key);
        TestLoadedPOM.assertNotNull((Object)nav);
        TestLoadedPOM.assertEquals((int)1, (int)nav.getState().getPriority());
        NodeContext root = this.navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
        TestLoadedPOM.assertEquals((int)5, (int)root.getNodeCount());
        NodeContext nodeNavigation = (NodeContext)root.get(0);
        TestLoadedPOM.assertEquals((int)0, (int)nodeNavigation.getNodeCount());
        TestLoadedPOM.assertEquals((String)"node_name", (String)nodeNavigation.getName());
        TestLoadedPOM.assertEquals((String)"node_label", (String)nodeNavigation.getState().getLabel());
        TestLoadedPOM.assertEquals((String)"node_icon", (String)nodeNavigation.getState().getIcon());
        GregorianCalendar start = new GregorianCalendar(2000, 2, 21, 1, 33, 0);
        start.setTimeZone(TimeZone.getTimeZone("UTC"));
        TestLoadedPOM.assertEquals((long)start.getTime().getTime(), (long)nodeNavigation.getState().getStartPublicationTime());
        GregorianCalendar end = new GregorianCalendar(2009, 2, 21, 1, 33, 0);
        end.setTimeZone(TimeZone.getTimeZone("UTC"));
        TestLoadedPOM.assertEquals((long)end.getTime().getTime(), (long)nodeNavigation.getState().getEndPublicationTime());
        TestLoadedPOM.assertEquals((Object)Visibility.TEMPORAL, (Object)nodeNavigation.getState().getVisibility());
    }

    public void testLoadNode() throws Exception {
        NodeContext root = this.navService.loadNode(SiteKey.portal((String)"test"));
        TestLoadedPOM.assertEquals((int)5, (int)root.getNodeCount());
        NodeContext nodeNavigation = this.navService.loadNode(SiteKey.portal((String)"test"), "node_name");
        TestLoadedPOM.assertEquals((int)0, (int)nodeNavigation.getNodeCount());
        TestLoadedPOM.assertEquals((String)"node_name", (String)nodeNavigation.getName());
        TestLoadedPOM.assertEquals((String)"node_label", (String)nodeNavigation.getState().getLabel());
        TestLoadedPOM.assertEquals((String)"node_icon", (String)nodeNavigation.getState().getIcon());
        GregorianCalendar start = new GregorianCalendar(2000, 2, 21, 1, 33, 0);
        start.setTimeZone(TimeZone.getTimeZone("UTC"));
        TestLoadedPOM.assertEquals((long)start.getTime().getTime(), (long)nodeNavigation.getState().getStartPublicationTime());
        GregorianCalendar end = new GregorianCalendar(2009, 2, 21, 1, 33, 0);
        end.setTimeZone(TimeZone.getTimeZone("UTC"));
        TestLoadedPOM.assertEquals((long)end.getTime().getTime(), (long)nodeNavigation.getState().getEndPublicationTime());
        TestLoadedPOM.assertEquals((Object)Visibility.TEMPORAL, (Object)nodeNavigation.getState().getVisibility());
    }

    public void testPortal() throws Exception {
        PortalConfig portal = this.layoutService.getPortalConfig("test");
        TestLoadedPOM.assertNotNull((Object)portal);
        TestLoadedPOM.assertEquals((String)"test", (String)portal.getName());
        TestLoadedPOM.assertEquals((String)"en", (String)portal.getLocale());
        Assert.assertArrayEquals((Object[])new String[]{"test_portal_access_permissions"}, (Object[])portal.getAccessPermissions());
        TestLoadedPOM.assertEquals((String)"test_edit_permission", (String)portal.getEditPermission());
        TestLoadedPOM.assertEquals((String)"test_skin", (String)portal.getSkin());
        TestLoadedPOM.assertEquals((String)"test_prop_value", (String)portal.getProperty("prop_key"));
    }

    public void testPageWithoutPageId() throws Exception {
        Page page = this.layoutService.getPage("portal::test::test2");
        TestLoadedPOM.assertNotNull((Object)page);
        TestLoadedPOM.assertEquals((String)"portal::test::test2", (String)page.getPageId());
        TestLoadedPOM.assertEquals((String)"test", (String)page.getOwnerId());
        TestLoadedPOM.assertEquals((String)"portal", (String)page.getOwnerType());
        TestLoadedPOM.assertEquals((String)"test2", (String)page.getName());
    }

    public void testPage() throws Exception {
        Page page = this.layoutService.getPage("portal::test::test1");
        TestLoadedPOM.assertNotNull((Object)page);
        PageContext pageContext = this.pageStorage.loadPage(page.getPageKey());
        TestLoadedPOM.assertNotNull((Object)pageContext);
        TestLoadedPOM.assertEquals((String)"test_title", (String)pageContext.getState().getDisplayName());
        TestLoadedPOM.assertEquals((String)"test_factory_id", (String)pageContext.getState().getFactoryId());
        TestLoadedPOM.assertEquals(Arrays.asList("test_access_permissions"), (Object)pageContext.getState().getAccessPermissions());
        TestLoadedPOM.assertEquals((String)"test_edit_permission", (String)pageContext.getState().getEditPermission());
        TestLoadedPOM.assertEquals((boolean)true, (boolean)pageContext.getState().isShowMaxWindow());
        ArrayList children = page.getChildren();
        TestLoadedPOM.assertEquals((int)2, (int)children.size());
        Container container1 = (Container)children.get(0);
        TestLoadedPOM.assertEquals((String)"container_1", (String)container1.getName());
        TestLoadedPOM.assertEquals((String)"container_1_title", (String)container1.getTitle());
        TestLoadedPOM.assertEquals((String)"container_1_icon", (String)container1.getIcon());
        TestLoadedPOM.assertEquals((String)"container_1_template", (String)container1.getTemplate());
        TestLoadedPOM.assertTrue((boolean)Arrays.equals(new String[]{"container_1_access_permissions"}, container1.getAccessPermissions()));
        TestLoadedPOM.assertEquals((String)"container_1_factory_id", (String)container1.getFactoryId());
        TestLoadedPOM.assertEquals((String)"container_1_description", (String)container1.getDescription());
        TestLoadedPOM.assertEquals((String)"container_1_width", (String)container1.getWidth());
        TestLoadedPOM.assertEquals((String)"container_1_height", (String)container1.getHeight());
        Application application1 = (Application)children.get(1);
        TestLoadedPOM.assertEquals((String)"application_1_theme", (String)application1.getTheme());
        TestLoadedPOM.assertEquals((String)"application_1_title", (String)application1.getTitle());
        TestLoadedPOM.assertTrue((boolean)Arrays.equals(new String[]{"application_1_access_permissions"}, application1.getAccessPermissions()));
        TestLoadedPOM.assertEquals((boolean)true, (boolean)application1.getShowInfoBar());
        TestLoadedPOM.assertEquals((boolean)true, (boolean)application1.getShowApplicationState());
        TestLoadedPOM.assertEquals((boolean)true, (boolean)application1.getShowApplicationMode());
        TestLoadedPOM.assertEquals((String)"application_1_description", (String)application1.getDescription());
        TestLoadedPOM.assertEquals((String)"application_1_icon", (String)application1.getIcon());
        TestLoadedPOM.assertEquals((String)"application_1_width", (String)application1.getWidth());
        TestLoadedPOM.assertEquals((String)"application_1_height", (String)application1.getHeight());
    }
}

