/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.portal.jdbc.entity.DescriptionEntity;
import org.exoplatform.portal.jdbc.entity.DescriptionState;
import org.exoplatform.portal.mop.dao.AbstractDAOTest;
import org.exoplatform.portal.mop.dao.DescriptionDAO;

public class DescriptionDAOTest
extends AbstractDAOTest {
    private DescriptionDAO descDAO;

    @Override
    protected void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.descDAO = (DescriptionDAO)this.getContainer().getComponentInstanceOfType(DescriptionDAO.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.descDAO.deleteAll();
        super.tearDown();
        this.end();
    }

    public void testCreate() {
        DescriptionEntity desc = this.createDescription("testCreate");
        this.descDAO.create((Object)desc);
        this.restartTransaction();
        DescriptionEntity result = (DescriptionEntity)this.descDAO.find((Serializable)desc.getId());
        DescriptionDAOTest.assertNotNull((Object)result);
        this.assertDescription(desc, result);
    }

    public void testSave() {
        DescriptionEntity desc = this.createDescription("testSave");
        this.descDAO.create((Object)desc);
        this.restartTransaction();
        this.descDAO.saveDescription("testSave", new DescriptionState("testName2", "testDesc2"));
        this.restartTransaction();
        DescriptionEntity result = (DescriptionEntity)this.descDAO.find((Serializable)desc.getId());
        DescriptionDAOTest.assertEquals((String)"testName2", (String)result.getState().getName());
        DescriptionDAOTest.assertEquals((String)"testDesc2", (String)result.getState().getDescription());
    }

    public void testSave2() {
        DescriptionEntity desc = this.createDescription("testSave2");
        this.descDAO.create((Object)desc);
        this.restartTransaction();
        HashMap<String, DescriptionState> localized = new HashMap<String, DescriptionState>();
        localized.put(I18N.toTagIdentifier((Locale)Locale.FRENCH), new DescriptionState("name1", "desc1"));
        localized.put(I18N.toTagIdentifier((Locale)Locale.ITALY), new DescriptionState("name2", "desc2"));
        this.descDAO.saveDescriptions("testSave2", localized);
        this.restartTransaction();
        DescriptionEntity result = (DescriptionEntity)this.descDAO.find((Serializable)desc.getId());
        DescriptionDAOTest.assertNotNull((Object)result.getLocalized());
        Map resultLocalized = result.getLocalized();
        DescriptionDAOTest.assertEquals((int)2, (int)resultLocalized.size());
        DescriptionDAOTest.assertEquals((Object)new DescriptionState("name1", "desc1"), resultLocalized.get(I18N.toTagIdentifier((Locale)Locale.FRENCH)));
        DescriptionDAOTest.assertEquals((Object)new DescriptionState("name2", "desc2"), resultLocalized.get(I18N.toTagIdentifier((Locale)Locale.ITALY)));
    }

    public void testDelete() {
        DescriptionEntity desc = this.createDescription("testDelete");
        this.descDAO.create((Object)desc);
        this.restartTransaction();
        this.descDAO.deleteByRefId("testDelete");
        this.restartTransaction();
        DescriptionDAOTest.assertNull((Object)this.descDAO.find((Serializable)desc.getId()));
        DescriptionDAOTest.assertNull((Object)this.descDAO.getByRefId("testDelete"));
    }

    private void assertDescription(DescriptionEntity expected, DescriptionEntity result) {
        DescriptionDAOTest.assertEquals((String)expected.getReferenceId(), (String)result.getReferenceId());
        DescriptionDAOTest.assertEquals((Object)expected.getId(), (Object)result.getId());
        DescriptionDAOTest.assertEquals((Object)expected.getState(), (Object)result.getState());
        if (expected.getLocalized() == null) {
            DescriptionDAOTest.assertNull((Object)result.getLocalized());
        } else {
            DescriptionDAOTest.assertEquals((int)expected.getLocalized().size(), (int)result.getLocalized().size());
            for (String locale : expected.getLocalized().keySet()) {
                DescriptionDAOTest.assertEquals(expected.getLocalized().get(locale), result.getLocalized().get(locale));
            }
        }
    }

    private DescriptionEntity createDescription(String refId) {
        DescriptionEntity desc = new DescriptionEntity();
        desc.setReferenceId(refId);
        DescriptionState state = new DescriptionState("testName", "testDesc");
        desc.setState(state);
        HashMap<String, DescriptionState> localized = new HashMap<String, DescriptionState>();
        localized.put(I18N.toTagIdentifier((Locale)Locale.FRENCH), new DescriptionState("testName1", "testDesc1"));
        localized.put(I18N.toTagIdentifier((Locale)Locale.ENGLISH), new DescriptionState("testName2", "testDesc2"));
        desc.setLocalized(localized);
        return desc;
    }
}

