/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.HashSet;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.services.resources.LocaleConfigService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewPortalConfigListenerTest {
    @Mock
    private UserPortalConfigService owner;
    @Mock
    private LayoutService layoutService;
    @Mock
    private ConfigurationManager configurationManager;
    @Mock
    private NavigationService navigationService;
    @Mock
    private InitParams initParams;
    @Mock
    private DescriptionStorage descriptionStorage;
    @Mock
    private UserACL userACL;
    @Mock
    private LocaleConfigService localeConfigService;

    @Test
    public void testInitPageDB() {
        ValueParam valueParam = new ValueParam();
        valueParam.setName("meta.portal");
        valueParam.setValue("classic");
        Mockito.when((Object)this.initParams.getValueParam("meta.portal")).thenReturn((Object)valueParam);
        NewPortalConfigListener newPortalConfigListener = new NewPortalConfigListener(this.owner, this.layoutService, this.configurationManager, this.initParams, this.navigationService, this.descriptionStorage, this.userACL, this.localeConfigService);
        newPortalConfigListener.createdOwners.add("global");
        HashSet<String> predefinedOwner = new HashSet<String>();
        predefinedOwner.add("global");
        NewPortalConfig newPortalConfig = (NewPortalConfig)Mockito.mock(NewPortalConfig.class);
        Mockito.when((Object)newPortalConfig.getPredefinedOwner()).thenReturn(predefinedOwner);
        Mockito.when((Object)newPortalConfig.getImportMode()).thenReturn((Object)"overwrite");
        Mockito.when((Object)newPortalConfig.getOwnerType()).thenReturn((Object)PortalConfig.PORTAL_TYPE);
        PageContext pageContext = (PageContext)Mockito.mock(PageContext.class);
        ArrayList<PageContext> allPages = new ArrayList<PageContext>();
        allPages.add(pageContext);
        Mockito.when((Object)this.layoutService.findPages((SiteKey)Mockito.any(SiteKey.class))).thenReturn(allPages);
        newPortalConfigListener.initPageDB(newPortalConfig);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.times((int)1))).removePages((SiteKey)Mockito.any());
        Mockito.reset((Object[])new LayoutService[]{this.layoutService});
        Mockito.when((Object)newPortalConfig.getImportMode()).thenReturn((Object)"merge");
        newPortalConfigListener.initPageDB(newPortalConfig);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.times((int)0))).removePages((SiteKey)Mockito.any());
    }
}

