/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.KernelBootstrap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.mop.importer.ImportMode;

@ConfiguredBy(value={})
public abstract class AbstractDataImportTest
extends AbstractConfigTest {
    private Set<String> clearProperties = new HashSet<String>();
    private PortalContainer container;

    protected abstract ImportMode getMode();

    protected abstract String getConfig2();

    protected abstract String getConfig1();

    protected void afterOneBootWithExtention(PortalContainer container) throws Exception {
    }

    protected void afterFirstBoot(PortalContainer container) throws Exception {
    }

    protected abstract void afterSecondBoot(PortalContainer var1) throws Exception;

    protected abstract void afterSecondBootWithOverride(PortalContainer var1) throws Exception;

    protected abstract void afterSecondBootWithWantReimport(PortalContainer var1) throws Exception;

    protected abstract void afterSecondBootWithNoMixin(PortalContainer var1) throws Exception;

    protected void setSystemProperty(String key, String value) {
        this.clearProperties.add(key);
        System.setProperty(key, value);
    }

    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
        for (String key : this.clearProperties) {
            System.clearProperty(key);
        }
        this.clearProperties.clear();
    }

    protected void beforeClass() {
    }

    protected void afterClass() {
    }

    public PortalContainer getContainer() {
        return this.container;
    }

    public void testOneBootWithExtension() throws Exception {
        KernelBootstrap bootstrap = this.startContainer(false, true, true, false);
        this.setSystemProperty("override.1", "true");
        this.setSystemProperty("import.mode.1", this.getMode().toString());
        this.setSystemProperty("import.portal.1", this.getConfig1());
        this.setSystemProperty("override_2", "true");
        this.setSystemProperty("import.mode_2", this.getMode().toString());
        this.setSystemProperty("import.portal_2", this.getConfig2());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterOneBootWithExtention(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
    }

    public void testOneBoot() throws Exception {
        KernelBootstrap bootstrap = this.startContainer(false, true, false, false);
        this.setSystemProperty("override.1", "false");
        this.setSystemProperty("import.mode.1", this.getMode().toString());
        this.setSystemProperty("import.portal.1", this.getConfig1());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterFirstBoot(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
    }

    public void testTwoBoots() throws Exception {
        KernelBootstrap bootstrap = this.startContainer(false, true, false, false);
        this.setSystemProperty("override.1", "false");
        this.setSystemProperty("import.mode.1", this.getMode().toString());
        this.setSystemProperty("import.portal.1", this.getConfig1());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterFirstBoot(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
        this.setSystemProperty("import.portal.1", this.getConfig2());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterSecondBoot(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
    }

    public void testTwoBootsWithOverride() throws Exception {
        KernelBootstrap bootstrap = this.startContainer(false, true, false, false);
        this.setSystemProperty("override.1", "true");
        this.setSystemProperty("import.mode.1", this.getMode().toString());
        this.setSystemProperty("import.portal.1", this.getConfig1());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterFirstBoot(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
        this.setSystemProperty("import.portal.1", this.getConfig2());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterSecondBootWithOverride(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
    }

    public void testTwoBootsWithPortalConfigOverrideFlag() throws Exception {
        KernelBootstrap bootstrap = this.startContainer(false, false, false, true);
        this.setSystemProperty("override.1", "true");
        this.setSystemProperty("override.2", "false");
        this.setSystemProperty("import.mode.1", this.getMode().toString());
        this.setSystemProperty("import.portal.1", this.getConfig1());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterFirstBoot(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
        this.setSystemProperty("import.portal.1", this.getConfig2());
        this.bootContainer(bootstrap);
        this.begin();
        try {
            this.afterSecondBoot(this.container);
        }
        finally {
            this.end();
        }
        this.stopContainer(bootstrap);
    }

    protected void stopContainer(KernelBootstrap bootstrap) {
        PortalContainer portalContainer;
        if (bootstrap != null) {
            bootstrap.dispose();
        }
        if ((portalContainer = PortalContainer.getInstanceIfPresent()) != null) {
            RootContainer.getInstance().stop();
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    protected void bootContainer(KernelBootstrap bootstrap) {
        bootstrap.boot();
        this.container = bootstrap.getContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
    }

    protected KernelBootstrap startContainer(boolean importFile0, boolean importFile1, boolean importFile2, boolean importFile3) {
        PortalContainer portalContainer = PortalContainer.getInstanceIfPresent();
        if (portalContainer != null) {
            RootContainer.getInstance().stop();
            ExoContainerContext.setCurrentContainer(null);
        }
        KernelBootstrap bootstrap = new KernelBootstrap();
        bootstrap.addConfiguration(ContainerScope.ROOT, "conf/configuration.xml");
        bootstrap.addConfiguration(ContainerScope.PORTAL, "conf/portal/configuration.xml");
        bootstrap.addConfiguration(ContainerScope.PORTAL, "conf/exo.portal.component.portal-configuration-local.xml");
        if (importFile0) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport0-configuration.xml");
        }
        if (importFile1) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport1-configuration.xml");
        }
        if (importFile2) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport2-configuration.xml");
        }
        if (importFile3) {
            bootstrap.addConfiguration(ContainerScope.PORTAL, "org/exoplatform/portal/config/TestImport3-configuration.xml");
        }
        return bootstrap;
    }
}

