/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="bundles/resource-bundle-configuration.xml")})
public class TestResourceBundleService
extends AbstractKernelTest {
    private static String test_res = "bundles.portal.test";
    private ResourceBundleService service_;
    private LocaleConfigService lservice_;
    private Locale localeBK;

    public TestResourceBundleService(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.localeBK = Locale.getDefault();
        PortalContainer manager = PortalContainer.getInstance();
        this.service_ = (ResourceBundleService)manager.getComponentInstanceOfType(ResourceBundleService.class);
        this.lservice_ = (LocaleConfigService)manager.getComponentInstanceOfType(LocaleConfigService.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Locale.setDefault(this.localeBK);
    }

    public void testDefaultLocale() {
        TestResourceBundleService.assertEquals((Object)Locale.FRENCH, (Object)this.lservice_.getDefaultLocaleConfig().getLocale());
        Locale.setDefault(Locale.ENGLISH);
        ResourceBundle res = this.service_.getResourceBundle(test_res, Locale.GERMAN);
        TestResourceBundleService.assertEquals((String)"French", (String)res.getString("language"));
        res = this.service_.getResourceBundle(test_res, new Locale("vi"));
        TestResourceBundleService.assertEquals((String)"TiengViet", (String)res.getString("language"));
        TestResourceBundleService.assertEquals((String)"base_vi.xml", (String)res.getString("base_vi"));
        res = this.service_.getResourceBundle("bundles.portlet.test", Locale.GERMAN);
        TestResourceBundleService.assertEquals((String)"French", (String)res.getString("language"));
    }

    public void testXMLResourceBunble() {
        ResourceBundle res = this.service_.getResourceBundle(test_res, new Locale("vi"));
        TestResourceBundleService.assertEquals((String)"base_vi.xml", (String)res.getString("base_vi"));
    }

    public void testCachingPortletBundle() {
        String oldValue = PropertyManager.getProperty((String)"exo.product.developing");
        try {
            PropertyManager.setProperty((String)"exo.product.developing", (String)"true");
            TestResourceBundleService.assertTrue((boolean)PropertyManager.isDevelopping());
            ResourceBundle res = this.service_.getResourceBundle("bundles.portlet.test", Locale.ENGLISH);
            TestResourceBundleService.assertNotNull((Object)res);
            TestResourceBundleService.assertTrue((res != this.service_.getResourceBundle("bundles.portlet.test", Locale.ENGLISH) ? 1 : 0) != 0);
            PropertyManager.setProperty((String)"exo.product.developing", (String)"false");
            TestResourceBundleService.assertFalse((boolean)PropertyManager.isDevelopping());
            res = this.service_.getResourceBundle("bundles.portlet.test", Locale.ENGLISH);
            TestResourceBundleService.assertNotNull((Object)res);
            TestResourceBundleService.assertTrue((res == this.service_.getResourceBundle("bundles.portlet.test", Locale.ENGLISH) ? 1 : 0) != 0);
        }
        finally {
            PropertyManager.setProperty((String)"exo.product.developing", (String)oldValue);
        }
    }

    public void testPortalFallbackLocale() {
        this.assertFallback("portal");
    }

    public void testPortletFallbackLocale() {
        this.assertFallback("portlet");
    }

    private void assertFallback(String app) {
        String baseName = "bundles." + app + ".base";
        ResourceBundle res = this.service_.getResourceBundle(baseName, Locale.ENGLISH);
        TestResourceBundleService.assertEquals((String)"English", (String)res.getString("language"));
        res = this.service_.getResourceBundle(baseName, Locale.FRENCH);
        TestResourceBundleService.assertEquals((String)"Default", (String)res.getString("language"));
        res = this.service_.getResourceBundle(baseName, Locale.GERMAN);
        TestResourceBundleService.assertEquals((String)"Default", (String)res.getString("language"));
        baseName = "bundles." + app + ".no-base";
        res = this.service_.getResourceBundle(baseName, Locale.ENGLISH);
        TestResourceBundleService.assertEquals((String)"English", (String)res.getString("language"));
        res = this.service_.getResourceBundle(baseName, new Locale("vi"));
        TestResourceBundleService.assertEquals((String)"TiengViet", (String)res.getString("language"));
        TestResourceBundleService.assertEquals((String)"base_vi.properties", (String)res.getString("base_vi"));
        res = this.service_.getResourceBundle(baseName, Locale.GERMAN);
        TestResourceBundleService.assertEquals((String)"English", (String)res.getString("language"));
        TestResourceBundleService.assertEquals((String)"base_en.properties", (String)res.getString("base_en"));
        res = this.service_.getResourceBundle("NotExistingFile", Locale.ENGLISH);
        TestResourceBundleService.assertNull((Object)res);
    }

    public void testResourceBundleServiceUpdate() throws Exception {
        String bundle = "portal.locale";
        String PROPERTIES = "language=en";
        String PROPERTIES_FR = "language=fr\nproperty=property";
        String PROPERTIES_EN_UPDATE = "language=en\nproperty=en-property";
        this.createResourceBundle(bundle, PROPERTIES, Locale.ENGLISH);
        this.createResourceBundle(bundle, PROPERTIES_FR, Locale.FRENCH);
        ResourceBundle res = this.service_.getResourceBundle(bundle, Locale.ENGLISH);
        TestResourceBundleService.assertEquals((String)"en", (String)res.getString("language"));
        TestResourceBundleService.assertEquals((String)"property", (String)res.getString("property"));
        res = this.service_.getResourceBundle(bundle, Locale.FRENCH);
        TestResourceBundleService.assertEquals((String)"fr", (String)res.getString("language"));
        this.createResourceBundle(bundle, PROPERTIES_EN_UPDATE, Locale.ENGLISH);
        res = this.service_.getResourceBundle(bundle, Locale.ENGLISH);
        TestResourceBundleService.assertEquals((String)"en-property", (String)res.getString("property"));
        ResourceBundleData data = this.service_.getResourceBundleData(bundle + "_en");
        this.service_.removeResourceBundleData(data.getId());
        TestResourceBundleService.assertNull((Object)this.service_.getResourceBundleData(bundle + "_en"));
    }

    private void createResourceBundle(String name, String datas, Locale locale) throws Exception {
        ResourceBundleData data = this.service_.createResourceBundleDataInstance();
        data.setName(name);
        data.setData(datas);
        data.setLanguage(locale.getLanguage());
        if (locale.getCountry().trim().length() != 0) {
            data.setCountry(locale.getCountry());
        }
        this.service_.saveResourceBundle(data);
    }
}

