/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.util.Collection;
import java.util.Locale;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.resources.AbstractResourceBundleTest;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;

public class TestLocaleConfig
extends AbstractResourceBundleTest {
    private LocaleConfigService service_;

    public TestLocaleConfig(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.service_ = (LocaleConfigService)PortalContainer.getInstance().getComponentInstanceOfType(LocaleConfigService.class);
    }

    public void tearDown() throws Exception {
    }

    public void testLocaleConfigManager() throws Exception {
        LocaleConfig locale = this.service_.getDefaultLocaleConfig();
        TestLocaleConfig.assertTrue((String)"expect defautl locale config is found", (locale != null ? 1 : 0) != 0);
        TestLocaleConfig.assertEquals((String)"expect default locale is English", (Object)Locale.ENGLISH, (Object)locale.getLocale());
        locale = this.service_.getLocaleConfig("fr");
        TestLocaleConfig.assertTrue((String)"expect locale config is found", (locale != null ? 1 : 0) != 0);
        TestLocaleConfig.assertTrue((String)"expect France locale is found", (boolean)locale.getLocale().equals(Locale.FRENCH));
        locale = this.service_.getLocaleConfig("vi");
        TestLocaleConfig.assertTrue((String)"expect locale config is found", (locale != null ? 1 : 0) != 0);
        TestLocaleConfig.assertEquals((String)"expect Viet Nam locale is found", (String)"vi", (String)locale.getLocale().toString());
        Collection locales = this.service_.getLocalConfigs();
        TestLocaleConfig.assertTrue((locales.size() == 4 ? 1 : 0) != 0);
        Locale vnlocale = this.service_.getLocaleConfig("vi").getLocale();
        this.assertContains(locales, vnlocale);
        this.assertContains(locales, Locale.ENGLISH);
        this.assertContains(locales, Locale.FRENCH);
    }

    private void assertContains(Collection<LocaleConfig> configs, Locale locale) {
        for (LocaleConfig config : configs) {
            if (!config.getLocale().equals(locale)) continue;
            return;
        }
        TestLocaleConfig.fail((String)("Was expecting locale " + String.valueOf(locale) + " to be present in " + String.valueOf(configs)));
    }
}

