/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import org.exoplatform.component.test.BaseGateInTest;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.regexp.RERenderer;
import org.exoplatform.web.controller.regexp.REVisitor;
import org.exoplatform.web.controller.regexp.SyntaxException;
import org.exoplatform.web.controller.router.CaptureGroupTransformation;
import org.exoplatform.web.controller.router.NonCaptureGroupTransformation;

public class TestGroupTransformation
extends BaseGateInTest {
    public void testCapturing() throws SyntaxException, IOException {
        this.assertCapturing("a", "(a)");
        this.assertCapturing("(a)", "(a)");
        this.assertCapturing("a(b)c", "a(b)c");
        this.assertCapturing("(a)?", "((?:a)?)");
        this.assertCapturing("a|b", "(a)|(b)");
        this.assertCapturing("(a)|b", "(a)|(b)");
        this.assertCapturing("(a|b)", "(a|b)");
        this.assertCapturing("(a)(b)", "((?:a)(?:b))");
        this.assertCapturing("(a)|", "(a)|()");
        this.assertCapturing("|(a)", "()|(a)");
        this.assertCapturing("|", "()|()");
    }

    public void testNonCapturing() throws SyntaxException, IOException {
        this.assertNonCapturing("a", "(a)");
        this.assertNonCapturing("(a)", "((?:a))");
        this.assertNonCapturing("a(b)c", "(a(?:b)c)");
        this.assertNonCapturing("(a)|b", "((?:a)|b)");
    }

    private void assertNonCapturing(String test, String expected) throws SyntaxException, IOException {
        this.assertTransform(test, expected, false);
    }

    private void assertCapturing(String test, String expected) throws SyntaxException, IOException {
        this.assertTransform(test, expected, true);
    }

    private void assertTransform(String test, String expected, boolean capturing) throws SyntaxException, IOException {
        RENode node = new REParser((CharSequence)test).parse();
        CaptureGroupTransformation transformer = capturing ? new CaptureGroupTransformation() : new NonCaptureGroupTransformation();
        node.accept((REVisitor)transformer);
        StringBuilder sb = new StringBuilder();
        RERenderer renderer = new RERenderer((Appendable)sb);
        node.accept((REVisitor)renderer);
        TestGroupTransformation.assertEquals((String)expected, (String)sb.toString());
    }
}

