/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.component.test.BaseGateInTest;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.regexp.RERenderer;
import org.exoplatform.web.controller.regexp.REVisitor;
import org.exoplatform.web.controller.router.RouteEscaper;

public class TestRouteEscaper
extends BaseGateInTest {
    private void match(String pattern, String test, String expectedValue) throws Exception {
        REParser parser = new REParser((CharSequence)pattern);
        RouteEscaper escaper = new RouteEscaper('/', '_');
        RENode.Disjunction re = parser.parseDisjunction();
        re.accept((REVisitor)escaper);
        Pattern p = Pattern.compile(((StringBuilder)RERenderer.render((RENode)re, (Appendable)new StringBuilder())).toString());
        Matcher matcher = p.matcher(test);
        TestRouteEscaper.assertTrue((boolean)matcher.find());
        TestRouteEscaper.assertEquals((String)expectedValue, (String)matcher.group());
    }

    public void testMatch() throws Exception {
        this.match(".*", "_", "_");
        this.match(".*", "_/", "_");
        this.match(".*", "_/_", "_");
        this.match("/", "_/", "_");
        this.match("/*", "_/_", "_");
        this.match("[/a]*", "_a_/_", "_a_");
        this.match("[,-1&&[^/]]*", "_/_", "");
    }

    public void testGroup() throws Exception {
        this.match("(/)", "_", "_");
        this.match("(?:/)", "_", "_");
        this.match(".(?=/)", "a_", "a");
        this.match("a(?!/)", "ab", "a");
        this.match(".(?<=/)a", "ba_a", "_a");
        this.match(".(?<!/)a", "_aba", "ba");
    }
}

